/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.marker;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SourceSet;

public final class JavaSourceSet
implements SourceSet {
    private final UUID id;
    private final String name;
    private final List<JavaType.FullyQualified> classpath;

    public static JavaSourceSet build(String sourceSetName, Collection<Path> classpath, JavaTypeCache ignore, boolean fullTypeInformation) {
        List<String> typeNames;
        if (fullTypeInformation) {
            throw new UnsupportedOperationException();
        }
        if (!classpath.iterator().hasNext()) {
            try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableSystemJarsAndModules().acceptPackages(new String[]{"java"}).ignoreClassVisibility().scan();){
                typeNames = JavaSourceSet.packagesToTypeDeclarations(scanResult);
            }
        }
        try (ScanResult scanResult = new ClassGraph().overrideClasspath(classpath).enableSystemJarsAndModules().enableClassInfo().ignoreClassVisibility().scan();){
            typeNames = JavaSourceSet.packagesToTypeDeclarations(scanResult);
        }
        typeNames.add("java.lang.Object");
        return new JavaSourceSet(Tree.randomId(), sourceSetName, JavaSourceSet.typesFrom(typeNames));
    }

    private static List<String> packagesToTypeDeclarations(ScanResult scanResult) {
        ArrayList<String> result = new ArrayList<String>();
        for (ClassInfo classInfo : scanResult.getAllClasses()) {
            String typeDeclaration;
            if (classInfo.isAnonymousInnerClass() || classInfo.isPrivate() || classInfo.isSynthetic() || classInfo.getName().contains(".enum.") || classInfo.isStandardClass() && !classInfo.getName().startsWith("java.") || classInfo.getPackageName().startsWith("kotlin.reflect.jvm.internal.impl.resolve.jvm") || (typeDeclaration = JavaSourceSet.declarableFullyQualifiedName(classInfo)) == null) continue;
            result.add(typeDeclaration);
        }
        return result;
    }

    private static List<JavaType.FullyQualified> typesFrom(List<String> typeNames) {
        ArrayList<JavaType.FullyQualified> types = new ArrayList<JavaType.FullyQualified>(typeNames.size());
        for (String typeName : typeNames) {
            types.add(JavaType.ShallowClass.build(typeName));
        }
        return types;
    }

    @Nullable
    private static String declarableFullyQualifiedName(ClassInfo classInfo) {
        String name;
        if (classInfo.getName().startsWith("java.") && !classInfo.isPublic()) {
            return null;
        }
        if (classInfo.isInnerClass()) {
            StringBuilder sb = new StringBuilder();
            ClassInfoList outerClasses = classInfo.getOuterClasses();
            for (int i = outerClasses.size() - 1; i >= 0; --i) {
                ClassInfo outerClass = (ClassInfo)outerClasses.get(i);
                if (outerClass.isPrivate() || outerClass.isAnonymousInnerClass() || outerClass.isSynthetic() || outerClass.isExternalClass()) {
                    return null;
                }
                if (i == outerClasses.size() - 1) {
                    sb.append(outerClass.getName()).append(".");
                    continue;
                }
                if (!outerClass.getName().startsWith(sb.toString())) {
                    return classInfo.getName();
                }
                sb.append(outerClass.getName().substring(sb.length())).append(".");
            }
            if (!classInfo.getName().startsWith(sb.toString())) {
                return classInfo.getName();
            }
            String nameFragment = classInfo.getName().substring(sb.length());
            if (JavaSourceSet.isUndeclarable(nameFragment)) {
                return null;
            }
            sb.append(nameFragment);
            name = sb.toString();
        } else {
            name = classInfo.getName();
        }
        if (JavaSourceSet.isUndeclarable(name)) {
            return null;
        }
        return name;
    }

    private static boolean isUndeclarable(String className) {
        char firstChar = className.charAt(0);
        return !Character.isJavaIdentifierPart(firstChar) || Character.isDigit(firstChar);
    }

    public JavaSourceSet(UUID id, String name, List<JavaType.FullyQualified> classpath) {
        this.id = id;
        this.name = name;
        this.classpath = classpath;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<JavaType.FullyQualified> getClasspath() {
        return this.classpath;
    }

    @NonNull
    public String toString() {
        return "JavaSourceSet(id=" + this.getId() + ", name=" + this.getName() + ", classpath=" + this.getClasspath() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaSourceSet)) {
            return false;
        }
        JavaSourceSet other = (JavaSourceSet)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public JavaSourceSet withId(UUID id) {
        return this.id == id ? this : new JavaSourceSet(id, this.name, this.classpath);
    }

    @NonNull
    public JavaSourceSet withName(String name) {
        return this.name == name ? this : new JavaSourceSet(this.id, name, this.classpath);
    }

    @NonNull
    public JavaSourceSet withClasspath(List<JavaType.FullyQualified> classpath) {
        return this.classpath == classpath ? this : new JavaSourceSet(this.id, this.name, classpath);
    }
}

