/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class HasJavaVersion
extends Recipe {
    @Option(displayName="Java version", description="An exact version number or node-style semver selector used to select the version number.", example="17.X")
    private final String version;
    @Option(displayName="Version check against target compatibility", description="The source and target compatibility versions can be different. This option allows you to check against the target compatibility version instead of the source compatibility version.", example="17.X", required=false)
    @Nullable
    private final Boolean checkTargetCompatibility;

    public String getDisplayName() {
        return "Find files compiled at a specific Java version";
    }

    public String getDescription() {
        return "Finds Java source files matching a particular language level. This is useful especially as a precondition for other recipes.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, null));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)this.version, null).getValue());
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree != null) {
                    return tree.getMarkers().findFirst(JavaVersion.class).filter(version -> versionComparator.isValid(null, Integer.toString(Boolean.TRUE.equals(HasJavaVersion.this.checkTargetCompatibility) ? version.getMajorReleaseVersion() : version.getMajorVersion()))).map(version -> SearchResult.found((Tree)tree)).orElse(tree);
                }
                return tree;
            }
        };
    }

    public HasJavaVersion(String version, @Nullable Boolean checkTargetCompatibility) {
        this.version = version;
        this.checkTargetCompatibility = checkTargetCompatibility;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public Boolean getCheckTargetCompatibility() {
        return this.checkTargetCompatibility;
    }

    @NonNull
    public String toString() {
        return "HasJavaVersion(version=" + this.getVersion() + ", checkTargetCompatibility=" + this.getCheckTargetCompatibility() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasJavaVersion)) {
            return false;
        }
        HasJavaVersion other = (HasJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$checkTargetCompatibility = this.getCheckTargetCompatibility();
        Boolean other$checkTargetCompatibility = other.getCheckTargetCompatibility();
        if (this$checkTargetCompatibility == null ? other$checkTargetCompatibility != null : !((Object)this$checkTargetCompatibility).equals(other$checkTargetCompatibility)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof HasJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $checkTargetCompatibility = this.getCheckTargetCompatibility();
        result = result * 59 + ($checkTargetCompatibility == null ? 43 : ((Object)$checkTargetCompatibility).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

