/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.GeneralFormatStyle;

public class AddImport<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final String packageName;
    private final String typeName;
    private final String fullyQualifiedName;
    @Nullable
    private final String member;
    private final boolean onlyIfReferenced;
    @Nullable
    private final String alias;

    public AddImport(String type, @Nullable String member, boolean onlyIfReferenced) {
        int lastDotIdx = type.lastIndexOf(46);
        this.packageName = lastDotIdx != -1 ? type.substring(0, lastDotIdx) : null;
        this.typeName = lastDotIdx != -1 ? type.substring(lastDotIdx + 1) : type;
        this.fullyQualifiedName = type;
        this.member = member;
        this.onlyIfReferenced = onlyIfReferenced;
        this.alias = null;
    }

    public AddImport(@Nullable String packageName, String typeName, @Nullable String member, @Nullable String alias, boolean onlyIfReferenced) {
        this.packageName = packageName;
        this.typeName = typeName.replace('.', '$');
        this.fullyQualifiedName = packageName == null ? typeName : packageName + "." + typeName;
        this.member = member;
        this.onlyIfReferenced = onlyIfReferenced;
        this.alias = alias;
    }

    @Nullable
    public J preVisit(J tree, P p) {
        this.stopAfterPreVisit();
        J j = tree;
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)tree;
            if (this.packageName == null || JavaType.Primitive.fromKeyword(this.fullyQualifiedName) != null) {
                return cu;
            }
            if ("java.lang".equals(this.packageName) && StringUtils.isBlank((String)this.member) || cu.getPackageDeclaration() != null && this.packageName.equals(cu.getPackageDeclaration().getExpression().printTrimmed(this.getCursor()))) {
                return cu;
            }
            if (this.onlyIfReferenced && !this.hasReference(cu)) {
                return cu;
            }
            if (cu.getImports().stream().anyMatch(i -> {
                String ending = i.getQualid().getSimpleName();
                if (this.member == null) {
                    return !i.isStatic() && i.getPackageName().equals(this.packageName) && (ending.equals(this.typeName) || "*".equals(ending));
                }
                return i.isStatic() && i.getTypeName().equals(this.fullyQualifiedName) && (ending.equals(this.member) || "*".equals(ending));
            })) {
                return cu;
            }
            J.Import importToAdd = new J.Import(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JLeftPadded<Boolean>(this.member == null ? Space.EMPTY : Space.SINGLE_SPACE, this.member != null, Markers.EMPTY), (J.FieldAccess)TypeTree.build(this.fullyQualifiedName + (this.member == null ? "" : "." + this.member)).withPrefix(Space.SINGLE_SPACE), null);
            ArrayList<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>(cu.getPadding().getImports());
            if (imports.isEmpty() && !cu.getClasses().isEmpty() && cu.getPackageDeclaration() == null) {
                Space firstClassPrefix = cu.getClasses().get(0).getPrefix();
                importToAdd = importToAdd.withPrefix(firstClassPrefix.withComments(ListUtils.map(firstClassPrefix.getComments(), comment -> comment instanceof Javadoc ? null : comment)).withWhitespace(""));
                cu = cu.withClasses(ListUtils.mapFirst(cu.getClasses(), clazz -> (J.ClassDeclaration)clazz.withComments(ListUtils.map(clazz.getComments(), comment -> comment instanceof Javadoc ? comment : null))));
            }
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            List<JavaType.FullyQualified> classpath = cu.getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getClasspath).orElse(Collections.emptyList());
            List<JRightPadded<J.Import>> newImports = layoutStyle.addImport(cu.getPadding().getImports(), importToAdd, cu.getPackageDeclaration(), classpath);
            newImports = this.checkCRLF(cu, newImports);
            JavaSourceFile c = cu = cu.getPadding().withImports(newImports);
            cu = cu.withClasses(ListUtils.mapFirst(cu.getClasses(), clazz -> {
                J.ClassDeclaration cl = this.autoFormat(clazz, clazz.getName(), p, new Cursor(null, (Object)c));
                return clazz.withPrefix(clazz.getPrefix().withWhitespace(cl.getPrefix().getWhitespace()));
            }));
            j = cu;
        }
        return j;
    }

    private List<JRightPadded<J.Import>> checkCRLF(JavaSourceFile cu, List<JRightPadded<J.Import>> newImports) {
        GeneralFormatStyle generalFormatStyle = Optional.ofNullable((GeneralFormatStyle)cu.getStyle(GeneralFormatStyle.class)).orElse(AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(cu));
        if (generalFormatStyle.isUseCRLFNewLines()) {
            return ListUtils.map(newImports, rp -> rp.map(i -> i.withPrefix(i.getPrefix().withWhitespace(i.getPrefix().getWhitespace().replaceAll("(?<!\r)\n", "\r\n")))));
        }
        return newImports;
    }

    private boolean isTypeReference(NameTree t) {
        boolean isTypRef = true;
        if (t instanceof J.FieldAccess) {
            isTypRef = TypeUtils.isOfClassType(((J.FieldAccess)t).getTarget().getType(), this.fullyQualifiedName);
        }
        return isTypRef;
    }

    private boolean hasReference(JavaSourceFile compilationUnit) {
        if (this.member == null) {
            for (NameTree t : FindTypes.find(compilationUnit, this.fullyQualifiedName)) {
                if (t instanceof J.FieldAccess && ((J.FieldAccess)t).isFullyQualifiedClassReference(this.fullyQualifiedName) || !this.isTypeReference(t)) continue;
                return true;
            }
            return false;
        }
        for (J invocation : FindMethods.find(compilationUnit, this.fullyQualifiedName + " *(..)")) {
            J.MethodInvocation mi;
            if (!(invocation instanceof J.MethodInvocation) || (mi = (J.MethodInvocation)invocation).getSelect() != null || !"*".equals(this.member) && !mi.getName().getSimpleName().equals(this.member)) continue;
            return true;
        }
        AtomicReference<Boolean> hasStaticFieldAccess = new AtomicReference<Boolean>(false);
        new FindStaticFieldAccess().visit(compilationUnit, hasStaticFieldAccess);
        return hasStaticFieldAccess.get();
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddImport)) {
            return false;
        }
        AddImport other = (AddImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.onlyIfReferenced != other.onlyIfReferenced) {
            return false;
        }
        String this$fullyQualifiedName = this.fullyQualifiedName;
        String other$fullyQualifiedName = other.fullyQualifiedName;
        if (this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName)) {
            return false;
        }
        String this$member = this.member;
        String other$member = other.member;
        if (this$member == null ? other$member != null : !this$member.equals(other$member)) {
            return false;
        }
        String this$alias = this.alias;
        String other$alias = other.alias;
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddImport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.onlyIfReferenced ? 79 : 97);
        String $fullyQualifiedName = this.fullyQualifiedName;
        result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
        String $member = this.member;
        result = result * 59 + ($member == null ? 43 : $member.hashCode());
        String $alias = this.alias;
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        return result;
    }

    private class FindStaticFieldAccess
    extends JavaIsoVisitor<AtomicReference<Boolean>> {
        private FindStaticFieldAccess() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, AtomicReference<Boolean> found) {
            for (JavaType.Variable varType : cu.getTypesInUse().getVariables()) {
                if (!varType.getName().equals(AddImport.this.member) || !TypeUtils.isOfClassType(varType.getType(), AddImport.this.fullyQualifiedName)) continue;
                return super.visitCompilationUnit(cu, found);
            }
            return cu;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, AtomicReference<Boolean> found) {
            assert (this.getCursor().getParent() != null);
            if (identifier.getSimpleName().equals(AddImport.this.member) && TypeUtils.isOfClassType(identifier.getType(), AddImport.this.fullyQualifiedName) && !(this.getCursor().getParent().firstEnclosingOrThrow(J.class) instanceof J.FieldAccess)) {
                found.set(true);
            }
            return identifier;
        }
    }
}

