/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="7.24.0")
public class SemanticallyEqual {
    protected SemanticallyEqual() {
    }

    public static boolean areEqual(J firstElem, J secondElem) {
        SemanticallyEqualVisitor semanticallyEqualVisitor = new SemanticallyEqualVisitor(true);
        semanticallyEqualVisitor.visit((Tree)firstElem, secondElem);
        return semanticallyEqualVisitor.isEqual();
    }

    public static boolean areSemanticallyEqual(J firstElem, J secondElem) {
        SemanticallyEqualVisitor semanticallyEqualVisitor = new SemanticallyEqualVisitor(false);
        semanticallyEqualVisitor.visit((Tree)firstElem, secondElem);
        return semanticallyEqualVisitor.isEqual.get();
    }

    protected static class SemanticallyEqualVisitor
    extends JavaIsoVisitor<J> {
        private final boolean compareMethodArguments;
        protected final AtomicBoolean isEqual = new AtomicBoolean(true);
        private final Deque<Map<String, String>> variableScope = new ArrayDeque<Map<String, String>>();
        private final Set<JavaType> seen = new HashSet<JavaType>();

        public SemanticallyEqualVisitor(boolean compareMethodArguments) {
            this.compareMethodArguments = compareMethodArguments;
        }

        public boolean isEqual() {
            return this.isEqual.get();
        }

        protected boolean nullMissMatch(Object obj1, Object obj2) {
            return obj1 == null && obj2 != null || obj1 != null && obj2 == null;
        }

        protected boolean nullListSizeMissMatch(List<?> list1, List<?> list2) {
            return this.nullMissMatch(list1, list2) || list1 != null && list2 != null && list1.size() != list2.size();
        }

        protected boolean modifierListMissMatch(List<J.Modifier> list1, List<J.Modifier> list2) {
            if (list1.size() != list2.size()) {
                return true;
            }
            EnumSet<J.Modifier.Type> modifiers1 = EnumSet.noneOf(J.Modifier.Type.class);
            EnumSet<J.Modifier.Type> modifiers2 = EnumSet.noneOf(J.Modifier.Type.class);
            for (int i = 0; i < list1.size(); ++i) {
                modifiers1.add(list1.get(i).getType());
                modifiers2.add(list2.get(i).getType());
            }
            return !modifiers1.equals(modifiers2);
        }

        protected void visitList(@Nullable List<? extends J> list1, @Nullable List<? extends J> list2) {
            if (!this.isEqual.get() || this.nullListSizeMissMatch(list1, list2)) {
                this.isEqual.set(false);
                return;
            }
            if (list1 != null) {
                for (int i = 0; i < list1.size(); ++i) {
                    this.visit((Tree)list1.get(i), list2.get(i));
                    if (this.isEqual.get()) continue;
                    return;
                }
            }
        }

        public @Nullable J visit(@Nullable Tree tree, J j) {
            return (J)super.visit((Tree)SemanticallyEqualVisitor.unwrap(tree), (Object)SemanticallyEqualVisitor.unwrap(j));
        }

        private static @Nullable J unwrap(@Nullable Tree tree) {
            if (tree instanceof Expression) {
                tree = ((Expression)tree).unwrap();
            }
            if (tree instanceof J.ControlParentheses) {
                tree = SemanticallyEqualVisitor.unwrap(((J.ControlParentheses)tree).getTree());
            }
            return (J)tree;
        }

        public @Nullable J preVisit(J tree, J j) {
            if (this.declaresVariableScope(tree)) {
                this.variableScope.push(new HashMap());
            }
            return tree;
        }

        public @Nullable J postVisit(J tree, J j) {
            if (this.declaresVariableScope(tree)) {
                this.variableScope.pop();
            }
            return tree;
        }

        protected boolean declaresVariableScope(J tree) {
            return tree instanceof J.Lambda;
        }

        @Override
        public Expression visitExpression(Expression expression, J j) {
            if (this.isEqual.get() && !TypeUtils.isOfType(expression.getType(), ((Expression)j).getType())) {
                this.isEqual.set(false);
            }
            return expression;
        }

        @Override
        public J.Annotation visitAnnotation(J.Annotation annotation, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Annotation)) {
                    this.isEqual.set(false);
                    return annotation;
                }
                J.Annotation compareTo = (J.Annotation)j;
                if (!TypeUtils.isOfType(annotation.getType(), compareTo.getType()) || this.nullListSizeMissMatch(annotation.getArguments(), compareTo.getArguments())) {
                    this.isEqual.set(false);
                    return annotation;
                }
                this.visitTypeName((N)annotation.getAnnotationType(), compareTo.getAnnotationType());
                this.visitList(annotation.getArguments(), compareTo.getArguments());
            }
            return annotation;
        }

        @Override
        public J.AnnotatedType visitAnnotatedType(J.AnnotatedType annotatedType, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.AnnotatedType)) {
                    this.isEqual.set(false);
                    return annotatedType;
                }
                J.AnnotatedType compareTo = (J.AnnotatedType)j;
                if (!TypeUtils.isOfType(annotatedType.getType(), compareTo.getType()) || annotatedType.getAnnotations().size() != compareTo.getAnnotations().size()) {
                    this.isEqual.set(false);
                    return annotatedType;
                }
                this.visitTypeName((N)annotatedType.getTypeExpression(), compareTo.getTypeExpression());
                this.visitList(annotatedType.getAnnotations(), compareTo.getAnnotations());
            }
            return annotatedType;
        }

        @Override
        public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.ArrayAccess)) {
                    this.isEqual.set(false);
                    return arrayAccess;
                }
                J.ArrayAccess compareTo = (J.ArrayAccess)j;
                if (!TypeUtils.isOfType(arrayAccess.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return arrayAccess;
                }
                this.visit((Tree)arrayAccess.getIndexed(), compareTo.getIndexed());
                this.visit((Tree)arrayAccess.getDimension(), compareTo.getDimension());
            }
            return arrayAccess;
        }

        @Override
        public J.ArrayDimension visitArrayDimension(J.ArrayDimension arrayDimension, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.ArrayDimension)) {
                    this.isEqual.set(false);
                    return arrayDimension;
                }
                J.ArrayDimension compareTo = (J.ArrayDimension)j;
                this.visit((Tree)arrayDimension.getIndex(), compareTo.getIndex());
            }
            return arrayDimension;
        }

        @Override
        public J.ArrayType visitArrayType(J.ArrayType arrayType, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.ArrayType)) {
                    this.isEqual.set(false);
                    return arrayType;
                }
                J.ArrayType compareTo = (J.ArrayType)j;
                if (!TypeUtils.isOfType(arrayType.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return arrayType;
                }
                this.visitTypeName((N)arrayType.getElementType(), compareTo.getElementType());
            }
            return arrayType;
        }

        @Override
        public J.Assert visitAssert(J.Assert _assert, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Assert)) {
                    this.isEqual.set(false);
                    return _assert;
                }
                J.Assert compareTo = (J.Assert)j;
                if (this.nullMissMatch(_assert.getDetail(), compareTo.getDetail())) {
                    this.isEqual.set(false);
                    return _assert;
                }
                this.visit((Tree)_assert.getCondition(), compareTo.getCondition());
                if (_assert.getDetail() != null && compareTo.getDetail() != null) {
                    this.visit((Tree)_assert.getDetail().getElement(), compareTo.getDetail().getElement());
                }
            }
            return _assert;
        }

        @Override
        public J.Assignment visitAssignment(J.Assignment assignment, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Assignment)) {
                    this.isEqual.set(false);
                    return assignment;
                }
                J.Assignment compareTo = (J.Assignment)j;
                if (!TypeUtils.isOfType(assignment.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return assignment;
                }
                this.visit((Tree)assignment.getAssignment(), compareTo.getAssignment());
                this.visit((Tree)assignment.getVariable(), compareTo.getVariable());
            }
            return assignment;
        }

        @Override
        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.AssignmentOperation)) {
                    this.isEqual.set(false);
                    return assignOp;
                }
                J.AssignmentOperation compareTo = (J.AssignmentOperation)j;
                if (!TypeUtils.isOfType(assignOp.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return assignOp;
                }
                this.visit((Tree)assignOp.getAssignment(), compareTo.getAssignment());
                this.visit((Tree)assignOp.getVariable(), compareTo.getVariable());
            }
            return assignOp;
        }

        @Override
        public J.Binary visitBinary(J.Binary binary, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Binary)) {
                    this.isEqual.set(false);
                    return binary;
                }
                J.Binary compareTo = (J.Binary)j;
                if (binary.getOperator() != compareTo.getOperator() || !TypeUtils.isOfType(binary.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return binary;
                }
                this.visit((Tree)binary.getLeft(), compareTo.getLeft());
                this.visit((Tree)binary.getRight(), compareTo.getRight());
            }
            return binary;
        }

        @Override
        public J.Block visitBlock(J.Block block, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Block)) {
                    this.isEqual.set(false);
                    return block;
                }
                J.Block compareTo = (J.Block)j;
                if (block.getStatements().size() != compareTo.getStatements().size()) {
                    this.isEqual.set(false);
                    return block;
                }
                this.visitList(block.getStatements(), compareTo.getStatements());
            }
            return block;
        }

        @Override
        public J.Break visitBreak(J.Break breakStatement, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Break)) {
                    this.isEqual.set(false);
                    return breakStatement;
                }
                J.Break compareTo = (J.Break)j;
                if (this.nullMissMatch(breakStatement.getLabel(), compareTo.getLabel())) {
                    this.isEqual.set(false);
                    return breakStatement;
                }
                if (breakStatement.getLabel() != null && compareTo.getLabel() != null) {
                    this.visit((Tree)breakStatement.getLabel(), compareTo.getLabel());
                }
            }
            return breakStatement;
        }

        @Override
        public J.Case visitCase(J.Case _case, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Case)) {
                    this.isEqual.set(false);
                    return _case;
                }
                J.Case compareTo = (J.Case)j;
                this.visitList(_case.getStatements(), compareTo.getStatements());
                this.visit((Tree)_case.getBody(), compareTo.getBody());
                this.visitList(_case.getExpressions(), compareTo.getExpressions());
            }
            return _case;
        }

        @Override
        public J.Try.Catch visitCatch(J.Try.Catch _catch, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Try.Catch)) {
                    this.isEqual.set(false);
                    return _catch;
                }
                J.Try.Catch compareTo = (J.Try.Catch)j;
                this.visit(_catch.getParameter(), compareTo.getParameter());
                this.visit((Tree)_catch.getBody(), compareTo.getBody());
            }
            return _catch;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.ClassDeclaration)) {
                    this.isEqual.set(false);
                    return classDecl;
                }
                J.ClassDeclaration compareTo = (J.ClassDeclaration)j;
                if (!classDecl.getSimpleName().equals(compareTo.getSimpleName()) || !TypeUtils.isOfType(classDecl.getType(), compareTo.getType()) || this.modifierListMissMatch(classDecl.getModifiers(), compareTo.getModifiers()) || classDecl.getKind() != compareTo.getKind() || this.nullListSizeMissMatch(classDecl.getPermits(), compareTo.getPermits()) || this.nullListSizeMissMatch(classDecl.getLeadingAnnotations(), compareTo.getLeadingAnnotations()) || this.nullMissMatch(classDecl.getExtends(), compareTo.getExtends()) || this.nullListSizeMissMatch(classDecl.getTypeParameters(), compareTo.getTypeParameters()) || this.nullListSizeMissMatch(classDecl.getImplements(), compareTo.getImplements())) {
                    this.isEqual.set(false);
                    return classDecl;
                }
                this.visitList(classDecl.getPermits(), compareTo.getPermits());
                this.visitList(classDecl.getLeadingAnnotations(), compareTo.getLeadingAnnotations());
                if (classDecl.getExtends() != null && compareTo.getExtends() != null) {
                    this.visit((Tree)classDecl.getExtends(), compareTo.getExtends());
                }
                this.visitList(classDecl.getTypeParameters(), compareTo.getTypeParameters());
                this.visitList(classDecl.getImplements(), compareTo.getImplements());
                this.visit((Tree)classDecl.getBody(), compareTo.getBody());
            }
            return classDecl;
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.CompilationUnit)) {
                    this.isEqual.set(false);
                    return cu;
                }
                J.CompilationUnit compareTo = (J.CompilationUnit)j;
                if (this.nullMissMatch(cu.getPackageDeclaration(), compareTo.getPackageDeclaration()) || cu.getClasses().size() != compareTo.getClasses().size()) {
                    this.isEqual.set(false);
                    return cu;
                }
                if (cu.getPackageDeclaration() != null && compareTo.getPackageDeclaration() != null) {
                    this.visit((Tree)cu.getPackageDeclaration(), compareTo.getPackageDeclaration());
                }
                this.visitList(cu.getClasses(), compareTo.getClasses());
            }
            return cu;
        }

        @Override
        public <T extends J> J.ControlParentheses<T> visitControlParentheses(J.ControlParentheses<T> controlParens, J j) {
            if (this.isEqual.get()) {
                if (j instanceof J.ControlParentheses) {
                    J.ControlParentheses compareTo = (J.ControlParentheses)j;
                    if (!TypeUtils.isOfType(controlParens.getType(), compareTo.getType())) {
                        this.isEqual.set(false);
                        return controlParens;
                    }
                    this.visit((Tree)controlParens.getTree(), (J)compareTo.getTree());
                } else if (j instanceof J.Parentheses) {
                    J.Parentheses compareTo = (J.Parentheses)j;
                    this.visit((Tree)controlParens.getTree(), (J)compareTo.getTree());
                } else {
                    this.isEqual.set(false);
                    return controlParens;
                }
            }
            return controlParens;
        }

        @Override
        public J.Continue visitContinue(J.Continue continueStatement, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Continue)) {
                    this.isEqual.set(false);
                    return continueStatement;
                }
                J.Continue compareTo = (J.Continue)j;
                if (this.nullMissMatch(continueStatement.getLabel(), compareTo.getLabel())) {
                    this.isEqual.set(false);
                    return continueStatement;
                }
                if (continueStatement.getLabel() != null && compareTo.getLabel() != null) {
                    this.visit((Tree)continueStatement.getLabel(), compareTo.getLabel());
                }
            }
            return continueStatement;
        }

        @Override
        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.DoWhileLoop)) {
                    this.isEqual.set(false);
                    return doWhileLoop;
                }
                J.DoWhileLoop compareTo = (J.DoWhileLoop)j;
                this.visit(doWhileLoop.getWhileCondition(), compareTo.getWhileCondition());
                this.visit((Tree)doWhileLoop.getBody(), compareTo.getBody());
            }
            return doWhileLoop;
        }

        @Override
        public J.If.Else visitElse(J.If.Else else_, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.If.Else)) {
                    this.isEqual.set(false);
                    return else_;
                }
                J.If.Else compareTo = (J.If.Else)j;
                this.visit((Tree)else_.getBody(), compareTo.getBody());
            }
            return else_;
        }

        @Override
        public J.Empty visitEmpty(J.Empty empty, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Empty)) {
                    this.isEqual.set(false);
                    return empty;
                }
                J.Empty compareTo = (J.Empty)j;
                if (this.nullMissMatch(empty.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return empty;
                }
            }
            return empty;
        }

        @Override
        public J.EnumValue visitEnumValue(J.EnumValue _enum, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.EnumValue)) {
                    this.isEqual.set(false);
                    return _enum;
                }
                J.EnumValue compareTo = (J.EnumValue)j;
                if (!_enum.getName().getSimpleName().equals(compareTo.getName().getSimpleName()) || !TypeUtils.isOfType(_enum.getName().getType(), compareTo.getName().getType()) || this.nullListSizeMissMatch(_enum.getAnnotations(), compareTo.getAnnotations()) || this.nullMissMatch(_enum.getInitializer(), compareTo.getInitializer())) {
                    this.isEqual.set(false);
                    return _enum;
                }
                this.visitList(_enum.getAnnotations(), compareTo.getAnnotations());
                if (_enum.getInitializer() != null && compareTo.getInitializer() != null) {
                    this.visit((Tree)_enum.getInitializer(), compareTo.getInitializer());
                }
            }
            return _enum;
        }

        @Override
        public J.EnumValueSet visitEnumValueSet(J.EnumValueSet enums, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.EnumValueSet)) {
                    this.isEqual.set(false);
                    return enums;
                }
                J.EnumValueSet compareTo = (J.EnumValueSet)j;
                this.visitList(enums.getEnums(), compareTo.getEnums());
            }
            return enums;
        }

        @Override
        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, J j) {
            if (this.isEqual.get()) {
                JavaType.Variable fieldType = fieldAccess.getName().getFieldType();
                if (!(j instanceof J.FieldAccess)) {
                    if (!(j instanceof J.Identifier && TypeUtils.isOfType(fieldType, ((J.Identifier)j).getFieldType()) && fieldAccess.getSimpleName().equals(((J.Identifier)j).getSimpleName()))) {
                        this.isEqual.set(false);
                    } else if (fieldType != null && !fieldType.hasFlags(Flag.Static)) {
                        this.isEqual.set(false);
                    }
                    return fieldAccess;
                }
                J.FieldAccess compareTo = (J.FieldAccess)j;
                if (fieldAccess.getType() instanceof JavaType.Unknown && compareTo.getType() instanceof JavaType.Unknown) {
                    if (!fieldAccess.getSimpleName().equals(compareTo.getSimpleName())) {
                        this.isEqual.set(false);
                        return fieldAccess;
                    }
                } else if (!TypeUtils.isOfType(fieldAccess.getType(), compareTo.getType()) || !TypeUtils.isOfType(fieldType, compareTo.getName().getFieldType())) {
                    this.isEqual.set(false);
                    return fieldAccess;
                }
                this.visit((Tree)fieldAccess.getTarget(), compareTo.getTarget());
            }
            return fieldAccess;
        }

        @Override
        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.ForEachLoop)) {
                    this.isEqual.set(false);
                    return forLoop;
                }
                J.ForEachLoop compareTo = (J.ForEachLoop)j;
                this.visit((Tree)forLoop.getControl(), compareTo.getControl());
                this.visit((Tree)forLoop.getBody(), compareTo.getBody());
            }
            return forLoop;
        }

        @Override
        public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.ForEachLoop.Control)) {
                    this.isEqual.set(false);
                    return control;
                }
                J.ForEachLoop.Control compareTo = (J.ForEachLoop.Control)j;
                this.visit((Tree)control.getVariable(), compareTo.getVariable());
                this.visit((Tree)control.getIterable(), compareTo.getIterable());
            }
            return control;
        }

        @Override
        public J.ForLoop visitForLoop(J.ForLoop forLoop, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.ForLoop)) {
                    this.isEqual.set(false);
                    return forLoop;
                }
                J.ForLoop compareTo = (J.ForLoop)j;
                this.visit((Tree)forLoop.getControl(), compareTo.getControl());
                this.visit((Tree)forLoop.getBody(), compareTo.getBody());
            }
            return forLoop;
        }

        @Override
        public J.ForLoop.Control visitForControl(J.ForLoop.Control control, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.ForLoop.Control)) {
                    this.isEqual.set(false);
                    return control;
                }
                J.ForLoop.Control compareTo = (J.ForLoop.Control)j;
                if (control.getInit().size() != compareTo.getInit().size() || control.getUpdate().size() != compareTo.getUpdate().size()) {
                    this.isEqual.set(false);
                    return control;
                }
                this.visit((Tree)control.getCondition(), compareTo.getCondition());
                this.visitList(control.getInit(), compareTo.getInit());
                this.visitList(control.getUpdate(), compareTo.getUpdate());
            }
            return control;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, J j) {
            if (this.isEqual.get()) {
                Map<String, String> scope;
                if (!(j instanceof J.Identifier)) {
                    if (!(j instanceof J.FieldAccess) || !TypeUtils.isOfType(identifier.getFieldType(), ((J.FieldAccess)j).getName().getFieldType())) {
                        this.isEqual.set(false);
                    } else if (identifier.getFieldType() != null && !identifier.getFieldType().hasFlags(Flag.Static)) {
                        this.isEqual.set(false);
                    }
                    return identifier;
                }
                J.Identifier compareTo = (J.Identifier)j;
                if (identifier.getFieldType() != null && (scope = this.variableScope.peek()) != null && scope.containsKey(identifier.getSimpleName()) && scope.get(identifier.getSimpleName()).equals(compareTo.getSimpleName())) {
                    return identifier;
                }
                if (!identifier.getSimpleName().equals(compareTo.getSimpleName())) {
                    this.isEqual.set(false);
                    return identifier;
                }
            }
            return identifier;
        }

        @Override
        public J.If visitIf(J.If iff, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.If)) {
                    this.isEqual.set(false);
                    return iff;
                }
                J.If compareTo = (J.If)j;
                if (this.nullMissMatch(iff.getElsePart(), compareTo.getElsePart())) {
                    this.isEqual.set(false);
                    return iff;
                }
                this.visit(iff.getIfCondition(), compareTo.getIfCondition());
                this.visit((Tree)iff.getThenPart(), compareTo.getThenPart());
                if (iff.getElsePart() != null && compareTo.getElsePart() != null) {
                    this.visit((Tree)iff.getElsePart(), compareTo.getElsePart());
                }
            }
            return iff;
        }

        @Override
        public J.Import visitImport(J.Import _import, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Import)) {
                    this.isEqual.set(false);
                    return _import;
                }
                J.Import compareTo = (J.Import)j;
                if (!(_import.isStatic() == compareTo.isStatic() && _import.getPackageName().equals(compareTo.getPackageName()) && _import.getClassName().equals(compareTo.getClassName()) && TypeUtils.isOfType(_import.getQualid().getType(), compareTo.getQualid().getType()))) {
                    this.isEqual.set(false);
                    return _import;
                }
            }
            return _import;
        }

        @Override
        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.InstanceOf)) {
                    this.isEqual.set(false);
                    return instanceOf;
                }
                J.InstanceOf compareTo = (J.InstanceOf)j;
                if (!TypeUtils.isOfType(instanceOf.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return instanceOf;
                }
                this.visit((Tree)instanceOf.getClazz(), compareTo.getClazz());
                this.visit((Tree)instanceOf.getExpression(), compareTo.getExpression());
            }
            return instanceOf;
        }

        @Override
        public J.Label visitLabel(J.Label label, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Label)) {
                    this.isEqual.set(false);
                    return label;
                }
                J.Label compareTo = (J.Label)j;
                if (!label.getLabel().getSimpleName().equals(compareTo.getLabel().getSimpleName()) || !TypeUtils.isOfType(label.getLabel().getType(), compareTo.getLabel().getType())) {
                    this.isEqual.set(false);
                    return label;
                }
                this.visit((Tree)label.getStatement(), compareTo.getStatement());
            }
            return label;
        }

        @Override
        public J.Lambda visitLambda(J.Lambda lambda, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Lambda)) {
                    this.isEqual.set(false);
                    return lambda;
                }
                J.Lambda compareTo = (J.Lambda)j;
                if (lambda.getParameters().getParameters().size() != compareTo.getParameters().getParameters().size()) {
                    this.isEqual.set(false);
                    return lambda;
                }
                this.visitList(lambda.getParameters().getParameters(), compareTo.getParameters().getParameters());
                this.visit((Tree)lambda.getBody(), compareTo.getBody());
            }
            return lambda;
        }

        @Override
        public J.Literal visitLiteral(J.Literal literal, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Literal)) {
                    this.isEqual.set(false);
                    return literal;
                }
                J.Literal compareTo = (J.Literal)j;
                if (!TypeUtils.isOfType(literal.getType(), compareTo.getType()) || !Objects.equals(literal.getValue(), compareTo.getValue())) {
                    this.isEqual.set(false);
                    return literal;
                }
            }
            return literal;
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.MemberReference)) {
                    this.isEqual.set(false);
                    return memberRef;
                }
                J.MemberReference compareTo = (J.MemberReference)j;
                if (!(memberRef.getReference().getSimpleName().equals(compareTo.getReference().getSimpleName()) && TypeUtils.isOfType(memberRef.getReference().getType(), compareTo.getReference().getType()) && TypeUtils.isOfType(memberRef.getType(), compareTo.getType()) && TypeUtils.isOfType(memberRef.getVariableType(), compareTo.getVariableType()) && TypeUtils.isOfType(memberRef.getMethodType(), compareTo.getMethodType()) && !this.nullListSizeMissMatch(memberRef.getTypeParameters(), compareTo.getTypeParameters()))) {
                    this.isEqual.set(false);
                    return memberRef;
                }
                this.visit((Tree)memberRef.getContaining(), compareTo.getContaining());
                this.visitList(memberRef.getTypeParameters(), compareTo.getTypeParameters());
            }
            return memberRef;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.MethodDeclaration)) {
                    this.isEqual.set(false);
                    return method;
                }
                J.MethodDeclaration compareTo = (J.MethodDeclaration)j;
                if (!method.getSimpleName().equals(compareTo.getSimpleName()) || !TypeUtils.isOfType(method.getMethodType(), compareTo.getMethodType()) || this.modifierListMissMatch(method.getModifiers(), compareTo.getModifiers()) || method.getLeadingAnnotations().size() != compareTo.getLeadingAnnotations().size() || method.getParameters().size() != compareTo.getParameters().size() || this.nullMissMatch(method.getReturnTypeExpression(), compareTo.getReturnTypeExpression()) || this.nullListSizeMissMatch(method.getTypeParameters(), compareTo.getTypeParameters()) || this.nullListSizeMissMatch(method.getThrows(), compareTo.getThrows()) || this.nullMissMatch(method.getBody(), compareTo.getBody()) || method.getBody() != null && compareTo.getBody() != null && this.nullListSizeMissMatch(method.getBody().getStatements(), compareTo.getBody().getStatements())) {
                    this.isEqual.set(false);
                    return method;
                }
                this.visitList(method.getLeadingAnnotations(), compareTo.getLeadingAnnotations());
                this.visitList(method.getParameters(), compareTo.getParameters());
                if (method.getReturnTypeExpression() != null && compareTo.getReturnTypeExpression() != null) {
                    this.visitTypeName((N)method.getReturnTypeExpression(), compareTo.getReturnTypeExpression());
                }
                this.visitList(method.getTypeParameters(), compareTo.getTypeParameters());
                this.visitList(method.getThrows(), compareTo.getThrows());
                if (method.getBody() != null && compareTo.getBody() != null) {
                    this.visit((Tree)method.getBody(), compareTo.getBody());
                }
            }
            return method;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.MethodInvocation)) {
                    this.isEqual.set(false);
                    return method;
                }
                boolean static_ = method.getMethodType() != null && method.getMethodType().hasFlags(Flag.Static);
                J.MethodInvocation compareTo = (J.MethodInvocation)j;
                if (!method.getSimpleName().equals(compareTo.getSimpleName()) || method.getArguments().size() != compareTo.getArguments().size() || static_ != (compareTo.getMethodType() != null && compareTo.getMethodType().hasFlags(Flag.Static)) && this.nullMissMatch(method.getSelect(), compareTo.getSelect()) || method.getMethodType() == null || compareTo.getMethodType() == null || !TypeUtils.isAssignableTo(method.getMethodType().getReturnType(), compareTo.getMethodType().getReturnType()) || this.nullListSizeMissMatch(method.getTypeParameters(), compareTo.getTypeParameters())) {
                    this.isEqual.set(false);
                    return method;
                }
                if (!static_) {
                    if (this.nullMissMatch(method.getSelect(), compareTo.getSelect())) {
                        this.isEqual.set(false);
                        return method;
                    }
                    this.visit((Tree)method.getSelect(), compareTo.getSelect());
                } else {
                    JavaType.FullyQualified compareToDeclaringType;
                    JavaType.FullyQualified methodDeclaringType = method.getMethodType().getDeclaringType();
                    if (!TypeUtils.isAssignableTo(methodDeclaringType instanceof JavaType.Parameterized ? ((JavaType.Parameterized)methodDeclaringType).getType() : methodDeclaringType, (JavaType)((compareToDeclaringType = compareTo.getMethodType().getDeclaringType()) instanceof JavaType.Parameterized ? ((JavaType.Parameterized)compareToDeclaringType).getType() : compareToDeclaringType))) {
                        this.isEqual.set(false);
                        return method;
                    }
                }
                boolean containsLiteral = false;
                if (!this.compareMethodArguments) {
                    for (int i = 0; i < method.getArguments().size(); ++i) {
                        if (!(method.getArguments().get(i) instanceof J.Literal) && !(compareTo.getArguments().get(i) instanceof J.Literal)) continue;
                        containsLiteral = true;
                        break;
                    }
                    if (!(containsLiteral || !this.nullMissMatch(method.getMethodType(), compareTo.getMethodType()) && TypeUtils.isOfType(method.getMethodType(), compareTo.getMethodType()))) {
                        this.isEqual.set(false);
                        return method;
                    }
                }
                if (this.compareMethodArguments || containsLiteral) {
                    this.visitList(method.getArguments(), compareTo.getArguments());
                }
                this.visitList(method.getTypeParameters(), compareTo.getTypeParameters());
            }
            return method;
        }

        @Override
        public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.MultiCatch)) {
                    this.isEqual.set(false);
                    return multiCatch;
                }
                J.MultiCatch compareTo = (J.MultiCatch)j;
                if (!(multiCatch.getType() instanceof JavaType.MultiCatch) || !(compareTo.getType() instanceof JavaType.MultiCatch) || ((JavaType.MultiCatch)multiCatch.getType()).getThrowableTypes().size() != ((JavaType.MultiCatch)compareTo.getType()).getThrowableTypes().size() || multiCatch.getAlternatives().size() != compareTo.getAlternatives().size()) {
                    this.isEqual.set(false);
                    return multiCatch;
                }
                for (int i = 0; i < ((JavaType.MultiCatch)multiCatch.getType()).getThrowableTypes().size(); ++i) {
                    JavaType second;
                    JavaType first = ((JavaType.MultiCatch)multiCatch.getType()).getThrowableTypes().get(i);
                    if (TypeUtils.isOfType(first, second = ((JavaType.MultiCatch)compareTo.getType()).getThrowableTypes().get(i))) continue;
                    this.isEqual.set(false);
                    return multiCatch;
                }
                this.visitList(multiCatch.getAlternatives(), compareTo.getAlternatives());
            }
            return multiCatch;
        }

        @Override
        public J.NewArray visitNewArray(J.NewArray newArray, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.NewArray)) {
                    this.isEqual.set(false);
                    return newArray;
                }
                J.NewArray compareTo = (J.NewArray)j;
                if (!TypeUtils.isOfType(newArray.getType(), compareTo.getType()) || newArray.getDimensions().size() != compareTo.getDimensions().size() || this.nullMissMatch(newArray.getTypeExpression(), compareTo.getTypeExpression()) || this.nullListSizeMissMatch(newArray.getInitializer(), compareTo.getInitializer())) {
                    this.isEqual.set(false);
                    return newArray;
                }
                this.visitList(newArray.getDimensions(), compareTo.getDimensions());
                if (newArray.getTypeExpression() != null && compareTo.getTypeExpression() != null) {
                    this.visit((Tree)newArray.getTypeExpression(), compareTo.getTypeExpression());
                }
                this.visitList(newArray.getInitializer(), compareTo.getInitializer());
            }
            return newArray;
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.NewClass)) {
                    this.isEqual.set(false);
                    return newClass;
                }
                J.NewClass compareTo = (J.NewClass)j;
                if (!TypeUtils.isOfType(newClass.getType(), compareTo.getType()) || !TypeUtils.isOfType(newClass.getConstructorType(), compareTo.getConstructorType()) || this.nullMissMatch(newClass.getEnclosing(), compareTo.getEnclosing()) || this.nullMissMatch(newClass.getClazz(), compareTo.getClazz()) || this.nullMissMatch(newClass.getConstructorType(), compareTo.getConstructorType()) || this.nullMissMatch(newClass.getBody(), compareTo.getBody()) || this.nullListSizeMissMatch(newClass.getArguments(), compareTo.getArguments())) {
                    this.isEqual.set(false);
                    return newClass;
                }
                if (newClass.getEnclosing() != null && compareTo.getEnclosing() != null) {
                    this.visit((Tree)newClass.getEnclosing(), compareTo.getEnclosing());
                }
                if (newClass.getClazz() != null && compareTo.getClazz() != null) {
                    this.visit((Tree)newClass.getClazz(), compareTo.getClazz());
                }
                if (newClass.getBody() != null && compareTo.getBody() != null) {
                    this.visit((Tree)newClass.getBody(), compareTo.getBody());
                }
                if (newClass.getArguments() != null && compareTo.getArguments() != null) {
                    boolean containsLiteral = false;
                    if (!this.compareMethodArguments) {
                        for (int i = 0; i < newClass.getArguments().size(); ++i) {
                            if (!(newClass.getArguments().get(i) instanceof J.Literal) && !(compareTo.getArguments().get(i) instanceof J.Literal)) continue;
                            containsLiteral = true;
                            break;
                        }
                        if (!containsLiteral && (this.nullMissMatch(newClass.getConstructorType(), compareTo.getConstructorType()) || newClass.getConstructorType() != null && compareTo.getConstructorType() != null && !TypeUtils.isOfType(newClass.getConstructorType(), compareTo.getConstructorType()))) {
                            this.isEqual.set(false);
                            return newClass;
                        }
                    }
                    if (this.compareMethodArguments || containsLiteral) {
                        this.visitList(newClass.getArguments(), compareTo.getArguments());
                    }
                }
            }
            return newClass;
        }

        @Override
        public J.Package visitPackage(J.Package pkg, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Package)) {
                    this.isEqual.set(false);
                    return pkg;
                }
                J.Package compareTo = (J.Package)j;
                if (pkg.getAnnotations().size() != compareTo.getAnnotations().size() || !pkg.getExpression().toString().equals(compareTo.getExpression().toString())) {
                    this.isEqual.set(false);
                    return pkg;
                }
                this.visitList(pkg.getAnnotations(), compareTo.getAnnotations());
            }
            return pkg;
        }

        @Override
        public J.ParameterizedType visitParameterizedType(J.ParameterizedType type, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.ParameterizedType)) {
                    this.isEqual.set(false);
                    return type;
                }
                J.ParameterizedType compareTo = (J.ParameterizedType)j;
                if (!TypeUtils.isOfType(type.getType(), compareTo.getType()) || this.nullListSizeMissMatch(type.getTypeParameters(), compareTo.getTypeParameters())) {
                    this.isEqual.set(false);
                    return type;
                }
                if (!(type.getTypeParameters().get(0) instanceof J.Empty) && !(compareTo.getTypeParameters().get(0) instanceof J.Empty)) {
                    this.visitList(type.getTypeParameters(), compareTo.getTypeParameters());
                }
            }
            return type;
        }

        @Override
        public <T extends J> J.Parentheses<T> visitParentheses(J.Parentheses<T> parens, J j) {
            if (this.isEqual.get()) {
                if (j instanceof Expression) {
                    this.visit((Tree)parens.getTree(), ((Expression)j).unwrap());
                } else {
                    this.isEqual.set(false);
                    return parens;
                }
            }
            return parens;
        }

        @Override
        public J.Primitive visitPrimitive(J.Primitive primitive, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Primitive)) {
                    this.isEqual.set(false);
                    return primitive;
                }
                J.Primitive compareTo = (J.Primitive)j;
                if (!TypeUtils.isOfType(primitive.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return primitive;
                }
            }
            return primitive;
        }

        @Override
        public J.Return visitReturn(J.Return _return, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Return)) {
                    this.isEqual.set(false);
                    return _return;
                }
                J.Return compareTo = (J.Return)j;
                if (this.nullMissMatch(_return.getExpression(), compareTo.getExpression())) {
                    this.isEqual.set(false);
                    return _return;
                }
                if (_return.getExpression() != null && compareTo.getExpression() != null) {
                    this.visit((Tree)_return.getExpression(), compareTo.getExpression());
                }
            }
            return _return;
        }

        @Override
        public J.Switch visitSwitch(J.Switch _switch, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Switch)) {
                    this.isEqual.set(false);
                    return _switch;
                }
                J.Switch compareTo = (J.Switch)j;
                this.visit((Tree)_switch.getCases(), compareTo.getCases());
            }
            return _switch;
        }

        @Override
        public J.SwitchExpression visitSwitchExpression(J.SwitchExpression _switch, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.SwitchExpression)) {
                    this.isEqual.set(false);
                    return _switch;
                }
                J.SwitchExpression compareTo = (J.SwitchExpression)j;
                this.visit(_switch.getSelector(), compareTo.getSelector());
                this.visit((Tree)_switch.getCases(), compareTo.getCases());
            }
            return _switch;
        }

        @Override
        public J.Synchronized visitSynchronized(J.Synchronized _sync, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Synchronized)) {
                    this.isEqual.set(false);
                    return _sync;
                }
                J.Synchronized compareTo = (J.Synchronized)j;
                this.visit(_sync.getLock(), compareTo.getLock());
                this.visit((Tree)_sync.getBody(), compareTo.getBody());
            }
            return _sync;
        }

        @Override
        public J.Ternary visitTernary(J.Ternary ternary, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Ternary)) {
                    this.isEqual.set(false);
                    return ternary;
                }
                J.Ternary compareTo = (J.Ternary)j;
                if (!TypeUtils.isOfType(ternary.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return ternary;
                }
                this.visit((Tree)ternary.getCondition(), compareTo.getCondition());
                this.visit((Tree)ternary.getTruePart(), compareTo.getTruePart());
                this.visit((Tree)ternary.getFalsePart(), compareTo.getFalsePart());
            }
            return ternary;
        }

        @Override
        public J.Throw visitThrow(J.Throw thrown, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Throw)) {
                    this.isEqual.set(false);
                    return thrown;
                }
                J.Throw compareTo = (J.Throw)j;
                this.visit((Tree)thrown.getException(), compareTo.getException());
            }
            return thrown;
        }

        @Override
        public J.Try visitTry(J.Try _try, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Try)) {
                    this.isEqual.set(false);
                    return _try;
                }
                J.Try compareTo = (J.Try)j;
                if (_try.getCatches().size() != compareTo.getCatches().size() || this.nullMissMatch(_try.getFinally(), compareTo.getFinally()) || this.nullListSizeMissMatch(_try.getResources(), compareTo.getResources())) {
                    this.isEqual.set(false);
                    return _try;
                }
                this.visit((Tree)_try.getBody(), compareTo.getBody());
                this.visitList(_try.getCatches(), compareTo.getCatches());
                this.visitList(_try.getResources(), compareTo.getResources());
                if (_try.getFinally() != null && compareTo.getFinally() != null) {
                    this.visit((Tree)_try.getFinally(), compareTo.getFinally());
                }
            }
            return _try;
        }

        @Override
        public J.Try.Resource visitTryResource(J.Try.Resource tryResource, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Try.Resource)) {
                    this.isEqual.set(false);
                    return tryResource;
                }
                J.Try.Resource compareTo = (J.Try.Resource)j;
                this.visit((Tree)tryResource.getVariableDeclarations(), compareTo.getVariableDeclarations());
            }
            return tryResource;
        }

        @Override
        public J.TypeCast visitTypeCast(J.TypeCast typeCast, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof Expression)) {
                    this.isEqual.set(false);
                    return typeCast;
                }
                Expression compareTo = (Expression)j;
                if (!TypeUtils.isOfType(typeCast.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                } else if (compareTo instanceof J.TypeCast) {
                    this.visit((Tree)typeCast.getExpression(), ((J.TypeCast)compareTo).getExpression());
                } else {
                    this.visit((Tree)typeCast.getExpression(), compareTo);
                }
            }
            return typeCast;
        }

        @Override
        public J.TypeParameter visitTypeParameter(J.TypeParameter typeParam, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.TypeParameter)) {
                    this.isEqual.set(false);
                    return typeParam;
                }
                J.TypeParameter compareTo = (J.TypeParameter)j;
                if (typeParam.getAnnotations().size() != compareTo.getAnnotations().size() || this.nullListSizeMissMatch(typeParam.getBounds(), compareTo.getBounds())) {
                    this.isEqual.set(false);
                    return typeParam;
                }
                this.visit((Tree)typeParam.getName(), compareTo.getName());
                this.visitList(typeParam.getAnnotations(), compareTo.getAnnotations());
                this.visitList(typeParam.getBounds(), compareTo.getBounds());
            }
            return typeParam;
        }

        @Override
        public J.Unary visitUnary(J.Unary unary, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Unary)) {
                    this.isEqual.set(false);
                    return unary;
                }
                J.Unary compareTo = (J.Unary)j;
                if (unary.getOperator() != compareTo.getOperator() || !TypeUtils.isOfType(unary.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return unary;
                }
                this.visit((Tree)unary.getExpression(), compareTo.getExpression());
            }
            return unary;
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.VariableDeclarations)) {
                    this.isEqual.set(false);
                    return multiVariable;
                }
                J.VariableDeclarations compareTo = (J.VariableDeclarations)j;
                if (!TypeUtils.isOfType(multiVariable.getType(), compareTo.getType()) || this.nullMissMatch(multiVariable.getTypeExpression(), compareTo.getTypeExpression()) || multiVariable.getVariables().size() != compareTo.getVariables().size() || multiVariable.getLeadingAnnotations().size() != compareTo.getLeadingAnnotations().size()) {
                    this.isEqual.set(false);
                    return multiVariable;
                }
                if (multiVariable.getTypeExpression() != null && compareTo.getTypeExpression() != null) {
                    this.visitTypeName((N)multiVariable.getTypeExpression(), compareTo.getTypeExpression());
                }
                this.visitList(multiVariable.getLeadingAnnotations(), compareTo.getLeadingAnnotations());
                this.visitList(multiVariable.getVariables(), compareTo.getVariables());
            }
            return multiVariable;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.VariableDeclarations.NamedVariable)) {
                    this.isEqual.set(false);
                    return variable;
                }
                J.VariableDeclarations.NamedVariable compareTo = (J.VariableDeclarations.NamedVariable)j;
                Map<String, String> scope = this.variableScope.peek();
                if (scope != null) {
                    scope.put(variable.getSimpleName(), compareTo.getSimpleName());
                } else if (!variable.getSimpleName().equals(compareTo.getSimpleName())) {
                    this.isEqual.set(false);
                    return variable;
                }
                if (!TypeUtils.isOfType(variable.getType(), compareTo.getType()) || this.nullMissMatch(variable.getInitializer(), compareTo.getInitializer())) {
                    this.isEqual.set(false);
                    return variable;
                }
                if (variable.getInitializer() != null && compareTo.getInitializer() != null) {
                    this.visit((Tree)variable.getInitializer(), compareTo.getInitializer());
                }
            }
            return variable;
        }

        @Override
        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.WhileLoop)) {
                    this.isEqual.set(false);
                    return whileLoop;
                }
                J.WhileLoop compareTo = (J.WhileLoop)j;
                this.visit((Tree)whileLoop.getBody(), compareTo.getBody());
                this.visit(whileLoop.getCondition(), compareTo.getCondition());
            }
            return whileLoop;
        }

        @Override
        public J.Wildcard visitWildcard(J.Wildcard wildcard, J j) {
            if (this.isEqual.get()) {
                if (!(j instanceof J.Wildcard)) {
                    this.isEqual.set(false);
                    return wildcard;
                }
                J.Wildcard compareTo = (J.Wildcard)j;
                if (wildcard.getBound() != compareTo.getBound() || this.nullMissMatch(wildcard.getBoundedType(), compareTo.getBoundedType())) {
                    this.isEqual.set(false);
                    return wildcard;
                }
                if (wildcard.getBoundedType() != null && compareTo.getBoundedType() != null) {
                    this.visitTypeName((N)wildcard.getBoundedType(), compareTo.getBoundedType());
                }
            }
            return wildcard;
        }

        @Override
        public <N extends NameTree> N visitTypeName(N firstTypeName, J j) {
            if (this.isEqual.get() && !(j instanceof NameTree) && !TypeUtils.isOfType(firstTypeName.getType(), ((NameTree)j).getType())) {
                this.isEqual.set(false);
                return firstTypeName;
            }
            return firstTypeName;
        }
    }
}

