/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;

public class TabsAndIndentsVisitor<P>
extends JavaIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final TabsAndIndentsStyle style;

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style) {
        this(style, null);
    }

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    public @Nullable J visit(@Nullable Tree tree, P p, Cursor parent) {
        J next;
        this.setCursor(parent);
        for (Cursor c = parent; c != null; c = c.getParent()) {
            int indent;
            Object v = c.getValue();
            Space space = null;
            if (v instanceof J) {
                space = ((J)v).getPrefix();
            } else if (v instanceof JRightPadded) {
                space = ((JRightPadded)v).getAfter();
            } else if (v instanceof JLeftPadded) {
                space = ((JLeftPadded)v).getBefore();
            } else if (v instanceof JContainer) {
                space = ((JContainer)v).getBefore();
            }
            if (space == null || !space.getLastWhitespace().contains("\n") || (indent = this.findIndent(space)) == 0) continue;
            c.putMessage("lastIndent", (Object)indent);
        }
        Iterator itr = parent.getPath(J.class::isInstance);
        J j = next = itr.hasNext() ? (J)itr.next() : null;
        if (next != null) {
            this.preVisit(next, p);
        }
        return this.visit(tree, (Object)p);
    }

    public @Nullable J preVisit(@Nullable J tree, P p) {
        if (tree instanceof JavaSourceFile || tree instanceof J.Package || tree instanceof J.Import || tree instanceof J.Label || tree instanceof J.DoWhileLoop || tree instanceof J.ArrayDimension || tree instanceof J.ClassDeclaration) {
            this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
        } else if (tree instanceof J.Block || tree instanceof J.If || tree instanceof J.If.Else || tree instanceof J.ForLoop || tree instanceof J.ForEachLoop || tree instanceof J.WhileLoop || tree instanceof J.Case || tree instanceof J.EnumValueSet) {
            this.getCursor().putMessage("indentType", (Object)IndentType.INDENT);
        } else {
            this.getCursor().putMessage("indentType", (Object)IndentType.CONTINUATION_INDENT);
        }
        return tree;
    }

    @Override
    public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
        return control;
    }

    @Override
    public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, P p) {
        return control;
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        boolean alignBlockToParent;
        Integer chainedIndent;
        this.getCursor().putMessage("lastLocation", (Object)loc);
        boolean alignToAnnotation = false;
        Cursor parent = this.getCursor().getParent();
        if (parent != null && parent.getValue() instanceof J.Annotation) {
            parent.getParentOrThrow().putMessage("afterAnnotation", (Object)true);
        } else if (parent != null) {
            if (!this.getCursor().getParentOrThrow().getPath(J.Annotation.class::isInstance).hasNext()) {
                boolean bl = alignToAnnotation = this.getCursor().pollNearestMessage("afterAnnotation") != null && !(this.getCursor().getParentOrThrow().getValue() instanceof J.Annotation);
            }
        }
        if (space.getComments().isEmpty() && !space.getLastWhitespace().contains("\n") || parent == null) {
            return space;
        }
        if (loc == Space.Location.METHOD_SELECT_SUFFIX && (chainedIndent = (Integer)this.getCursor().getParentTreeCursor().getMessage("chainedIndent")) != null) {
            this.getCursor().getParentTreeCursor().putMessage("lastIndent", (Object)chainedIndent);
            return this.indentTo(space, chainedIndent, loc);
        }
        int indent = (Integer)this.getCursor().getNearestMessage("lastIndent", (Object)0);
        IndentType indentType = (IndentType)((Object)this.getCursor().getParentOrThrow().getNearestMessage("indentType", (Object)IndentType.ALIGN));
        Object value = this.getCursor().getValue();
        boolean alignBlockPrefixToParent = loc == Space.Location.BLOCK_PREFIX && space.getWhitespace().contains("\n") && value instanceof J.Block && !(this.getCursor().getParentTreeCursor().getValue() instanceof J.Block);
        boolean bl = alignBlockToParent = loc == Space.Location.BLOCK_END || loc == Space.Location.NEW_ARRAY_INITIALIZER_SUFFIX || loc == Space.Location.CATCH_PREFIX || loc == Space.Location.TRY_FINALLY || loc == Space.Location.ELSE_PREFIX;
        if (loc == Space.Location.EXTENDS && space.getWhitespace().contains("\n") || Space.Location.EXTENDS == this.getCursor().getParent().getMessage("lastLocation")) {
            indentType = IndentType.CONTINUATION_INDENT;
        }
        if (alignBlockPrefixToParent || alignBlockToParent || alignToAnnotation) {
            indentType = IndentType.ALIGN;
        }
        switch (indentType) {
            case ALIGN: {
                break;
            }
            case INDENT: {
                indent += this.style.getIndentSize().intValue();
                break;
            }
            case CONTINUATION_INDENT: {
                indent += this.style.getContinuationIndent().intValue();
            }
        }
        Space s = this.indentTo(space, indent, loc);
        if (value instanceof J && !(value instanceof J.EnumValueSet)) {
            this.getCursor().putMessage("lastIndent", (Object)indent);
        } else if (loc == Space.Location.METHOD_SELECT_SUFFIX) {
            this.getCursor().getParentTreeCursor().putMessage("lastIndent", (Object)indent);
        }
        return s;
    }

    @Override
    public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, P p) {
        Space after;
        Object t;
        block30: {
            block27: {
                J elem;
                block29: {
                    int indent;
                    block28: {
                        if (right == null) {
                            return null;
                        }
                        this.setCursor(new Cursor(this.getCursor(), right));
                        t = right.getElement();
                        indent = (Integer)this.getCursor().getNearestMessage("lastIndent", (Object)0);
                        if (!(right.getElement() instanceof J)) break block27;
                        elem = (J)right.getElement();
                        if (!right.getAfter().getLastWhitespace().contains("\n") && !elem.getPrefix().getLastWhitespace().contains("\n")) break block28;
                        switch (loc) {
                            case FOR_CONDITION: 
                            case FOR_UPDATE: {
                                J.ForLoop.Control control = (J.ForLoop.Control)this.getCursor().getParentOrThrow().getValue();
                                Space initPrefix = Space.firstPrefix(control.getInit());
                                if (!initPrefix.getLastWhitespace().contains("\n")) {
                                    int initIndent = this.forInitColumn();
                                    this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(initIndent - this.style.getContinuationIndent()));
                                    elem = (J)this.visitAndCast(elem, p);
                                    this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                                    after = this.indentTo(right.getAfter(), initIndent, loc.getAfterLocation());
                                    break;
                                }
                                elem = (J)this.visitAndCast(elem, p);
                                after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                                break;
                            }
                            case METHOD_DECLARATION_PARAMETER: 
                            case RECORD_STATE_VECTOR: {
                                if (elem instanceof J.Empty) {
                                    elem = elem.withPrefix(this.indentTo(elem.getPrefix(), indent, loc.getAfterLocation()));
                                    after = right.getAfter();
                                    break;
                                }
                                JContainer container = (JContainer)this.getCursor().getParentOrThrow().getValue();
                                List elements = container.getElements();
                                J firstArg = (J)elements.iterator().next();
                                J lastArg = (J)elements.get(elements.size() - 1);
                                if (this.style.getMethodDeclarationParameters().getAlignWhenMultiple().booleanValue()) {
                                    J.MethodDeclaration method = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                                    if (method != null) {
                                        String source;
                                        int lineBreakIndex;
                                        int firstArgIndex;
                                        int alignTo = firstArg.getPrefix().getLastWhitespace().contains("\n") ? this.getLengthOfWhitespace(firstArg.getPrefix().getLastWhitespace()) : firstArgIndex - ((lineBreakIndex = (source = method.print(this.getCursor())).lastIndexOf(10, firstArgIndex = source.indexOf(firstArg.print(this.getCursor())))) == -1 ? 0 : lineBreakIndex) - 1;
                                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(alignTo - this.style.getContinuationIndent()));
                                        elem = (J)this.visitAndCast(elem, p);
                                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                                        after = this.indentTo(right.getAfter(), t == lastArg ? indent : alignTo, loc.getAfterLocation());
                                        break;
                                    }
                                    after = right.getAfter();
                                    break;
                                }
                                elem = (J)this.visitAndCast(elem, p);
                                after = this.indentTo(right.getAfter(), t == lastArg ? indent : this.style.getContinuationIndent(), loc.getAfterLocation());
                                break;
                            }
                            case METHOD_INVOCATION_ARGUMENT: {
                                Cursor parent;
                                Cursor grandparent;
                                J body;
                                if (!elem.getPrefix().getLastWhitespace().contains("\n") && elem instanceof J.Lambda && !((body = ((J.Lambda)elem).getBody()) instanceof J.Binary) && !body.getPrefix().getLastWhitespace().contains("\n")) {
                                    this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                                }
                                elem = (J)this.visitAndCast(elem, p);
                                after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                                if ((!after.getComments().isEmpty() || after.getLastWhitespace().contains("\n")) && (grandparent = (parent = this.getCursor().getParentTreeCursor()).getParentTreeCursor()).getValue() instanceof J.MethodInvocation && ((J.MethodInvocation)grandparent.getValue()).getSelect() == parent.getValue()) {
                                    grandparent.putMessage("lastIndent", (Object)indent);
                                    grandparent.putMessage("chainedIndent", (Object)indent);
                                    break;
                                }
                                break block29;
                            }
                            case NEW_CLASS_ARGUMENTS: 
                            case ARRAY_INDEX: 
                            case PARENTHESES: 
                            case TYPE_PARAMETER: {
                                elem = (J)this.visitAndCast(elem, p);
                                after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                                break;
                            }
                            case ANNOTATION_ARGUMENT: {
                                JContainer args = (JContainer)this.getCursor().getParentOrThrow().getValue();
                                elem = (J)this.visitAndCast(elem, p);
                                if (args.getPadding().getElements().get(args.getElements().size() - 1) == right) {
                                    this.getCursor().getParentOrThrow().putMessage("indentType", (Object)IndentType.ALIGN);
                                }
                                after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                                break;
                            }
                            default: {
                                elem = (J)this.visitAndCast(elem, p);
                                after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                                break;
                            }
                        }
                        break block29;
                    }
                    switch (loc) {
                        case METHOD_INVOCATION_ARGUMENT: 
                        case NEW_CLASS_ARGUMENTS: {
                            if (!elem.getPrefix().getLastWhitespace().contains("\n")) {
                                JContainer args = (JContainer)this.getCursor().getParentOrThrow().getValue();
                                boolean anyOtherArgOnOwnLine = false;
                                for (JRightPadded arg : args.getPadding().getElements()) {
                                    if (arg == this.getCursor().getValue() || !((J)arg.getElement()).getPrefix().getLastWhitespace().contains("\n")) continue;
                                    anyOtherArgOnOwnLine = true;
                                    break;
                                }
                                if (!anyOtherArgOnOwnLine) {
                                    elem = (J)this.visitAndCast(elem, p);
                                    after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                                    break;
                                }
                            }
                            if (!(elem instanceof J.Binary)) {
                                if (!(elem instanceof J.MethodInvocation)) {
                                    this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                                } else if (elem.getPrefix().getLastWhitespace().contains("\n")) {
                                    this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                                } else {
                                    J.MethodInvocation methodInvocation = (J.MethodInvocation)elem;
                                    Expression select = methodInvocation.getSelect();
                                    if (select instanceof J.FieldAccess || select instanceof J.Identifier || select instanceof J.MethodInvocation) {
                                        this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                                    }
                                }
                            }
                            elem = (J)this.visitAndCast(elem, p);
                            after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                            break;
                        }
                        default: {
                            elem = (J)this.visitAndCast(elem, p);
                            after = right.getAfter();
                        }
                    }
                }
                t = elem;
                break block30;
            }
            after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        }
        this.setCursor(this.getCursor().getParent());
        return after == right.getAfter() && t == right.getElement() ? right : new JRightPadded<T>(t, after, right.getMarkers());
    }

    @Override
    public <J2 extends J> @Nullable JContainer<J2> visitContainer(@Nullable JContainer<J2> container, JContainer.Location loc, P p) {
        List js;
        Space before;
        if (container == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), container));
        int indent = (Integer)this.getCursor().getNearestMessage("lastIndent", (Object)0);
        if (container.getBefore().getLastWhitespace().contains("\n")) {
            switch (loc) {
                case TYPE_PARAMETERS: 
                case IMPLEMENTS: 
                case THROWS: 
                case NEW_CLASS_ARGUMENTS: {
                    before = this.indentTo(container.getBefore(), indent + this.style.getContinuationIndent(), loc.getBeforeLocation());
                    this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
                    this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
                default: {
                    before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
            }
        } else {
            switch (loc) {
                case TYPE_PARAMETERS: 
                case IMPLEMENTS: 
                case THROWS: 
                case NEW_CLASS_ARGUMENTS: 
                case METHOD_INVOCATION_ARGUMENTS: {
                    this.getCursor().putMessage("indentType", (Object)IndentType.CONTINUATION_INDENT);
                    before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
                default: {
                    before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                }
            }
        }
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build(before, js, container.getMarkers());
    }

    private Space indentTo(Space space, int column, Space.Location spaceLocation) {
        Space s = space;
        String whitespace = s.getWhitespace();
        if (spaceLocation == Space.Location.COMPILATION_UNIT_PREFIX && !StringUtils.isNullOrEmpty((String)whitespace)) {
            s = s.withWhitespace("");
        } else if (s.getComments().isEmpty() && !s.getLastWhitespace().contains("\n")) {
            return s;
        }
        if (s.getComments().isEmpty()) {
            int indent = this.findIndent(s);
            if (indent != column) {
                int shift = column - indent;
                s = s.withWhitespace(this.indent(whitespace, shift));
            }
        } else {
            boolean hasFileLeadingComment = !space.getComments().isEmpty() && (spaceLocation == Space.Location.COMPILATION_UNIT_PREFIX || spaceLocation == Space.Location.CLASS_DECLARATION_PREFIX && space.getComments().get(0).isMultiline());
            int finalColumn = spaceLocation == Space.Location.BLOCK_END ? column + this.style.getIndentSize() : column;
            String lastIndent = space.getWhitespace().substring(space.getWhitespace().lastIndexOf(10) + 1);
            int indent = this.getLengthOfWhitespace(StringUtils.indent((String)lastIndent));
            if (indent != finalColumn) {
                if (hasFileLeadingComment || whitespace.contains("\n") && (s.getComments().isEmpty() || !(s.getComments().get(0) instanceof TextComment) || s.getComments().get(0).isMultiline() || this.getLengthOfWhitespace(s.getWhitespace()) != 0)) {
                    int shift = finalColumn - indent;
                    s = s.withWhitespace(whitespace.substring(0, whitespace.lastIndexOf(10) + 1) + this.indent(lastIndent, shift));
                }
                Space finalSpace = s;
                int lastCommentPos = s.getComments().size() - 1;
                s = s.withComments(ListUtils.map(s.getComments(), (i, c) -> {
                    if (c instanceof TextComment && !c.isMultiline() && i != lastCommentPos && this.getLengthOfWhitespace(c.getSuffix()) == 0) {
                        return c;
                    }
                    String priorSuffix = i == 0 ? space.getWhitespace() : finalSpace.getComments().get(i - 1).getSuffix();
                    int toColumn = spaceLocation == Space.Location.BLOCK_END && i != finalSpace.getComments().size() - 1 ? column + this.style.getIndentSize() : column;
                    Comment c2 = c;
                    if (priorSuffix.contains("\n") || hasFileLeadingComment) {
                        c2 = this.indentComment((Comment)c, priorSuffix, toColumn);
                    }
                    if (c2.getSuffix().contains("\n")) {
                        int suffixIndent = this.getLengthOfWhitespace(c2.getSuffix());
                        int shift = toColumn - suffixIndent;
                        c2 = c2.withSuffix(this.indent(c2.getSuffix(), shift));
                    }
                    return c2;
                }));
            }
        }
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Comment indentComment(Comment comment, String priorSuffix, int column) {
        if (comment instanceof TextComment) {
            TextComment textComment = (TextComment)comment;
            String text = textComment.getText();
            if (!text.contains("\n")) {
                return comment;
            }
            String margin = StringUtils.commonMargin(null, (CharSequence)priorSuffix);
            int indent = this.getLengthOfWhitespace(margin);
            int shift = column - indent;
            if (shift > 0) {
                String newMargin = this.indent(margin, shift);
                if (!textComment.isMultiline()) return comment;
                StringBuilder multiline = new StringBuilder();
                for (int i2 = 0; i2 < text.length(); ++i2) {
                    char c = text.charAt(i2);
                    if (c == '\n') {
                        multiline.append(c).append(newMargin);
                        i2 += margin.length();
                        continue;
                    }
                    multiline.append(c);
                }
                return textComment.withText(multiline.toString());
            }
            if (shift >= 0) return textComment;
            if (!textComment.isMultiline()) return comment;
            StringBuilder multiline = new StringBuilder();
            for (int i3 = 0; i3 < text.length(); ++i3) {
                char c = text.charAt(i3);
                if (c == '\n') {
                    multiline.append(c);
                    for (int j = 0; j < Math.abs(shift) && i3 + j + 1 < text.length() && (text.charAt(j + i3 + 1) == ' ' || text.charAt(j + i3 + 1) == '\t'); ++j) {
                        ++i3;
                    }
                    continue;
                }
                multiline.append(c);
            }
            return textComment.withText(multiline.toString());
        }
        if (!(comment instanceof Javadoc.DocComment)) return comment;
        Javadoc.DocComment docComment = (Javadoc.DocComment)comment;
        return docComment.withBody(ListUtils.map(docComment.getBody(), (i, jdoc) -> {
            if (!(jdoc instanceof Javadoc.LineBreak)) {
                return jdoc;
            }
            Javadoc.LineBreak lineBreak = (Javadoc.LineBreak)jdoc;
            String linebreak = lineBreak.getMargin().charAt(0) == '\r' ? "\r\n" : "\n";
            return lineBreak.withMargin(lineBreak.getMargin().replaceAll("^\\s+", this.indent(linebreak, column + 1)));
        }));
    }

    private String indent(String whitespace, int shift) {
        StringBuilder newWhitespace = new StringBuilder(whitespace);
        this.shift(newWhitespace, shift);
        return newWhitespace.toString();
    }

    private void shift(StringBuilder text, int shift) {
        int tabIndent = this.style.getTabSize();
        if (!this.style.getUseTabCharacter().booleanValue()) {
            tabIndent = Integer.MAX_VALUE;
        }
        if (shift > 0) {
            int i;
            for (i = 0; i < shift / tabIndent; ++i) {
                text.append('\t');
            }
            for (i = 0; i < shift % tabIndent; ++i) {
                text.append(' ');
            }
        } else {
            int len = this.style.getUseTabCharacter() != false ? text.length() + shift / tabIndent : text.length() + shift;
            if (len >= 0) {
                text.delete(len, text.length());
            }
        }
    }

    private int findIndent(Space space) {
        String indent = space.getIndent();
        return this.getLengthOfWhitespace(indent);
    }

    private int getLengthOfWhitespace(@Nullable String whitespace) {
        if (whitespace == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < whitespace.length(); ++i) {
            char c = whitespace.charAt(i);
            size += c == '\t' ? this.style.getTabSize() : 1;
            if (c != '\n' && c != '\r') continue;
            size = 0;
        }
        return size;
    }

    private int forInitColumn() {
        Cursor forCursor = this.getCursor().dropParentUntil(J.ForLoop.class::isInstance);
        J.ForLoop forLoop = (J.ForLoop)forCursor.getValue();
        Object parent = forCursor.getParentOrThrow().getValue();
        J.ForLoop alignTo = parent instanceof J.Label ? ((J.Label)parent).withStatement(forLoop.withBody(null)) : forLoop.withBody(null);
        int column = 0;
        boolean afterInitStart = false;
        String print = alignTo.print(this.getCursor());
        for (int i = 0; i < print.length(); ++i) {
            char c = print.charAt(i);
            if (c == '(') {
                afterInitStart = true;
            } else if (afterInitStart && !Character.isWhitespace(c)) {
                return column - 1;
            }
            ++column;
        }
        throw new IllegalStateException("For loops must have a control section");
    }

    public @Nullable J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    public @Nullable J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    private static enum IndentType {
        ALIGN,
        INDENT,
        CONTINUATION_INDENT;

    }
}

