/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveMethodInvocationsVisitor;
import org.openrewrite.java.search.UsesMethod;

public final class RemoveMethodInvocations
extends Recipe {
    @Option(displayName="Method pattern", description="A pattern to match method invocations for removal. A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method invocations. For example, to find all method invocations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="java.lang.StringBuilder append(java.lang.String)")
    private final String methodPattern;

    public String getDisplayName() {
        return "Remove method invocations";
    }

    public String getDescription() {
        return "Remove method invocations if syntactically safe.";
    }

    public Validated<Object> validate() {
        return super.validate().and(MethodMatcher.validate(this.methodPattern));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesMethod(this.methodPattern), (TreeVisitor)new RemoveMethodInvocationsVisitor(Collections.singletonList(this.methodPattern)));
    }

    @Generated
    public RemoveMethodInvocations(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveMethodInvocations(methodPattern=" + this.getMethodPattern() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveMethodInvocations)) {
            return false;
        }
        RemoveMethodInvocations other = (RemoveMethodInvocations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveMethodInvocations;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

