/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class TokenCount
extends DataTable<Row> {
    public TokenCount(Recipe recipe) {
        super(recipe, "Token count", "The number of tokens from a code snippet");
    }

    public static final class Row {
        @Column(displayName="Name of Class or Method", description="The name of the class or method.")
        private final String codeSnippet;
        @Column(displayName="Tokens", description="The number of tokens estimated in the code snippet.")
        private final int tokens;

        @Generated
        public Row(String codeSnippet, int tokens) {
            this.codeSnippet = codeSnippet;
            this.tokens = tokens;
        }

        @Generated
        public String getCodeSnippet() {
            return this.codeSnippet;
        }

        @Generated
        public int getTokens() {
            return this.tokens;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getTokens() != other.getTokens()) {
                return false;
            }
            String this$codeSnippet = this.getCodeSnippet();
            String other$codeSnippet = other.getCodeSnippet();
            return !(this$codeSnippet == null ? other$codeSnippet != null : !this$codeSnippet.equals(other$codeSnippet));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTokens();
            String $codeSnippet = this.getCodeSnippet();
            result = result * 59 + ($codeSnippet == null ? 43 : $codeSnippet.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TokenCount.Row(codeSnippet=" + this.getCodeSnippet() + ", tokens=" + this.getTokens() + ")";
        }
    }
}

