/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;

class AnnotationDeserializer {
    private static final int MAX_NESTING_DEPTH = 32;
    private static final String JVM_PRIMITIVE_DESCRIPTORS = "VZCBSIFJD";

    AnnotationDeserializer() {
    }

    public static AnnotationInfo parseAnnotation(String annotationStr) {
        if (!annotationStr.startsWith("@")) {
            throw new IllegalArgumentException("Invalid annotation format: " + annotationStr);
        }
        Parser parser = new Parser(annotationStr);
        return parser.parseSingleAnnotation();
    }

    public static List<AnnotationInfo> parseAnnotations(String annotationsStr) {
        if (annotationsStr.isEmpty()) {
            return new ArrayList<AnnotationInfo>();
        }
        ArrayList<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();
        Parser parser = new Parser(annotationsStr);
        while (parser.pos < parser.input.length() && parser.peek() == '@') {
            annotations.add(parser.parseSingleAnnotation());
        }
        return annotations;
    }

    public static Object parseValue(String value) {
        Parser parser = new Parser(value);
        return parser.parseValue(0);
    }

    private static class Parser {
        private final String input;
        private int pos = 0;

        Parser(String input) {
            this.input = input;
        }

        private char peek() {
            return this.pos < this.input.length() ? this.input.charAt(this.pos) : (char)'\u0000';
        }

        private char consume() {
            return this.pos < this.input.length() ? this.input.charAt(this.pos++) : (char)'\u0000';
        }

        private void expect(char expected) {
            int errorPos = this.pos;
            char actual = this.consume();
            if (actual != expected) {
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append("Expected '").append(expected).append("' at position ").append(errorPos);
                if (actual == '\u0000') {
                    errorMsg.append(", but reached end of input");
                } else {
                    errorMsg.append(", but found '").append(actual).append("'");
                }
                errorMsg.append(this.inputWithErrorIndicator(errorPos));
                throw new IllegalArgumentException(errorMsg.toString());
            }
        }

        private String inputWithErrorIndicator(int errorPos) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append("\nInput string: ").append(this.input);
            errorMsg.append("\nPosition indicator: ");
            for (int i = 0; i < errorPos - 6; ++i) {
                errorMsg.append(' ');
            }
            errorMsg.append('^');
            int contextStart = Math.max(0, errorPos - 20);
            int contextEnd = Math.min(this.input.length(), errorPos + 20);
            if (contextStart > 0 || contextEnd < this.input.length()) {
                errorMsg.append("\nContext: ");
                if (contextStart > 0) {
                    errorMsg.append("...");
                }
                errorMsg.append(this.input, contextStart, contextEnd);
                if (contextEnd < this.input.length()) {
                    errorMsg.append("...");
                }
            }
            return errorMsg.toString();
        }

        private List<AttributeInfo> parseAttributes() {
            String attributeName;
            ArrayList<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
            while (this.pos < this.input.length() && !(attributeName = this.parseIdentifier()).isEmpty()) {
                this.expect('=');
                Object attributeValue = this.parseValue(0);
                attributes.add(new AttributeInfo(attributeName, attributeValue));
                if (this.peek() != ',') break;
                this.consume();
            }
            return attributes;
        }

        private String parseIdentifier() {
            char c;
            int start = this.pos;
            if (!Character.isJavaIdentifierStart(this.peek())) {
                throw new IllegalArgumentException("Expected identifier at position " + this.pos + " but found '" + this.peek() + "'" + this.inputWithErrorIndicator(this.pos));
            }
            while (this.pos < this.input.length() && Character.isJavaIdentifierPart(c = this.peek())) {
                this.consume();
            }
            return this.input.substring(start, this.pos);
        }

        private Object[] parseArrayValue(int depth) {
            ArrayList<Object> elements = new ArrayList<Object>();
            this.expect('[');
            while (this.pos < this.input.length() && this.peek() != ']') {
                Object element = this.parseValue(depth);
                elements.add(element);
                if (this.peek() != ',') break;
                this.consume();
            }
            this.expect(']');
            return elements.toArray();
        }

        private AnnotationInfo parseNestedAnnotationValue(int depth) {
            if (depth > 32) {
                throw new IllegalArgumentException("Maximum nesting depth of 32 exceeded while parsing nested annotation: " + this.input);
            }
            return this.parseSingleAnnotation();
        }

        private AnnotationInfo parseSingleAnnotation() {
            this.expect('@');
            ClassConstant annotationName = this.parseClassConstantValue();
            if (this.peek() != '(') {
                return new AnnotationInfo(annotationName.getDescriptor(), null);
            }
            this.expect('(');
            List<AttributeInfo> attributes = this.parseAttributes();
            this.expect(')');
            return new AnnotationInfo(annotationName.getDescriptor(), attributes);
        }

        private Object parseValue(int depth) {
            if (depth > 32) {
                throw new IllegalArgumentException("Maximum nesting depth of 32 exceeded while parsing: " + this.input);
            }
            char typePrefix = this.peek();
            switch (typePrefix) {
                case 'Z': {
                    this.consume();
                    return this.parseBooleanValue();
                }
                case 'B': {
                    this.consume();
                    return Byte.parseByte(this.parseNumericValue());
                }
                case 'C': {
                    this.consume();
                    return this.parseCharValue();
                }
                case 'S': {
                    this.consume();
                    return Short.parseShort(this.parseNumericValue());
                }
                case 'I': {
                    this.consume();
                    return Integer.parseInt(this.parseNumericValue());
                }
                case 'J': {
                    this.consume();
                    return Long.parseLong(this.parseNumericValue());
                }
                case 'F': {
                    this.consume();
                    return Float.valueOf(Float.parseFloat(this.parseNumericValue()));
                }
                case 'D': {
                    this.consume();
                    return Double.parseDouble(this.parseNumericValue());
                }
                case 's': {
                    this.consume();
                    return this.parseStringValue();
                }
                case 'c': {
                    this.consume();
                    return this.parseClassConstantValue();
                }
                case 'e': {
                    this.consume();
                    return this.parseEnumConstantValue();
                }
                case '[': {
                    return this.parseArrayValue(depth);
                }
                case '@': {
                    return this.parseNestedAnnotationValue(depth + 1);
                }
            }
            throw new IllegalArgumentException("Unknown value format at position " + this.pos + ": " + this.peek() + this.inputWithErrorIndicator(this.pos));
        }

        private Object parseBooleanValue() {
            if (this.matchesAtPosition("true")) {
                this.pos += 4;
                return Boolean.TRUE;
            }
            if (this.matchesAtPosition("false")) {
                this.pos += 5;
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Expected boolean value at position " + this.pos);
        }

        private Object parseCharValue() {
            String numStr = this.parseNumericValue();
            return Character.valueOf((char)Integer.parseInt(numStr));
        }

        private Object parseStringValue() {
            this.expect('\"');
            StringBuilder sb = new StringBuilder();
            boolean escaped = false;
            while (this.pos < this.input.length()) {
                char c = this.peek();
                if (escaped) {
                    switch (c) {
                        case '\"': {
                            sb.append('\"');
                            break;
                        }
                        case '\\': {
                            sb.append('\\');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case '|': {
                            sb.append('|');
                            break;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                    escaped = false;
                } else if (c == '\\') {
                    escaped = true;
                } else {
                    if (c == '\"') {
                        this.consume();
                        return sb.toString();
                    }
                    sb.append(c);
                }
                this.consume();
            }
            throw new IllegalArgumentException("Unterminated string at position " + (this.pos - sb.length()));
        }

        private ClassConstant parseClassConstantValue() {
            int start = this.pos;
            if (this.peek() == '[') {
                while (this.pos < this.input.length() && this.peek() == '[') {
                    this.consume();
                }
            }
            if (this.peek() == 'L') {
                this.consume();
                while (this.pos < this.input.length() && this.peek() != ';') {
                    this.consume();
                }
                if (this.pos < this.input.length()) {
                    this.consume();
                }
            } else if (this.isPrimitiveTypeDescriptor()) {
                this.consume();
            }
            String descriptor = this.input.substring(start, this.pos);
            return new ClassConstant(descriptor);
        }

        private Object parseEnumConstantValue() {
            int start = this.pos;
            this.expect('L');
            while (this.pos < this.input.length() && this.peek() != ';') {
                this.consume();
            }
            this.expect(';');
            int semicolonPos = this.pos - 1;
            this.expect('.');
            return new EnumConstant(this.input.substring(start, semicolonPos + 1), this.parseIdentifier());
        }

        private String parseNumericValue() {
            char c;
            int start = this.pos;
            boolean hasSign = false;
            if (this.peek() == '-' || this.peek() == '+') {
                this.consume();
                hasSign = true;
            }
            while (this.pos < this.input.length() && (Character.isDigit(c = this.peek()) || c == '.')) {
                this.consume();
            }
            if (this.pos == start || hasSign && this.pos == start + 1) {
                throw new IllegalArgumentException("Expected numeric value at position " + start + this.inputWithErrorIndicator(start));
            }
            return this.input.substring(start, this.pos);
        }

        private boolean isPrimitiveTypeDescriptor() {
            char c = this.peek();
            return AnnotationDeserializer.JVM_PRIMITIVE_DESCRIPTORS.indexOf(c) != -1;
        }

        private boolean matchesAtPosition(String text) {
            if (this.pos + text.length() > this.input.length()) {
                return false;
            }
            return this.input.startsWith(text, this.pos);
        }
    }

    public static class AnnotationInfo {
        private final String descriptor;
        private final @Nullable List<AttributeInfo> attributes;

        public AnnotationInfo(String descriptor, @Nullable List<AttributeInfo> attributes) {
            this.descriptor = descriptor;
            this.attributes = attributes;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public @Nullable List<AttributeInfo> getAttributes() {
            return this.attributes;
        }
    }

    public static class FieldConstant {
        private final String className;
        private final String fieldName;

        public FieldConstant(String className, String fieldName) {
            this.className = className;
            this.fieldName = fieldName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    public static class EnumConstant {
        private final String enumDescriptor;
        private final String constantName;

        public EnumConstant(String enumDescriptor, String constantName) {
            this.enumDescriptor = enumDescriptor;
            this.constantName = constantName;
        }

        public String getEnumDescriptor() {
            return this.enumDescriptor;
        }

        public String getConstantName() {
            return this.constantName;
        }
    }

    public static class ClassConstant {
        private final String descriptor;

        public ClassConstant(String descriptor) {
            this.descriptor = descriptor;
        }

        public String getDescriptor() {
            return this.descriptor;
        }
    }

    public static class AttributeInfo {
        private final String name;
        private final Object value;

        public AttributeInfo(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

