/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractFileSetCheck;
import org.openrewrite.tools.checkstyle.api.FileText;

@StatelessCheck
public class OrderedPropertiesCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY = "properties.notSorted.property";
    public static final String MSG_IO_EXCEPTION_KEY = "unable.open.cause";
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");

    public OrderedPropertiesCheck() {
        this.setFileExtensions("properties");
    }

    @Override
    protected void processFiltered(File file, FileText fileText) {
        SequencedProperties properties = new SequencedProperties();
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            properties.load(inputStream);
        }
        catch (IOException | IllegalArgumentException ex) {
            this.log(1, MSG_IO_EXCEPTION_KEY, file.getPath(), ex.getLocalizedMessage());
        }
        String previousProp = "";
        int startLineNo = 0;
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String propKey = (String)keys.nextElement();
            if (String.CASE_INSENSITIVE_ORDER.compare(previousProp, propKey) > 0) {
                int lineNo = OrderedPropertiesCheck.getLineNumber(startLineNo, fileText, previousProp, propKey);
                this.log(lineNo + 1, MSG_KEY, propKey, previousProp);
                startLineNo = lineNo;
            }
            previousProp = propKey;
        }
    }

    private static int getLineNumber(int startLineNo, FileText fileText, String previousProp, String propKey) {
        int indexOfPreviousProp = OrderedPropertiesCheck.getIndex(startLineNo, fileText, previousProp);
        return OrderedPropertiesCheck.getIndex(indexOfPreviousProp, fileText, propKey);
    }

    private static int getIndex(int startLineNo, FileText fileText, String keyName) {
        Pattern keyPattern = OrderedPropertiesCheck.getKeyPattern(keyName);
        int indexNumber = 0;
        Matcher matcher = keyPattern.matcher("");
        for (int index = startLineNo; index < fileText.size(); ++index) {
            String line = fileText.get(index);
            matcher.reset(line);
            if (!matcher.matches()) continue;
            indexNumber = index;
            break;
        }
        return indexNumber;
    }

    private static Pattern getKeyPattern(String keyName) {
        String keyPatternString = "^" + SPACE_PATTERN.matcher(keyName).replaceAll(Matcher.quoteReplacement("\\\\ ")) + "[\\s:=].*";
        return Pattern.compile(keyPatternString);
    }

    private static class SequencedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private final List<Object> keyList = new ArrayList<Object>();

        private SequencedProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(this.keyList);
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            this.keyList.add(key);
            return super.put(key, value);
        }
    }
}

