/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.Style;

public class NormalizeTabsOrSpaces
extends Recipe {
    public String getDisplayName() {
        return "Normalize to tabs or spaces";
    }

    public String getDescription() {
        return "Consistently use either tabs or spaces in indentation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TabsAndIndentsFromCompilationUnitStyle();
    }

    private static class TabsAndIndentsFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private TabsAndIndentsFromCompilationUnitStyle() {
        }

        public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                TabsAndIndentsStyle style = (TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)cu, IntelliJ::tabsAndIndents);
                return new NormalizeTabsOrSpacesVisitor(style).visit((Tree)cu, ctx);
            }
            return (J)tree;
        }
    }
}

