/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.service.SourcePositionService;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.LineWrapSetting;

public final class WrapMethodChains<P>
extends JavaIsoVisitor<P> {
    private final WrappingAndBracesStyle style;

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P ctx) {
        J m = super.visitMethodInvocation(method, (Object)ctx);
        try {
            if (this.style != null && this.style.getChainedMethodCalls() != null) {
                boolean isBuilderMethod;
                List matchers = this.style.getChainedMethodCalls().getBuilderMethods().stream().map(name -> String.format("*..* %s(..)", name)).map(MethodMatcher::new).collect(Collectors.toList());
                J chainStarter = this.findChainStarterInChain((J.MethodInvocation)m);
                if (chainStarter == m || ((J.MethodInvocation)m).getPadding().getSelect() == null) {
                    return m;
                }
                Space after = ((J.MethodInvocation)m).getPadding().getSelect().getAfter();
                if (after.getLastWhitespace().contains("\n")) {
                    return m;
                }
                boolean bl = isBuilderMethod = chainStarter instanceof J.MethodInvocation && matchers.stream().anyMatch(matcher -> matcher.matches((J.MethodInvocation)chainStarter));
                if (isBuilderMethod || this.style.getChainedMethodCalls().getWrap() == LineWrapSetting.WrapAlways || this.style.getChainedMethodCalls().getWrap() == LineWrapSetting.ChopIfTooLong) {
                    JavaSourceFile sourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                    if (!(isBuilderMethod || this.style.getChainedMethodCalls().getWrap() != LineWrapSetting.ChopIfTooLong || sourceFile != null && ((SourcePositionService)sourceFile.service(SourcePositionService.class)).computeTreeLength(this.getCursor()) > this.style.getHardWrapAt())) {
                        return m;
                    }
                    if ((after = after.getComments().isEmpty() ? after.withWhitespace("\n") : after.withComments(ListUtils.mapLast(after.getComments(), comment -> comment == null ? null : (Comment)comment.withSuffix("\n")))) != ((J.MethodInvocation)m).getPadding().getSelect().getAfter()) {
                        m = ((J.MethodInvocation)m).getPadding().withSelect(((J.MethodInvocation)m).getPadding().getSelect().withAfter(after)).withArguments(ListUtils.map(((J.MethodInvocation)m).getArguments(), arg -> (Expression)arg.withPrefix(Space.EMPTY)));
                    }
                }
            }
        }
        catch (NoSuchFieldError | NoSuchMethodError incompatibleClassChangeError) {
            // empty catch block
        }
        return m;
    }

    private J findChainStarterInChain(J.MethodInvocation method) {
        J.MethodInvocation chainStarter = method;
        Expression select = method.getSelect();
        while (select instanceof J.MethodInvocation) {
            chainStarter = (J.MethodInvocation)select;
            select = chainStarter.getSelect();
        }
        return chainStarter;
    }

    @Generated
    public WrapMethodChains(WrappingAndBracesStyle style) {
        this.style = style;
    }

    @Generated
    public WrappingAndBracesStyle getStyle() {
        return this.style;
    }

    @NonNull
    @Generated
    public String toString() {
        return "WrapMethodChains(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrapMethodChains)) {
            return false;
        }
        WrapMethodChains other = (WrapMethodChains)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WrappingAndBracesStyle this$style = this.getStyle();
        WrappingAndBracesStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)this$style).equals(other$style));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof WrapMethodChains;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WrappingAndBracesStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        return result;
    }
}

