/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class RemoveObjectsIsNull
extends Recipe {
    private static final MethodMatcher IS_NULL = new MethodMatcher("java.util.Objects isNull(..)");
    private static final MethodMatcher NON_NULL = new MethodMatcher("java.util.Objects nonNull(..)");

    public String getDisplayName() {
        return "Transform calls to `Objects.isNull(..)` and `Objects.nonNull(..)`";
    }

    public String getDescription() {
        return "Replace calls to `Objects.isNull(..)` and `Objects.nonNull(..)` with a simple null check. Using these methods outside of stream predicates is not idiomatic.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(IS_NULL), new UsesMethod(NON_NULL)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public Expression visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, ctx);
                if (IS_NULL.matches(m)) {
                    return this.replace(m, "(#{any()}) == null", ctx);
                }
                if (NON_NULL.matches(m)) {
                    return this.replace(m, "(#{any()}) != null", ctx);
                }
                return m;
            }

            private Expression replace(J.MethodInvocation m, String pattern, ExecutionContext ctx) {
                this.maybeRemoveImport("java.util.Objects");
                this.maybeRemoveImport("java.util.Objects." + m.getSimpleName());
                JavaType type = m.getArguments().get(0).getType();
                if (type instanceof JavaType.Primitive && JavaType.Primitive.String != type) {
                    boolean replacementValue = NON_NULL.matches(m);
                    return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, replacementValue, String.valueOf(replacementValue), null, JavaType.Primitive.Boolean);
                }
                Cursor parentTreeCursor = this.getCursor().getParentTreeCursor();
                if (!(parentTreeCursor.getValue() instanceof J.ControlParentheses) && !(parentTreeCursor.getValue() instanceof J.Parentheses)) {
                    pattern = '(' + pattern + ')';
                }
                parentTreeCursor.putMessage("SIMPLIFY_BOOLEAN_EXPRESSION", (Object)true);
                parentTreeCursor.putMessage("REMOVE_UNNECESSARY_PARENTHESES", (Object)true);
                return (Expression)JavaTemplate.apply(pattern, this.getCursor(), m.getCoordinates().replace(), m.getArguments().get(0));
            }

            public J postVisit(J tree, ExecutionContext ctx) {
                J j = (J)super.postVisit((Tree)tree, (Object)ctx);
                if (Boolean.TRUE.equals(this.getCursor().pollMessage("SIMPLIFY_BOOLEAN_EXPRESSION"))) {
                    j = (J)new SimplifyBooleanExpressionVisitor().visit(j, ctx, this.getCursor().getParentOrThrow());
                }
                if (Boolean.TRUE.equals(this.getCursor().pollMessage("REMOVE_UNNECESSARY_PARENTHESES"))) {
                    j = (J)new UnnecessaryParenthesesVisitor().visit(j, ctx, this.getCursor().getParentOrThrow());
                }
                return j;
            }
        });
    }
}

