/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.table;

import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class ClasspathTypeCount
extends DataTable<Row> {
    public ClasspathTypeCount(Recipe recipe) {
        super(recipe, "Classpath type count", "The number of types in each source set in a project's classpath.");
    }

    public static final class Row {
        @Column(displayName="Project name", description="The name of the (sub)project.")
        private final String project;
        @Column(displayName="Source set", description="The source set name.")
        private final String sourceSet;
        @Column(displayName="Types", description="The number of types in the source set.")
        private final int types;

        @Generated
        public Row(String project, String sourceSet, int types) {
            this.project = project;
            this.sourceSet = sourceSet;
            this.types = types;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public String getSourceSet() {
            return this.sourceSet;
        }

        @Generated
        public int getTypes() {
            return this.types;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getTypes() != other.getTypes()) {
                return false;
            }
            String this$project = this.getProject();
            String other$project = other.getProject();
            if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
                return false;
            }
            String this$sourceSet = this.getSourceSet();
            String other$sourceSet = other.getSourceSet();
            return !(this$sourceSet == null ? other$sourceSet != null : !this$sourceSet.equals(other$sourceSet));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTypes();
            String $project = this.getProject();
            result = result * 59 + ($project == null ? 43 : $project.hashCode());
            String $sourceSet = this.getSourceSet();
            result = result * 59 + ($sourceSet == null ? 43 : $sourceSet.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ClasspathTypeCount.Row(project=" + this.getProject() + ", sourceSet=" + this.getSourceSet() + ", types=" + this.getTypes() + ")";
        }
    }
}

