/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.ExactTypeNameMatcher;
import org.openrewrite.java.PatternTypeNameMatcher;
import org.openrewrite.java.TypeNameMatcher;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.trait.Reference;

public class TypeMatcher
implements Reference.Matcher {
    private final String signature;
    private final TypeNameMatcher typeNameMatcher;
    private final boolean matchInherited;

    public TypeMatcher(@Nullable String typePattern) {
        this(typePattern, false);
    }

    public TypeMatcher(@Nullable String typePattern, boolean matchInherited) {
        ParsedType parsed;
        String pattern;
        this.signature = typePattern == null ? ".*" : typePattern;
        this.matchInherited = matchInherited;
        this.typeNameMatcher = StringUtils.isBlank((String)typePattern) ? PatternTypeNameMatcher.fullWildcard("*") : (!(pattern = (parsed = TypeMatcher.parseTypePattern(typePattern)).getFullPattern()).contains("*") && !pattern.contains("..") ? new ExactTypeNameMatcher(pattern) : PatternTypeNameMatcher.fromPattern(pattern));
    }

    public boolean matches(@Nullable TypeTree tt) {
        return tt != null && this.matches(tt.getType());
    }

    public boolean matchesPackage(String packageName) {
        if (this.typeNameMatcher.matches(packageName)) {
            return true;
        }
        if (packageName.endsWith(".*")) {
            String packagePrefix = packageName.substring(0, packageName.length() - 2);
            int lastDot = this.signature.lastIndexOf(46);
            if (lastDot >= 0) {
                String fullName = packagePrefix + "." + this.signature.substring(lastDot + 1);
                return this.typeNameMatcher.matches(fullName);
            }
        }
        return false;
    }

    public boolean matches(@Nullable JavaType type) {
        if (type instanceof JavaType.FullyQualified && this.typeNameMatcher.matches(((JavaType.FullyQualified)type).getFullyQualifiedName())) {
            return true;
        }
        if (this.matchInherited && type instanceof JavaType.FullyQualified) {
            return TypeUtils.isOfTypeWithName(TypeUtils.asFullyQualified(type), this.matchInherited, this::matchesTargetTypeName);
        }
        return type instanceof JavaType.Primitive && this.typeNameMatcher.matches(type.toString());
    }

    private boolean matchesTargetTypeName(String fullyQualifiedTypeName) {
        return this.typeNameMatcher.matches(fullyQualifiedTypeName);
    }

    public boolean matchesReference(Reference reference) {
        return reference.getKind() == Reference.Kind.TYPE && this.matchesTargetTypeName(reference.getValue());
    }

    public Reference.Renamer createRenamer(String newName) {
        return reference -> newName;
    }

    static ParsedType parseTypePattern(String pattern) {
        String baseType;
        int pos;
        int arrayDimensions = 0;
        for (pos = pattern.length(); pos >= 2 && pattern.charAt(pos - 2) == '[' && pattern.charAt(pos - 1) == ']'; pos -= 2) {
            ++arrayDimensions;
        }
        String string = baseType = arrayDimensions > 0 ? pattern.substring(0, pos).trim() : pattern;
        if (!(baseType.contains(".") || baseType.contains("*") || Character.isLowerCase(baseType.charAt(0)) && JavaType.Primitive.fromKeyword(baseType) != null || TypeUtils.findQualifiedJavaLangTypeName(baseType) == null)) {
            baseType = "java.lang." + baseType;
        }
        return new ParsedType(baseType, arrayDimensions);
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public TypeNameMatcher getTypeNameMatcher() {
        return this.typeNameMatcher;
    }

    @Generated
    public boolean isMatchInherited() {
        return this.matchInherited;
    }

    static class ParsedType {
        private final String baseType;
        private final int arrayDimensions;

        ParsedType(String baseType, int arrayDimensions) {
            this.baseType = baseType;
            this.arrayDimensions = arrayDimensions;
        }

        public String getBaseType() {
            return this.baseType;
        }

        public int getArrayDimensions() {
            return this.arrayDimensions;
        }

        public String getFullPattern() {
            if (this.arrayDimensions == 0) {
                return this.baseType;
            }
            StringBuilder result = new StringBuilder(this.baseType);
            for (int i = 0; i < this.arrayDimensions; ++i) {
                result.append("[]");
            }
            return result.toString();
        }
    }
}

