/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public final class AddCommentToMethod
extends Recipe {
    @Option(displayName="Comment", description="The comment to add.", example="This is a comment.")
    private final String comment;
    @Option(displayName="Method pattern", description="A pattern to match methods to add the comment to. A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method declarations. For example, to find all method declarations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="java.util.List add*(..)")
    private final String methodPattern;
    @Option(displayName="Multiline", description="Comments use by default single line // but they can use multiline /* */.", required=false)
    private final @Nullable Boolean isMultiline;
    private static final Pattern NEWLINE = Pattern.compile("\\R");

    public String getDisplayName() {
        return "Add comment to method declarations";
    }

    public String getDescription() {
        return "Add a comment to method declarations in a Java source file.";
    }

    public Validated<Object> validate() {
        return super.validate().and(MethodMatcher.validate(this.methodPattern));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern);
        return Preconditions.check(new DeclaresMethod(methodMatcher), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.ClassDeclaration cd;
                J m = super.visitMethodDeclaration(method, ctx);
                if (methodMatcher.matches((J.MethodDeclaration)m, cd = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class))) {
                    String newCommentText;
                    String methodPrefixWhitespace = ((J.MethodDeclaration)m).getPrefix().getWhitespace();
                    boolean createMultiline = Boolean.TRUE.equals(AddCommentToMethod.this.isMultiline);
                    Matcher matcher = NEWLINE.matcher(AddCommentToMethod.this.comment);
                    String string = matcher.find() ? matcher.replaceAll(createMultiline ? methodPrefixWhitespace : " ") : (newCommentText = AddCommentToMethod.this.comment);
                    if (this.doesNotHaveComment(newCommentText, m.getComments())) {
                        TextComment textComment = new TextComment(createMultiline, newCommentText, methodPrefixWhitespace, Markers.EMPTY);
                        return (J.MethodDeclaration)m.withComments(ListUtils.concat(m.getComments(), (Object)textComment));
                    }
                }
                return m;
            }

            private boolean doesNotHaveComment(String lookFor, List<Comment> comments) {
                for (Comment c : comments) {
                    if (!(c instanceof TextComment) || !lookFor.equals(((TextComment)c).getText())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Generated
    public AddCommentToMethod(String comment, String methodPattern, @Nullable Boolean isMultiline) {
        this.comment = comment;
        this.methodPattern = methodPattern;
        this.isMultiline = isMultiline;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public @Nullable Boolean getIsMultiline() {
        return this.isMultiline;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddCommentToMethod(comment=" + this.getComment() + ", methodPattern=" + this.getMethodPattern() + ", isMultiline=" + this.getIsMultiline() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddCommentToMethod)) {
            return false;
        }
        AddCommentToMethod other = (AddCommentToMethod)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$isMultiline = this.getIsMultiline();
        Boolean other$isMultiline = other.getIsMultiline();
        if (this$isMultiline == null ? other$isMultiline != null : !((Object)this$isMultiline).equals(other$isMultiline)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddCommentToMethod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isMultiline = this.getIsMultiline();
        result = result * 59 + ($isMultiline == null ? 43 : ((Object)$isMultiline).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

