/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.NoWhitespaceAfterStyle;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.style.Style;

public class NoWhitespaceAfter
extends Recipe {
    public String getDisplayName() {
        return "No whitespace after";
    }

    public String getDescription() {
        return "Removes unnecessary whitespace appearing after a token. A linebreak after a token is allowed unless `allowLineBreaks` is set to `false`, in which case it will be removed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new NoWhitespaceAfterVisitor();
    }

    private static class NoWhitespaceAfterVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        SpacesStyle spacesStyle;
        NoWhitespaceAfterStyle noWhitespaceAfterStyle;
        @Nullable EmptyForInitializerPadStyle emptyForInitializerPadStyle;
        @Nullable EmptyForIteratorPadStyle emptyForIteratorPadStyle;

        private NoWhitespaceAfterVisitor() {
        }

        @Override
        public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
            return sourceFile instanceof J.CompilationUnit;
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                SourceFile cu = (SourceFile)Objects.requireNonNull(tree);
                this.spacesStyle = (SpacesStyle)Style.from(SpacesStyle.class, (SourceFile)cu, IntelliJ::spaces);
                this.noWhitespaceAfterStyle = (NoWhitespaceAfterStyle)Style.from(NoWhitespaceAfterStyle.class, (SourceFile)cu, Checkstyle::noWhitespaceAfterStyle);
                this.emptyForInitializerPadStyle = (EmptyForInitializerPadStyle)Style.from(EmptyForInitializerPadStyle.class, (SourceFile)cu);
                this.emptyForIteratorPadStyle = (EmptyForIteratorPadStyle)Style.from(EmptyForIteratorPadStyle.class, (SourceFile)cu);
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        @Override
        public J.TypeCast visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
            J t = super.visitTypeCast(typeCast, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getTypecast())) {
                t = (J.TypeCast)new SpacesVisitor(this.spacesStyle.withOther(this.spacesStyle.getOther().withAfterTypeCast(false)), this.emptyForInitializerPadStyle, this.emptyForIteratorPadStyle, null, false).visitNonNull(t, ctx);
            }
            return t;
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
            J m = super.visitMemberReference(memberRef, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getMethodRef())) {
                m = (J.MemberReference)new SpacesVisitor(this.spacesStyle, this.emptyForInitializerPadStyle, this.emptyForIteratorPadStyle, null, false).visitNonNull(m, ctx);
            }
            return m;
        }

        @Override
        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            J a = super.visitAnnotation(annotation, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getAnnotation())) {
                a = ((J.Annotation)a).withAnnotationType((NameTree)((J.Annotation)a).getAnnotationType().withPrefix(((J.Annotation)a).getAnnotationType().getPrefix().withWhitespace("")));
            }
            return a;
        }

        @Override
        public J.ArrayType visitArrayType(J.ArrayType arrayType, ExecutionContext ctx) {
            J a = super.visitArrayType(arrayType, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getArrayDeclarator()) && ((J.ArrayType)a).getDimension() != null && ((J.ArrayType)a).getDimension().getBefore().getWhitespace().contains(" ") && (((J.ArrayType)a).getAnnotations() == null || ((J.ArrayType)a).getAnnotations().isEmpty())) {
                a = ((J.ArrayType)a).withDimension(((J.ArrayType)a).getDimension().withBefore(((J.ArrayType)a).getDimension().getBefore().withWhitespace("")));
            }
            return a;
        }

        @Override
        public J.NewArray visitNewArray(J.NewArray newArray, ExecutionContext ctx) {
            J n = super.visitNewArray(newArray, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getArrayInitializer())) {
                n = (J.NewArray)new SpacesVisitor(this.spacesStyle, this.emptyForInitializerPadStyle, this.emptyForIteratorPadStyle, null, false).visitNonNull(n, ctx);
            }
            return n;
        }

        @Override
        public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, ExecutionContext ctx) {
            J a = super.visitArrayAccess(arrayAccess, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getIndexOperation())) {
                a = ((J.ArrayAccess)a).withDimension(((J.ArrayAccess)a).getDimension().withPrefix(((J.ArrayAccess)a).getDimension().getPrefix().withWhitespace("")));
            }
            return a;
        }

        @Override
        public J.Unary visitUnary(J.Unary unary, ExecutionContext ctx) {
            J u = super.visitUnary(unary, ctx);
            J.Unary.Type op = ((J.Unary)u).getOperator();
            if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getInc()) && op == J.Unary.Type.PreIncrement || Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getDec()) && op == J.Unary.Type.PreDecrement || Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getBnoc()) && op == J.Unary.Type.Complement || Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getLnot()) && op == J.Unary.Type.Not || Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getUnaryPlus()) && op == J.Unary.Type.Positive || Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getUnaryMinus()) && op == J.Unary.Type.Negative) {
                u = (J.Unary)new SpacesVisitor(this.spacesStyle, this.emptyForInitializerPadStyle, this.emptyForIteratorPadStyle, null, false).visitNonNull(u, ctx);
            }
            return u;
        }

        @Override
        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            J f = super.visitFieldAccess(fieldAccess, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getDot())) {
                if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getAllowLineBreaks()) && ((J.FieldAccess)f).getName().getPrefix().getWhitespace().contains("\n")) {
                    return f;
                }
                if (((J.FieldAccess)f).getName().getPrefix().getWhitespace().contains(" ")) {
                    f = ((J.FieldAccess)f).withName(((J.FieldAccess)f).getName().withPrefix(((J.FieldAccess)f).getName().getPrefix().withWhitespace("")));
                }
            }
            return f;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getDot())) {
                if (Boolean.TRUE.equals(this.noWhitespaceAfterStyle.getAllowLineBreaks()) && ((J.MethodInvocation)m).getName().getPrefix().getWhitespace().contains("\n")) {
                    return m;
                }
                m = ((J.MethodInvocation)m).withName(((J.MethodInvocation)m).getName().withPrefix(((J.MethodInvocation)m).getName().getPrefix().withWhitespace("")));
                m = (J.MethodInvocation)new SpacesVisitor(this.spacesStyle, this.emptyForInitializerPadStyle, this.emptyForIteratorPadStyle, null, false).visitNonNull(m, ctx);
            }
            return m;
        }
    }
}

