/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.internal.rpc;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Comment;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;
import org.openrewrite.rpc.Reference;
import org.openrewrite.rpc.RpcSendQueue;

public class JsonSender
extends JsonVisitor<RpcSendQueue> {
    public Json preVisit(Json j, RpcSendQueue q) {
        q.getAndSend((Object)j, Tree::getId);
        q.getAndSend((Object)j, j2 -> Reference.asRef((Object)j2.getPrefix()), space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        q.sendMarkers((Object)j, Tree::getMarkers);
        return j;
    }

    @Override
    public Json visitDocument(Json.Document document, RpcSendQueue q) {
        q.getAndSend((Object)document, d -> d.getSourcePath().toString());
        q.getAndSend((Object)document, d -> d.getCharset().name());
        q.getAndSend((Object)document, Json.Document::isCharsetBomMarked);
        q.getAndSend((Object)document, Json.Document::getChecksum);
        q.getAndSend((Object)document, Json.Document::getFileAttributes);
        q.getAndSend((Object)document, Json.Document::getValue, j -> this.visit((Tree)j, q));
        q.getAndSend((Object)document, d -> Reference.asRef((Object)d.getEof()));
        return document;
    }

    @Override
    public Json visitArray(Json.Array array, RpcSendQueue q) {
        q.getAndSendList((Object)array, a -> a.getPadding().getValues(), j -> ((JsonValue)j.getElement()).getId(), j -> this.visitRightPadded((JsonRightPadded)j, q));
        return array;
    }

    @Override
    public Json visitEmpty(Json.Empty empty, RpcSendQueue q) {
        return empty;
    }

    @Override
    public Json visitIdentifier(Json.Identifier identifier, RpcSendQueue q) {
        q.getAndSend((Object)identifier, Json.Identifier::getName);
        return identifier;
    }

    @Override
    public Json visitLiteral(Json.Literal literal, RpcSendQueue q) {
        q.getAndSend((Object)literal, Json.Literal::getSource);
        q.getAndSend((Object)literal, Json.Literal::getValue);
        return literal;
    }

    @Override
    public Json visitMember(Json.Member member, RpcSendQueue q) {
        q.getAndSend((Object)member, m -> m.getPadding().getKey(), j -> this.visitRightPadded((JsonRightPadded)j, q));
        q.getAndSend((Object)member, Json.Member::getValue, j -> this.visit((Tree)j, q));
        return member;
    }

    @Override
    public Json visitObject(Json.JsonObject obj, RpcSendQueue q) {
        q.getAndSendList((Object)obj, o -> o.getPadding().getMembers(), j -> j.getElement().getId(), j -> this.visitRightPadded((JsonRightPadded)j, q));
        return obj;
    }

    @Override
    public Space visitSpace(Space space, RpcSendQueue q) {
        q.getAndSendList((Object)space, Space::getComments, c -> c.getText() + c.getSuffix(), c -> {
            q.getAndSend(c, Comment::isMultiline);
            q.getAndSend(c, Comment::getText);
            q.getAndSend(c, Comment::getSuffix);
            q.sendMarkers(c, Comment::getMarkers);
        });
        q.getAndSend((Object)space, Space::getWhitespace);
        return space;
    }

    @Override
    public <T extends Json> @Nullable JsonRightPadded<T> visitRightPadded(@Nullable JsonRightPadded<T> right, RpcSendQueue q) {
        q.getAndSend(right, JsonRightPadded::getElement, j -> this.visit((Tree)j, q));
        q.getAndSend(right, j -> Reference.asRef((Object)j.getAfter()), space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        q.sendMarkers(right, JsonRightPadded::getMarkers);
        return right;
    }
}

