/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.style.TabsAndIndentsStyle;

public class NormalizeTabsOrSpacesVisitor<P>
extends KotlinIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final TabsAndIndentsStyle style;

    public NormalizeTabsOrSpacesVisitor(TabsAndIndentsStyle style) {
        this(style, null);
    }

    public NormalizeTabsOrSpacesVisitor(TabsAndIndentsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    public Space visitSpace(Space space, Space.Location loc, P p) {
        Space s = space.withWhitespace(this.normalizeAfterFirstNewline(space.getWhitespace()));
        return s.withComments(ListUtils.map((List)s.getComments(), comment -> {
            Comment c = comment;
            if (c.isMultiline()) {
                if (c instanceof Javadoc) {
                    c = c.withSuffix(this.normalize(c.getSuffix(), false));
                    return (Comment)new JavadocVisitor<Integer>(new JavaVisitor()){

                        public Javadoc visitLineBreak(Javadoc.LineBreak lineBreak, Integer integer) {
                            return lineBreak.withMargin(NormalizeTabsOrSpacesVisitor.this.normalize(lineBreak.getMargin(), true));
                        }
                    }.visitNonNull((Tree)((Javadoc)c), (Object)0);
                }
                TextComment textComment = (TextComment)c;
                if (textComment.getText().contains("\t")) {
                    c = textComment.withText(this.normalize(textComment.getText(), true));
                }
            }
            return c.withSuffix(this.normalizeAfterFirstNewline(c.getSuffix()));
        }));
    }

    @NonNull
    private String normalizeAfterFirstNewline(String text) {
        int firstNewline = text.indexOf(10);
        if (firstNewline >= 0 && firstNewline != text.length() - 1) {
            return text.substring(0, firstNewline + 1) + this.normalize(text.substring(firstNewline + 1), false);
        }
        return text;
    }

    private String normalize(String text, boolean isComment) {
        if (!StringUtils.isNullOrEmpty((String)text) && (this.style.getUseTabCharacter() != false ? text.contains(" ") : text.contains("\t"))) {
            StringBuilder textBuilder = new StringBuilder();
            int consecutiveSpaces = 0;
            boolean inMargin = true;
            char[] charArray = text.toCharArray();
            block0: for (int i = 0; i < charArray.length; ++i) {
                int j;
                char c = charArray[i];
                if (c == '\n' || c == '\r') {
                    inMargin = true;
                    consecutiveSpaces = 0;
                    textBuilder.append(c);
                    continue;
                }
                if (!inMargin) {
                    textBuilder.append(c);
                    continue;
                }
                if (this.style.getUseTabCharacter().booleanValue() && c == ' ' && (!isComment || i + 1 < charArray.length && charArray[i + 1] != '*')) {
                    for (j = i + 1; j < charArray.length && j < this.style.getTabSize(); ++j) {
                        if (charArray[j] != ' ') continue block0;
                    }
                    i = j + 1;
                    textBuilder.append('\t');
                    continue;
                }
                if (!this.style.getUseTabCharacter().booleanValue() && c == '\t') {
                    for (j = 0; j < this.style.getTabSize() - consecutiveSpaces % this.style.getTabSize(); ++j) {
                        textBuilder.append(' ');
                    }
                    consecutiveSpaces = 0;
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    ++consecutiveSpaces;
                    textBuilder.append(c);
                    continue;
                }
                inMargin = false;
                textBuilder.append(c);
            }
            return textBuilder.toString();
        }
        return text;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

