/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;
import org.openrewrite.xml.tree.Xml;
import org.opentest4j.AssertionFailedError;

public class Assertions {
    private Assertions() {
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
        boolean nothingConfigured;
        MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
        boolean bl = nothingConfigured = mctx.getSettings() == null && mctx.getLocalRepository().equals(MavenRepository.MAVEN_LOCAL_DEFAULT) && mctx.getRepositories().isEmpty() && mctx.getActiveProfiles().isEmpty() && mctx.getMirrors().isEmpty();
        if (nothingConfigured) {
            mctx.setMavenSettings(MavenSettings.readMavenSettingsFromDisk((ExecutionContext)mctx), new String[0]);
        }
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before) {
        return Assertions.pomXml(before, (SourceSpec<Xml.Document> s) -> {});
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before, Consumer<SourceSpec<Xml.Document>> spec) {
        SourceSpec maven = new SourceSpec(Xml.Document.class, "maven", (Parser.Builder)MavenParser.builder(), before, Assertions::pomResolvedSuccessfully, Assertions::customizeExecutionContext);
        maven.path("pom.xml");
        spec.accept((SourceSpec<Xml.Document>)maven);
        return maven;
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before, @Language(value="xml") @Nullable String after) {
        return Assertions.pomXml(before, after, s -> {});
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before, @Language(value="xml") @Nullable String after, Consumer<SourceSpec<Xml.Document>> spec) {
        SourceSpec maven = new SourceSpec(Xml.Document.class, "maven", (Parser.Builder)MavenParser.builder(), before, Assertions::pomResolvedSuccessfully, Assertions::customizeExecutionContext).after(s -> after);
        maven.path("pom.xml");
        spec.accept((SourceSpec<Xml.Document>)maven);
        return maven;
    }

    private static SourceFile pomResolvedSuccessfully(SourceFile sourceFile, TypeValidation typeValidation) {
        if (typeValidation.dependencyModel()) {
            sourceFile.getMarkers().findFirst(ParseExceptionResult.class).ifPresent(parseExceptionResult -> org.junit.jupiter.api.Assertions.fail((String)("Problem parsing " + sourceFile.getSourcePath() + ":\n" + parseExceptionResult.getMessage())));
            sourceFile.getMarkers().findFirst(MavenResolutionResult.class).orElseThrow(() -> new AssertionFailedError("No MavenResolutionResult found on " + sourceFile.getSourcePath()));
        }
        return sourceFile;
    }

    public static void withLocalRepository(@Language(value="xml") String[] pomXmls, Runnable testCode) {
        if (pomXmls.length == 0) {
            throw new IllegalArgumentException("At least one POM must be provided");
        }
        HashSet<String> protectedGroupIds = new HashSet<String>(Arrays.asList("org.springframework", "org.springframework.boot", "org.apache", "org.apache.maven", "org.junit", "com.google", "com.fasterxml", "jakarta", "javax", "io.quarkus", "org.eclipse", "org.jetbrains"));
        ArrayList<Path> publishedFiles = new ArrayList<Path>();
        try {
            Path localRepo = Paths.get(System.getProperty("user.home"), ".m2", "repository");
            for (String pomXml : pomXmls) {
                RawPom rawPom = RawPom.parse(new ByteArrayInputStream(pomXml.getBytes(StandardCharsets.UTF_8)), null);
                Pom pom = rawPom.toPom(Paths.get("pom.xml", new String[0]), null);
                String groupId = pom.getGroupId();
                String artifactId = pom.getArtifactId();
                String version = pom.getVersion();
                if (groupId == null || groupId.trim().isEmpty()) {
                    throw new IllegalArgumentException("POM XML must contain a groupId");
                }
                if (artifactId == null || artifactId.trim().isEmpty()) {
                    throw new IllegalArgumentException("POM XML must contain an artifactId");
                }
                if (version == null || version.trim().isEmpty()) {
                    throw new IllegalArgumentException("POM XML must contain a version");
                }
                for (String protectedPrefix : protectedGroupIds) {
                    if (!groupId.startsWith(protectedPrefix)) continue;
                    throw new IllegalArgumentException("Cannot use withLocalRepository with well-known groupId: " + groupId + ". Please use test-specific coordinates like 'com.example.test' to avoid overwriting real POMs.");
                }
                String[] groupParts = groupId.split("\\.");
                Path pomDir = localRepo;
                for (String part : groupParts) {
                    pomDir = pomDir.resolve(part);
                }
                pomDir = pomDir.resolve(artifactId).resolve(version);
                Files.createDirectories(pomDir, new FileAttribute[0]);
                Path pomFile = pomDir.resolve(artifactId + "-" + version + ".pom");
                Files.write(pomFile, pomXml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                publishedFiles.add(pomFile);
            }
            testCode.run();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to publish POM to local repository", e);
            }
            catch (Throwable throwable) {
                for (Path file : publishedFiles) {
                    try {
                        Files.deleteIfExists(file);
                        for (Path parent = file.getParent(); parent != null && !parent.equals(Paths.get(System.getProperty("user.home"), ".m2", "repository")); parent = parent.getParent()) {
                            try {
                                Files.deleteIfExists(parent);
                                continue;
                            }
                            catch (IOException ignored) {
                            }
                        }
                    }
                    catch (IOException e2) {
                        System.err.println("Warning: Failed to clean up test POM: " + file + " - " + e2.getMessage());
                    }
                }
                throw throwable;
            }
        }
        for (Path file : publishedFiles) {
            try {
                Files.deleteIfExists(file);
                for (Path parent = file.getParent(); parent != null && !parent.equals(Paths.get(System.getProperty("user.home"), ".m2", "repository")); parent = parent.getParent()) {
                    try {
                        Files.deleteIfExists(parent);
                        continue;
                    }
                    catch (IOException ignored) {
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Warning: Failed to clean up test POM: " + file + " - " + e.getMessage());
            }
        }
    }

    public static void withLocalRepository(@Language(value="xml") String pomXml, Runnable testCode) {
        Assertions.withLocalRepository(new String[]{pomXml}, testCode);
    }

    public static void withLocalRepository(@Language(value="xml") String pomXml1, @Language(value="xml") String pomXml2, Runnable testCode) {
        Assertions.withLocalRepository(new String[]{pomXml1, pomXml2}, testCode);
    }
}

