/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpdateScmFromGitOrigin
extends Recipe {
    @Option(displayName="Add if missing", description="If set to `true`, the recipe will add a `<scm>` section if it is missing. If set to `false` (default), the recipe will only update existing `<scm>` sections.", required=false)
    private final @Nullable Boolean addIfMissing;

    public String getDisplayName() {
        return "Update SCM with Git origin";
    }

    public String getDescription() {
        return "Updates or adds the Maven `<scm>` tag based on the Git remote origin. By default, only existing Source Control Management (SCM) sections are updated. Set `addIfMissing` to `true` to also add missing SCM sections.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){
            GitOrigin gitOrigin;

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                Optional<GitOrigin> maybeOrigin = document.getMarkers().findFirst(GitProvenance.class).map(GitProvenance::getOrigin).map(GitOrigin::parseGitUrl);
                if (!maybeOrigin.isPresent()) {
                    return document;
                }
                this.gitOrigin = maybeOrigin.get();
                if (!document.getRoot().getChild("scm").isPresent()) {
                    if (Boolean.TRUE.equals(UpdateScmFromGitOrigin.this.addIfMissing)) {
                        String httpUrl = "https://" + this.gitOrigin.getHost() + "/" + this.gitOrigin.getPath();
                        String gitPath = this.gitOrigin.getPath().endsWith(".git") ? this.gitOrigin.getPath().substring(0, this.gitOrigin.getPath().length() - 4) : this.gitOrigin.getPath();
                        String scmContent = "<scm>\n  <url>" + httpUrl + "</url>\n  <connection>scm:git:" + httpUrl + (httpUrl.endsWith(".git") ? "" : ".git") + "</connection>\n  <developerConnection>scm:git:git@" + this.gitOrigin.getHost() + ":" + gitPath + ".git</developerConnection>\n</scm>";
                        document = (Xml.Document)new AddToTagVisitor(document.getRoot(), Xml.Tag.build((String)scmContent), (Comparator)new MavenTagInsertionComparator(document.getRoot().getChildren())).visitNonNull((Tree)document, (Object)ctx, Objects.requireNonNull(this.getCursor().getParent()));
                    }
                    return document;
                }
                return super.visitDocument(document, (Object)ctx);
            }

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if ("project".equals(tag.getName())) {
                    return super.visitTag(tag, (Object)ctx);
                }
                if ("scm".equals(tag.getName())) {
                    tag = this.updateScmTag(tag, "url", ctx);
                    tag = this.updateScmTag(tag, "connection", ctx);
                    tag = this.updateScmTag(tag, "developerConnection", ctx);
                }
                return tag;
            }

            private Xml.Tag updateScmTag(Xml.Tag tag, String tagName, ExecutionContext ctx) {
                String updatedUrl;
                Xml.Tag childTag;
                String originalUrl;
                Optional maybeChild = tag.getChild(tagName);
                if (maybeChild.isPresent() && !(originalUrl = (childTag = (Xml.Tag)maybeChild.get()).getValue().orElse("")).equals(updatedUrl = this.gitOrigin.replaceHostAndPath(originalUrl))) {
                    tag = (Xml.Tag)new ChangeTagValueVisitor(childTag, updatedUrl).visitNonNull((Tree)tag, (Object)ctx, this.getCursor().getParentTreeCursor());
                }
                return tag;
            }
        };
    }

    @Generated
    public UpdateScmFromGitOrigin(@Nullable Boolean addIfMissing) {
        this.addIfMissing = addIfMissing;
    }

    @Generated
    public @Nullable Boolean getAddIfMissing() {
        return this.addIfMissing;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateScmFromGitOrigin(addIfMissing=" + this.getAddIfMissing() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateScmFromGitOrigin)) {
            return false;
        }
        UpdateScmFromGitOrigin other = (UpdateScmFromGitOrigin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addIfMissing = this.getAddIfMissing();
        Boolean other$addIfMissing = other.getAddIfMissing();
        return !(this$addIfMissing == null ? other$addIfMissing != null : !((Object)this$addIfMissing).equals(other$addIfMissing));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpdateScmFromGitOrigin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addIfMissing = this.getAddIfMissing();
        result = result * 59 + ($addIfMissing == null ? 43 : ((Object)$addIfMissing).hashCode());
        return result;
    }

    static final class GitOrigin {
        private static final Pattern[] URL_PATTERNS = new Pattern[]{Pattern.compile("^git@([^:]+):(.+?)(?:\\.git)?$"), Pattern.compile("^https?://(?:[^@]+@)?([^/:]+(?::[0-9]+)?)/(.+?)(?:\\.git)?$"), Pattern.compile("^ssh://git@([^/:]+(?::[0-9]+)?)/(.+?)(?:\\.git)?$"), Pattern.compile("^[a-zA-Z][a-zA-Z0-9+.-]*://(?:[^@]+@)?([^/:]+(?::[0-9]+)?)/(.+?)(?:\\.git)?$")};
        private final String host;
        private final String path;

        static @Nullable GitOrigin parseGitUrl(String gitUrl) {
            if (!StringUtils.isNullOrEmpty((String)gitUrl)) {
                for (Pattern pattern : URL_PATTERNS) {
                    Matcher matcher = pattern.matcher(gitUrl);
                    if (!matcher.matches()) continue;
                    return new GitOrigin(matcher.group(1), matcher.group(2));
                }
            }
            return null;
        }

        String replaceHostAndPath(String originalUrl) {
            Matcher protocolMatcher;
            if (StringUtils.isNullOrEmpty((String)originalUrl)) {
                return originalUrl;
            }
            if (originalUrl.startsWith("scm:git:")) {
                String actualUrl = originalUrl.substring("scm:git:".length());
                return "scm:git:" + this.replaceHostAndPath(actualUrl);
            }
            if (originalUrl.startsWith("git@")) {
                String expectedPrefix = "git@" + this.host + ":" + this.path;
                if (originalUrl.startsWith(expectedPrefix)) {
                    return originalUrl;
                }
                Matcher gitMatcher = Pattern.compile("^git@[^:]+:(.+?)$").matcher(originalUrl);
                if (gitMatcher.matches()) {
                    String originalFullPath = gitMatcher.group(1);
                    boolean hasGitExtension = originalFullPath.endsWith(".git");
                    String newUrl = "git@" + this.host + ":" + this.path;
                    if (hasGitExtension && !this.path.endsWith(".git")) {
                        newUrl = newUrl + ".git";
                    }
                    return newUrl;
                }
            }
            if ((protocolMatcher = Pattern.compile("^([a-zA-Z][a-zA-Z0-9+.-]*://)(?:([^@/]+)@)?([^/]+)(/[^?#]*)?(.*)?$").matcher(originalUrl)).find()) {
                String protocol = protocolMatcher.group(1);
                String user = protocolMatcher.group(2);
                String originalHost = protocolMatcher.group(3);
                String originalPath = protocolMatcher.group(4);
                String suffix = protocolMatcher.group(5) != null ? protocolMatcher.group(5) : "";
                String userPrefix = user != null ? user + "@" : "";
                boolean needsGitExtension = originalPath != null && originalPath.endsWith(".git") && !this.path.endsWith(".git");
                String newPath = "/" + this.path + (needsGitExtension ? ".git" : "");
                String newBaseUrl = protocol + userPrefix + this.host + newPath;
                if (originalUrl.startsWith(newBaseUrl)) {
                    return originalUrl;
                }
                return newBaseUrl + suffix;
            }
            return originalUrl;
        }

        @Generated
        public GitOrigin(String host, String path) {
            this.host = host;
            this.path = path;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GitOrigin)) {
                return false;
            }
            GitOrigin other = (GitOrigin)o;
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpdateScmFromGitOrigin.GitOrigin(host=" + this.getHost() + ", path=" + this.getPath() + ")";
        }
    }
}

