/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class ManagedToRuntimeDependencies
extends Recipe {
    public String getDisplayName() {
        return "Convert managed dependencies to runtime dependencies";
    }

    public String getDescription() {
        return "This recipe processes Maven POMs, converting all `<dependencyManagement>` entries into runtime scoped `<dependencies>` entries. Import scoped BOMs (like jackson-bom) are left unmodified in `<dependencyManagement>`. Some style guidelines prefer that `<dependencyManagement>` be used only for BOMs. This maintain that style while avoiding introducing new symbols onto the compile classpath unintentionally.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                final ArrayList managedDepsToConvert = new ArrayList();
                Xml.Document doc = (Xml.Document)new MavenIsoVisitor<ExecutionContext>(){

                    @Override
                    public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                        String scope;
                        if (this.isManagedDependencyTag() && !"import".equals(scope = (String)tag.getChildValue("scope").orElse(null))) {
                            managedDepsToConvert.add(tag);
                            return null;
                        }
                        return super.visitTag(tag, ctx);
                    }
                }.visitNonNull((Tree)document, ctx);
                if (managedDepsToConvert.isEmpty()) {
                    return doc;
                }
                this.doAfterVisit((TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){

                    @Override
                    public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                        block4: {
                            if (!"project".equals(tag.getName())) break block4;
                            Xml.Tag dependencies = tag.getChild("dependencies").orElse(null);
                            if (dependencies == null) {
                                Xml.Tag dependencyManagement = tag.getChild("dependencyManagement").orElse(null);
                                String indentToUse = dependencyManagement != null ? dependencyManagement.getPrefix() : "\n    ";
                                Xml.Tag newDependencies = Xml.Tag.build((String)"<dependencies/>").withPrefix(indentToUse);
                                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, newDependencies, (Comparator)new MavenTagInsertionComparator(tag.getContent())));
                                for (Xml.Tag depToConvert : managedDepsToConvert) {
                                    Xml.Tag convertedDep = this.createRuntimeDependency(depToConvert);
                                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor(newDependencies, convertedDep));
                                }
                            } else {
                                for (Xml.Tag depToConvert : managedDepsToConvert) {
                                    Xml.Tag convertedDep = this.createRuntimeDependency(depToConvert);
                                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor(dependencies, convertedDep));
                                }
                            }
                        }
                        return super.visitTag(tag, ctx);
                    }
                });
                this.maybeUpdateModel();
                return doc;
            }

            private Xml.Tag createRuntimeDependency(Xml.Tag managedDep) {
                String currentScope = managedDep.getChildValue("scope").orElse(null);
                String targetScope = this.mapScope(currentScope);
                if (currentScope == null) {
                    Xml.Tag scopeTag = Xml.Tag.build((String)("<scope>" + targetScope + "</scope>")).withPrefix("\n        ");
                    return managedDep.withContent(this.addScopeToContent(managedDep.getContent(), scopeTag));
                }
                if (!currentScope.equals(targetScope)) {
                    return managedDep.withContent(this.replaceScopeInContent(managedDep.getContent(), targetScope));
                }
                return managedDep;
            }

            private String mapScope(@Nullable String scope) {
                if (scope == null || "compile".equals(scope) || "runtime".equals(scope)) {
                    return "runtime";
                }
                if ("test".equals(scope)) {
                    return "test";
                }
                if ("provided".equals(scope)) {
                    return "provided";
                }
                return scope;
            }

            private List<Content> addScopeToContent(@Nullable List<? extends Content> content, Xml.Tag scopeTag) {
                if (content == null) {
                    return Collections.emptyList();
                }
                boolean scopeAdded = false;
                String[] precedingElements = new String[]{"optional", "classifier", "type", "version", "artifactId", "groupId"};
                ArrayList<Content> newContent = new ArrayList<Content>(content);
                for (String element : precedingElements) {
                    for (int i = 0; i < newContent.size(); ++i) {
                        int insertPos;
                        Content item = (Content)newContent.get(i);
                        if (!(item instanceof Xml.Tag) || !element.equals(((Xml.Tag)item).getName())) continue;
                        for (insertPos = i + 1; insertPos < newContent.size() && !(newContent.get(insertPos) instanceof Xml.Tag); ++insertPos) {
                        }
                        newContent.add(insertPos, (Content)scopeTag);
                        scopeAdded = true;
                        break;
                    }
                    if (scopeAdded) break;
                }
                if (!scopeAdded) {
                    for (int i = 0; i < newContent.size(); ++i) {
                        Content item = (Content)newContent.get(i);
                        if (!(item instanceof Xml.Tag) || !"exclusions".equals(((Xml.Tag)item).getName())) continue;
                        newContent.add(i, (Content)scopeTag);
                        scopeAdded = true;
                        break;
                    }
                    if (!scopeAdded) {
                        newContent.add((Content)scopeTag);
                    }
                }
                return newContent;
            }

            private List<Content> replaceScopeInContent(@Nullable List<? extends Content> content, String targetScope) {
                if (content == null) {
                    return Collections.emptyList();
                }
                ArrayList<Content> newContent = new ArrayList<Content>();
                for (Content content2 : content) {
                    if (content2 instanceof Xml.Tag && "scope".equals(((Xml.Tag)content2).getName())) {
                        Xml.Tag scopeTag = (Xml.Tag)content2;
                        newContent.add((Content)scopeTag.withValue(targetScope));
                        continue;
                    }
                    newContent.add(content2);
                }
                return newContent;
            }
        };
    }

    @Generated
    public ManagedToRuntimeDependencies() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "ManagedToRuntimeDependencies()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManagedToRuntimeDependencies)) {
            return false;
        }
        ManagedToRuntimeDependencies other = (ManagedToRuntimeDependencies)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ManagedToRuntimeDependencies;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

