/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.table;

import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class XmlStyleReport
extends DataTable<Row> {
    public XmlStyleReport(Recipe recipe) {
        super(recipe, "XML style report", "Records style information about XML documents. Used for debugging style auto-detection issues.");
    }

    public static final class Row {
        @Column(displayName="File name", description="The name of the file that was analyzed.")
        private final String name;
        @Column(displayName="Use tabs", description="When 'true', tabs are used for indentation. When 'false', spaces are used.")
        private final boolean useTabCharacter;
        @Column(displayName="Indent size", description="The number of spaces that are used for each level of indentation.")
        private final int indentSize;
        @Column(displayName="Tab size", description="The number of spaces that a tab character represents.")
        private final int tabSize;
        @Column(displayName="Continuation indent size", description="The number of spaces that are used to indent an attribute that is on its own line.")
        private final int continuationIndentSize;
        @Column(displayName="Indent count", description="Count of tags in the file whose prefixes were evaluated.")
        private final int indentCount;
        @Column(displayName="Indents matching own style", description="Count of tags in the file whose prefix match the style of the file itself.")
        private final int indentsMatchingOwnStyle;
        @Column(displayName="Indents matching project style", description="Count of tags in the file whose prefix match the overall style of the project.")
        private final int indentsMatchingProjectStyle;
        @Column(displayName="Continuation indent count", description="Count of attributes in the file whose prefixes were evaluated.")
        private final int continuationIndentCount;
        @Column(displayName="Continuation indents matching own style", description="CCount of attributes in the file whose prefix matches  the style of the file itself.")
        private final int continuationIndentsMatchingOwnStyle;
        @Column(displayName="Continuation indents matching project style", description="Count of attributes in the file whose prefix matches the overall style of the project.")
        private final int continuationIndentsMatchingProjectStyle;

        @Generated
        public Row(String name, boolean useTabCharacter, int indentSize, int tabSize, int continuationIndentSize, int indentCount, int indentsMatchingOwnStyle, int indentsMatchingProjectStyle, int continuationIndentCount, int continuationIndentsMatchingOwnStyle, int continuationIndentsMatchingProjectStyle) {
            this.name = name;
            this.useTabCharacter = useTabCharacter;
            this.indentSize = indentSize;
            this.tabSize = tabSize;
            this.continuationIndentSize = continuationIndentSize;
            this.indentCount = indentCount;
            this.indentsMatchingOwnStyle = indentsMatchingOwnStyle;
            this.indentsMatchingProjectStyle = indentsMatchingProjectStyle;
            this.continuationIndentCount = continuationIndentCount;
            this.continuationIndentsMatchingOwnStyle = continuationIndentsMatchingOwnStyle;
            this.continuationIndentsMatchingProjectStyle = continuationIndentsMatchingProjectStyle;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean isUseTabCharacter() {
            return this.useTabCharacter;
        }

        @Generated
        public int getIndentSize() {
            return this.indentSize;
        }

        @Generated
        public int getTabSize() {
            return this.tabSize;
        }

        @Generated
        public int getContinuationIndentSize() {
            return this.continuationIndentSize;
        }

        @Generated
        public int getIndentCount() {
            return this.indentCount;
        }

        @Generated
        public int getIndentsMatchingOwnStyle() {
            return this.indentsMatchingOwnStyle;
        }

        @Generated
        public int getIndentsMatchingProjectStyle() {
            return this.indentsMatchingProjectStyle;
        }

        @Generated
        public int getContinuationIndentCount() {
            return this.continuationIndentCount;
        }

        @Generated
        public int getContinuationIndentsMatchingOwnStyle() {
            return this.continuationIndentsMatchingOwnStyle;
        }

        @Generated
        public int getContinuationIndentsMatchingProjectStyle() {
            return this.continuationIndentsMatchingProjectStyle;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.isUseTabCharacter() != other.isUseTabCharacter()) {
                return false;
            }
            if (this.getIndentSize() != other.getIndentSize()) {
                return false;
            }
            if (this.getTabSize() != other.getTabSize()) {
                return false;
            }
            if (this.getContinuationIndentSize() != other.getContinuationIndentSize()) {
                return false;
            }
            if (this.getIndentCount() != other.getIndentCount()) {
                return false;
            }
            if (this.getIndentsMatchingOwnStyle() != other.getIndentsMatchingOwnStyle()) {
                return false;
            }
            if (this.getIndentsMatchingProjectStyle() != other.getIndentsMatchingProjectStyle()) {
                return false;
            }
            if (this.getContinuationIndentCount() != other.getContinuationIndentCount()) {
                return false;
            }
            if (this.getContinuationIndentsMatchingOwnStyle() != other.getContinuationIndentsMatchingOwnStyle()) {
                return false;
            }
            if (this.getContinuationIndentsMatchingProjectStyle() != other.getContinuationIndentsMatchingProjectStyle()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUseTabCharacter() ? 79 : 97);
            result = result * 59 + this.getIndentSize();
            result = result * 59 + this.getTabSize();
            result = result * 59 + this.getContinuationIndentSize();
            result = result * 59 + this.getIndentCount();
            result = result * 59 + this.getIndentsMatchingOwnStyle();
            result = result * 59 + this.getIndentsMatchingProjectStyle();
            result = result * 59 + this.getContinuationIndentCount();
            result = result * 59 + this.getContinuationIndentsMatchingOwnStyle();
            result = result * 59 + this.getContinuationIndentsMatchingProjectStyle();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "XmlStyleReport.Row(name=" + this.getName() + ", useTabCharacter=" + this.isUseTabCharacter() + ", indentSize=" + this.getIndentSize() + ", tabSize=" + this.getTabSize() + ", continuationIndentSize=" + this.getContinuationIndentSize() + ", indentCount=" + this.getIndentCount() + ", indentsMatchingOwnStyle=" + this.getIndentsMatchingOwnStyle() + ", indentsMatchingProjectStyle=" + this.getIndentsMatchingProjectStyle() + ", continuationIndentCount=" + this.getContinuationIndentCount() + ", continuationIndentsMatchingOwnStyle=" + this.getContinuationIndentsMatchingOwnStyle() + ", continuationIndentsMatchingProjectStyle=" + this.getContinuationIndentsMatchingProjectStyle() + ")";
        }
    }
}

