/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.protein;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBioPolymer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.protein.data.PDBAtom;
import org.openscience.cdk.tools.GridGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class ProteinPocketFinder {
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(ProteinPocketFinder.class);
    int solvantValue = 0;
    int proteinInterior = -1;
    int pocketSize = 100;
    double rAtom = 1.5;
    double rSolvent = 1.4;
    double latticeConstant = 0.5;
    int minPSPocket = 2;
    int minPSCluster = 2;
    double linkageRadius = 1.0;
    double atomCheckRadius = 0.0;
    IBioPolymer protein = null;
    String vanDerWaalsFile = "org/openscience/cdk/config/data/pdb_atomtypes.xml";
    double[][][] grid = null;
    GridGenerator gridGenerator = new GridGenerator();
    Map<String, Integer> visited = new Hashtable<String, Integer>();
    List<List<Point3d>> pockets = new ArrayList<List<Point3d>>();

    public ProteinPocketFinder(String biopolymerFile, boolean cubicGrid) {
        this.readBioPolymer(biopolymerFile);
        if (cubicGrid) {
            this.createCubicGrid();
        }
    }

    public ProteinPocketFinder(String biopolymerFile, double latticeConstant, boolean cubicGrid) {
        this.readBioPolymer(biopolymerFile);
        this.latticeConstant = latticeConstant;
        this.gridGenerator.setLatticeConstant(this.latticeConstant);
        if (cubicGrid) {
            this.createCubicGrid();
        }
    }

    public ProteinPocketFinder(String biopolymerFile, double[][][] grid) {
        this.grid = grid;
        this.gridGenerator.setGrid(grid);
        this.readBioPolymer(biopolymerFile);
    }

    public ProteinPocketFinder(IBioPolymer protein, double[][][] grid) {
        this.protein = protein;
        this.grid = grid;
        this.gridGenerator.setGrid(grid);
    }

    private void readBioPolymer(String biopolymerFile) {
        try {
            FileReader fileReader = new FileReader(biopolymerFile);
            ISimpleChemObjectReader reader = new ReaderFactory().createReader((Reader)fileReader);
            IChemFile chemFile = (IChemFile)reader.read((IChemObject)new ChemFile());
            IChemSequence chemSequence = chemFile.getChemSequence(0);
            IChemModel chemModel = chemSequence.getChemModel(0);
            IAtomContainerSet setOfMolecules = chemModel.getMoleculeSet();
            this.protein = (IBioPolymer)setOfMolecules.getAtomContainer(0);
        }
        catch (IOException | CDKException exc) {
            this.logger.error((Object)("Could not read BioPolymer from file>" + biopolymerFile + " due to: " + exc.getMessage()));
            this.logger.debug((Object)exc);
        }
    }

    public double[] findGridBoundaries() {
        IAtom[] atoms = AtomContainerManipulator.getAtomArray((IAtomContainer)this.protein);
        double[] minMax = new double[]{atoms[0].getPoint3d().x, atoms[0].getPoint3d().x, atoms[0].getPoint3d().y, atoms[0].getPoint3d().y, atoms[0].getPoint3d().z, atoms[0].getPoint3d().z};
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i].getPoint3d().x > minMax[1]) {
                minMax[1] = atoms[i].getPoint3d().x;
                continue;
            }
            if (atoms[i].getPoint3d().y > minMax[3]) {
                minMax[3] = atoms[i].getPoint3d().y;
                continue;
            }
            if (atoms[i].getPoint3d().z > minMax[5]) {
                minMax[5] = atoms[i].getPoint3d().z;
                continue;
            }
            if (atoms[i].getPoint3d().x < minMax[0]) {
                minMax[0] = atoms[i].getPoint3d().x;
                continue;
            }
            if (atoms[i].getPoint3d().y < minMax[2]) {
                minMax[2] = atoms[i].getPoint3d().y;
                continue;
            }
            if (!(atoms[i].getPoint3d().z < minMax[4])) continue;
            minMax[4] = atoms[i].getPoint3d().z;
        }
        return minMax;
    }

    public void createCubicGrid() {
        this.gridGenerator.setDimension(this.findGridBoundaries(), true);
        this.gridGenerator.generateGrid();
        this.grid = this.gridGenerator.getGrid();
    }

    public void assignProteinToGrid() throws Exception {
        this.grid = this.gridGenerator.initializeGrid(this.grid, 0.0);
        IAtom[] atoms = AtomContainerManipulator.getAtomArray((IAtomContainer)this.protein);
        Point3d gridPoint = null;
        int checkGridPoints = 0;
        double vdWRadius = 0.0;
        int[] dim = this.gridGenerator.getDim();
        int[] minMax = new int[]{0, 0, 0, 0, 0, 0};
        for (int i = 0; i < atoms.length; ++i) {
            if (((PDBAtom)atoms[i]).getHetAtom().booleanValue()) continue;
            gridPoint = this.gridGenerator.getGridPointFrom3dCoordinates(atoms[i].getPoint3d());
            this.grid[(int)gridPoint.x][(int)gridPoint.y][(int)gridPoint.z] = -1.0;
            vdWRadius = PeriodicTable.getVdwRadius((String)atoms[i].getSymbol());
            if (vdWRadius == 0.0) {
                vdWRadius = this.rAtom;
            }
            if ((checkGridPoints = (int)((vdWRadius + this.rSolvent) / this.gridGenerator.getLatticeConstant() - this.atomCheckRadius)) < 0) {
                checkGridPoints = 0;
            }
            minMax[0] = (int)gridPoint.x - checkGridPoints;
            minMax[1] = (int)gridPoint.x + checkGridPoints;
            minMax[2] = (int)gridPoint.y - checkGridPoints;
            minMax[3] = (int)gridPoint.y + checkGridPoints;
            minMax[4] = (int)gridPoint.z - checkGridPoints;
            minMax[5] = (int)gridPoint.z + checkGridPoints;
            minMax = this.checkBoundaries(minMax, dim);
            for (int x = minMax[0]; x <= minMax[1]; ++x) {
                for (int y = minMax[2]; y <= minMax[3]; ++y) {
                    for (int z = minMax[4]; z <= minMax[5]; ++z) {
                        this.grid[x][y][z] = this.grid[x][y][z] - 1.0;
                    }
                }
            }
        }
    }

    public void debuggCheckPSPEvent() {
        this.logger.debug((Object)"\tdebugg_checkPSPEvent");
        int[] dim = this.gridGenerator.getDim();
        int[] pspEvents = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        int proteinGrid = 0;
        for (int x = 0; x <= dim[0]; ++x) {
            for (int y = 0; y <= dim[1]; ++y) {
                for (int z = 0; z <= dim[2]; ++z) {
                    if (this.grid[x][y][z] == 0.0) {
                        pspEvents[0] = pspEvents[0] + 1;
                    } else if (this.grid[x][y][z] == 1.0) {
                        pspEvents[1] = pspEvents[1] + 1;
                    } else if (this.grid[x][y][z] == 2.0) {
                        pspEvents[2] = pspEvents[2] + 1;
                    } else if (this.grid[x][y][z] == 3.0) {
                        pspEvents[3] = pspEvents[3] + 1;
                    } else if (this.grid[x][y][z] == 4.0) {
                        pspEvents[4] = pspEvents[4] + 1;
                    } else if (this.grid[x][y][z] == 5.0) {
                        pspEvents[5] = pspEvents[5] + 1;
                    } else if (this.grid[x][y][z] == 6.0) {
                        pspEvents[6] = pspEvents[6] + 1;
                    } else if (this.grid[x][y][z] == 7.0) {
                        pspEvents[7] = pspEvents[7] + 1;
                    } else if (this.grid[x][y][z] >= 7.0) {
                        pspEvents[8] = pspEvents[8] + 1;
                    }
                    if (!(this.grid[x][y][z] < 0.0)) continue;
                    ++proteinGrid;
                }
            }
        }
        System.out.print("  minPSPocket:" + this.minPSPocket + " proteinGridPoints:" + proteinGrid);
        int sum = 0;
        for (int i = 0; i < pspEvents.length; ++i) {
            if (i >= this.minPSPocket) {
                sum += pspEvents[i];
            }
            this.logger.debug((Object)(" " + i + ":" + pspEvents[i]));
        }
        this.logger.debug((Object)(" pspAll>" + sum));
    }

    public void sitefinder() {
        try {
            this.assignProteinToGrid();
        }
        catch (Exception ex1) {
            this.logger.error((Object)("Problems with assignProteinToGrid due to:" + ex1.toString()));
        }
        int[] dim = this.gridGenerator.getDim();
        this.axisScanX(dim[2], dim[1], dim[0]);
        this.axisScanY(dim[2], dim[0], dim[1]);
        this.axisScanZ(dim[0], dim[1], dim[2]);
        this.diagonalAxisScanXZY(dim[0], dim[2], dim[1]);
        this.diagonalAxisScanYZX(dim[1], dim[2], dim[0]);
        this.diagonalAxisScanYXZ(dim[1], dim[0], dim[2]);
        this.diagonalAxisScanXYZ(dim[0], dim[1], dim[2]);
        this.findPockets();
        this.sortPockets();
    }

    private void sortPockets() {
        Hashtable<Integer, List> hashPockets = new Hashtable<Integer, List>();
        ArrayList<List<Point3d>> sortPockets = new ArrayList<List<Point3d>>(this.pockets.size());
        for (int i = 0; i < this.pockets.size(); ++i) {
            List<Point3d> pocket = this.pockets.get(i);
            if (hashPockets.containsKey(pocket.size())) {
                List tmp = (List)hashPockets.get(pocket.size());
                tmp.add(i);
                hashPockets.put(pocket.size(), tmp);
                continue;
            }
            ArrayList<Integer> value = new ArrayList<Integer>();
            value.add(i);
            hashPockets.put(pocket.size(), value);
        }
        ArrayList keys = new ArrayList(hashPockets.keySet());
        Collections.sort(keys);
        for (int i = keys.size() - 1; i >= 0; --i) {
            List value = (List)hashPockets.get(keys.get(i));
            for (int j = 0; j < value.size(); ++j) {
                sortPockets.add(this.pockets.get((Integer)value.get(j)));
            }
        }
        this.pockets = sortPockets;
    }

    private void findPockets() {
        int[] dim = this.gridGenerator.getDim();
        for (int x = 0; x < dim[0]; ++x) {
            for (int y = 0; y < dim[1]; ++y) {
                for (int z = 0; z < dim[2]; ++z) {
                    Point3d start = new Point3d((double)x, (double)y, (double)z);
                    if (!(this.grid[x][y][z] >= (double)this.minPSPocket & !this.visited.containsKey(x + "." + y + "." + z))) continue;
                    List<Point3d> subPocket = new ArrayList<Point3d>();
                    if ((subPocket = this.clusterPSPPocket(start, subPocket, dim)) == null || subPocket.size() < this.pocketSize) continue;
                    this.pockets.add(subPocket);
                }
            }
        }
    }

    public List<Point3d> clusterPSPPocket(Point3d root, List<Point3d> subPocket, int[] dim) {
        this.visited.put((int)root.x + "." + (int)root.y + "." + (int)root.z, 1);
        int[] minMax = new int[]{0, 0, 0, 0, 0, 0};
        minMax[0] = (int)(root.x - this.linkageRadius);
        minMax[1] = (int)(root.x + this.linkageRadius);
        minMax[2] = (int)(root.y - this.linkageRadius);
        minMax[3] = (int)(root.y + this.linkageRadius);
        minMax[4] = (int)(root.z - this.linkageRadius);
        minMax[5] = (int)(root.z + this.linkageRadius);
        minMax = this.checkBoundaries(minMax, dim);
        for (int k = minMax[0]; k <= minMax[1]; ++k) {
            for (int m = minMax[2]; m <= minMax[3]; ++m) {
                for (int l = minMax[4]; l <= minMax[5]; ++l) {
                    Point3d node = new Point3d((double)k, (double)m, (double)l);
                    if (!(this.grid[k][m][l] >= (double)this.minPSCluster) || this.visited.containsKey(k + "." + m + "." + l)) continue;
                    subPocket.add(node);
                    this.clusterPSPPocket(node, subPocket, dim);
                }
            }
        }
        subPocket.add(root);
        return subPocket;
    }

    private int[] checkBoundaries(int[] minMax, int[] dim) {
        if (minMax[0] < 0) {
            minMax[0] = 0;
        }
        if (minMax[1] > dim[0]) {
            minMax[1] = dim[0];
        }
        if (minMax[2] < 0) {
            minMax[2] = 0;
        }
        if (minMax[3] > dim[1]) {
            minMax[3] = dim[1];
        }
        if (minMax[4] < 0) {
            minMax[4] = 0;
        }
        if (minMax[5] > dim[2]) {
            minMax[5] = dim[2];
        }
        return minMax;
    }

    private void firePSPEvent(List<Point3d> line) {
        for (int i = 0; i < line.size(); ++i) {
            this.grid[(int)line.get((int)i).x][(int)line.get((int)i).y][(int)line.get((int)i).z] = this.grid[(int)line.get((int)i).x][(int)line.get((int)i).y][(int)line.get((int)i).z] + 1.0;
        }
    }

    public void diagonalAxisScanXZY(int dimK, int dimL, int dimM) {
        if (dimM < dimL) {
            dimL = dimM;
        }
        ArrayList<Point3d> line = new ArrayList<Point3d>();
        int pspEvent = 0;
        int m = 0;
        int j = dimM;
        while (j >= 1) {
            line.clear();
            pspEvent = 0;
            for (int k = 0; k <= dimK; ++k) {
                m = dimM;
                line.clear();
                pspEvent = 0;
                for (int l = dimL; l >= 0; --l) {
                    if (this.grid[k][m][l] < 0.0) {
                        if (pspEvent < 2) {
                            line.clear();
                            pspEvent = 1;
                        } else if (pspEvent == 2) {
                            this.firePSPEvent(line);
                            line.clear();
                            pspEvent = 1;
                        }
                    } else if (pspEvent == 1 | pspEvent == 2) {
                        line.add(new Point3d((double)k, (double)m, (double)l));
                        pspEvent = 2;
                    }
                    --m;
                }
            }
            dimL = j--;
        }
    }

    public void diagonalAxisScanYZX(int dimK, int dimL, int dimM) {
        if (dimM < dimL) {
            dimL = dimM;
        }
        ArrayList<Point3d> line = new ArrayList<Point3d>();
        int pspEvent = 0;
        int m = 0;
        int j = dimM;
        while (j >= 1) {
            line.clear();
            pspEvent = 0;
            for (int k = 0; k <= dimK; ++k) {
                m = dimM;
                line.clear();
                pspEvent = 0;
                for (int l = dimL; l >= 0; --l) {
                    if (this.grid[m][k][l] < 0.0) {
                        if (pspEvent < 2) {
                            line.clear();
                            pspEvent = 1;
                        } else if (pspEvent == 2) {
                            this.firePSPEvent(line);
                            line.clear();
                            pspEvent = 1;
                        }
                    } else if (pspEvent == 1 | pspEvent == 2) {
                        line.add(new Point3d((double)m, (double)k, (double)l));
                        pspEvent = 2;
                    }
                    --m;
                }
            }
            dimL = j--;
        }
    }

    public void diagonalAxisScanYXZ(int dimK, int dimL, int dimM) {
        if (dimM < dimL) {
            dimL = dimM;
        } else {
            dimM = dimL;
        }
        ArrayList<Point3d> line = new ArrayList<Point3d>();
        int pspEvent = 0;
        int l = 0;
        int j = dimL;
        while (j >= 1) {
            line.clear();
            pspEvent = 0;
            for (int k = 0; k <= dimK; ++k) {
                line.clear();
                pspEvent = 0;
                l = 0;
                for (int m = dimM; m >= 0; --m) {
                    if (this.grid[l][k][m] < 0.0) {
                        if (pspEvent < 2) {
                            line.clear();
                            pspEvent = 1;
                        } else if (pspEvent == 2) {
                            this.firePSPEvent(line);
                            line.clear();
                            pspEvent = 1;
                        }
                    } else if (pspEvent == 1 | pspEvent == 2) {
                        line.add(new Point3d((double)l, (double)k, (double)m));
                        pspEvent = 2;
                    }
                    ++l;
                }
            }
            dimM = j--;
        }
    }

    public void diagonalAxisScanXYZ(int dimK, int dimL, int dimM) {
        if (dimM < dimL) {
            dimL = dimM;
        } else {
            dimM = dimL;
        }
        ArrayList<Point3d> line = new ArrayList<Point3d>();
        int pspEvent = 0;
        int l = 0;
        int j = dimL;
        while (j >= 1) {
            line.clear();
            pspEvent = 0;
            for (int k = 0; k <= dimK; ++k) {
                line.clear();
                pspEvent = 0;
                l = 0;
                for (int m = dimM; m >= 0; --m) {
                    if (this.grid[k][l][m] < 0.0) {
                        if (pspEvent < 2) {
                            line.clear();
                            pspEvent = 1;
                        } else if (pspEvent == 2) {
                            this.firePSPEvent(line);
                            line.clear();
                            pspEvent = 1;
                        }
                    } else if (pspEvent == 1 | pspEvent == 2) {
                        line.add(new Point3d((double)k, (double)l, (double)m));
                        pspEvent = 2;
                    }
                    ++l;
                }
            }
            dimM = j--;
        }
    }

    public void axisScanX(int dimK, int dimL, int dimM) {
        ArrayList<Point3d> line = new ArrayList<Point3d>();
        int pspEvent = 0;
        for (int k = 0; k <= dimK; ++k) {
            line.clear();
            pspEvent = 0;
            for (int l = 0; l <= dimL; ++l) {
                line.clear();
                pspEvent = 0;
                for (int m = 0; m <= dimM; ++m) {
                    if (this.grid[m][l][k] < 0.0) {
                        if (pspEvent < 2) {
                            pspEvent = 1;
                            line.clear();
                            continue;
                        }
                        if (pspEvent != 2) continue;
                        this.firePSPEvent(line);
                        line.clear();
                        pspEvent = 1;
                        continue;
                    }
                    if (!(pspEvent == 1 | pspEvent == 2)) continue;
                    line.add(new Point3d((double)m, (double)l, (double)k));
                    pspEvent = 2;
                }
            }
        }
    }

    public void axisScanY(int dimK, int dimL, int dimM) {
        ArrayList<Point3d> line = new ArrayList<Point3d>();
        int pspEvent = 0;
        for (int k = 0; k <= dimK; ++k) {
            line.clear();
            pspEvent = 0;
            for (int l = 0; l <= dimL; ++l) {
                line.clear();
                pspEvent = 0;
                for (int m = 0; m <= dimM; ++m) {
                    if (this.grid[l][m][k] < 0.0) {
                        if (pspEvent < 2) {
                            pspEvent = 1;
                            line.clear();
                            continue;
                        }
                        if (pspEvent != 2) continue;
                        this.firePSPEvent(line);
                        line.clear();
                        pspEvent = 1;
                        continue;
                    }
                    if (pspEvent <= 0) continue;
                    line.add(new Point3d((double)l, (double)m, (double)k));
                    pspEvent = 2;
                }
            }
        }
    }

    public void axisScanZ(int dimK, int dimL, int dimM) {
        ArrayList<Point3d> line = new ArrayList<Point3d>();
        int pspEvent = 0;
        for (int k = 0; k <= dimK; ++k) {
            line.clear();
            pspEvent = 0;
            for (int l = 0; l <= dimL; ++l) {
                line.clear();
                pspEvent = 0;
                for (int m = 0; m <= dimM; ++m) {
                    if (this.grid[k][l][m] < 0.0) {
                        if (pspEvent < 2) {
                            pspEvent = 1;
                            line.clear();
                            continue;
                        }
                        if (pspEvent != 2) continue;
                        this.firePSPEvent(line);
                        line.clear();
                        pspEvent = 1;
                        continue;
                    }
                    if (pspEvent <= 0) continue;
                    line.add(new Point3d((double)k, (double)l, (double)m));
                    pspEvent = 2;
                }
            }
        }
    }

    public void assignVdWRadiiToProtein() {
        AtomTypeFactory atf = null;
        IAtom[] atoms = AtomContainerManipulator.getAtomArray((IAtomContainer)this.protein);
        try {
            atf = AtomTypeFactory.getInstance((String)this.vanDerWaalsFile, (IChemObjectBuilder)atoms[0].getBuilder());
        }
        catch (Exception ex1) {
            System.out.println("Problem with AtomTypeFactory due to:" + ex1.toString());
        }
        for (int i = 0; i < atoms.length; ++i) {
            try {
                atf.configure(atoms[i]);
                continue;
            }
            catch (Exception ex2) {
                this.logger.error((Object)("Problem with atf.configure due to:" + ex2.toString()));
            }
        }
    }

    public void gridToPmesh(String outPutFileName) {
        try {
            this.gridGenerator.writeGridInPmeshFormat(outPutFileName);
        }
        catch (IOException e) {
            this.logger.debug((Object)e);
        }
    }

    public void pspGridToPmesh(String outPutFileName) {
        try {
            this.gridGenerator.writeGridInPmeshFormat(outPutFileName, this.minPSPocket);
        }
        catch (IOException e) {
            this.logger.debug((Object)e);
        }
    }

    public void proteinGridToPmesh(String outPutFileName) {
        try {
            this.gridGenerator.writeGridInPmeshFormat(outPutFileName, -1.0);
        }
        catch (IOException e) {
            this.logger.debug((Object)e);
        }
    }

    public void writePocketsToPMesh(String outPutFileName) {
        try {
            for (int i = 0; i < this.pockets.size(); ++i) {
                BufferedWriter writer = new BufferedWriter(new FileWriter(outPutFileName + "-" + i + ".pmesh"));
                List<Point3d> pocket = this.pockets.get(i);
                writer.write(pocket.size() + "\n");
                for (int j = 0; j < pocket.size(); ++j) {
                    Point3d actualGridPoint = pocket.get(j);
                    Point3d coords = this.gridGenerator.getCoordinatesFromGridPoint(actualGridPoint);
                    writer.write(coords.x + "\t" + coords.y + "\t" + coords.z + "\n");
                }
                writer.close();
            }
        }
        catch (IOException e) {
            this.logger.debug((Object)e);
        }
    }

    public double[][][] getGrid() {
        return this.grid;
    }

    public void setGrid(double[][][] grid) {
        this.grid = grid;
    }

    public double getLatticeConstant() {
        return this.latticeConstant;
    }

    public void setLatticeConstant(double latticeConstant) {
        this.latticeConstant = latticeConstant;
    }

    public double getLinkageRadius() {
        return this.linkageRadius;
    }

    public void setLinkageRadius(double linkageRadius) {
        this.linkageRadius = linkageRadius;
    }

    public int getMinPSCluster() {
        return this.minPSCluster;
    }

    public void setMinPSCluster(int minPSCluster) {
        this.minPSCluster = minPSCluster;
    }

    public int getMinPSPocket() {
        return this.minPSPocket;
    }

    public void setMinPSPocket(int minPSPocket) {
        this.minPSPocket = minPSPocket;
    }

    public int getPocketSize() {
        return this.pocketSize;
    }

    public void setPocketSize(int pocketSize) {
        this.pocketSize = pocketSize;
    }

    public IBioPolymer getProtein() {
        return this.protein;
    }

    public void setProtein(IBioPolymer protein) {
        this.protein = protein;
    }

    public int getProteinInterior() {
        return this.proteinInterior;
    }

    public void setProteinInterior(int proteinInterior) {
        this.proteinInterior = proteinInterior;
    }

    public double getRAtom() {
        return this.rAtom;
    }

    public void setRAtom(double atom) {
        this.rAtom = atom;
    }

    public double getRSolvent() {
        return this.rSolvent;
    }

    public void setRSolvent(double solvent) {
        this.rSolvent = solvent;
    }

    public int getSolvantValue() {
        return this.solvantValue;
    }

    public void setSolvantValue(int solvantValue) {
        this.solvantValue = solvantValue;
    }

    public String getVanDerWaalsFile() {
        return this.vanDerWaalsFile;
    }

    public void setVanDerWaalsFile(String vanDerWaalsFile) {
        this.vanDerWaalsFile = vanDerWaalsFile;
    }

    public List<List<Point3d>> getPockets() {
        return this.pockets;
    }

    public void setAtomCheckRadius(double atomCheckRadius) {
        this.atomCheckRadius = atomCheckRadius;
    }
}

