/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import java.util.Iterator;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.AllRingsFinder;

@Deprecated
public class DoubleBondAcceptingAromaticityDetector {
    private static AtomTypeFactory factory = null;

    public static boolean detectAromaticity(IAtomContainer atomContainer) throws CDKException {
        SpanningTree spanningTree = new SpanningTree(atomContainer);
        IAtomContainer ringSystems = spanningTree.getCyclicFragmentsContainer();
        if (ringSystems.getAtomCount() == 0) {
            return false;
        }
        for (IAtom atom : ringSystems.atoms()) {
            if (DoubleBondAcceptingAromaticityDetector.atomIsPotentiallyAromatic(atom)) continue;
            ringSystems.removeAtom(atom);
        }
        Iterator atoms = ringSystems.atoms().iterator();
        while (atoms.hasNext()) {
            ((IAtom)atoms.next()).setFlag(2, true);
        }
        Iterator bonds = ringSystems.bonds().iterator();
        while (bonds.hasNext()) {
            ((IBond)bonds.next()).setFlag(2, true);
        }
        boolean foundSomeAromaticity = false;
        for (IAtomContainer isolatedSystem : ConnectivityChecker.partitionIntoMolecules((IAtomContainer)ringSystems).atomContainers()) {
            IRingSet singleRings = Cycles.sssr((IAtomContainer)isolatedSystem).toRingSet();
            Iterator singleRingsIterator = singleRings.atomContainers().iterator();
            int maxRingSize = 20;
            boolean allRingsAreAromatic = true;
            while (singleRingsIterator.hasNext()) {
                IAtomContainer singleRing = (IAtomContainer)singleRingsIterator.next();
                if (singleRing.getAtomCount() > maxRingSize) {
                    maxRingSize = singleRing.getAtomCount();
                }
                boolean ringIsAromatic = DoubleBondAcceptingAromaticityDetector.isHueckelValid(singleRing);
                foundSomeAromaticity |= ringIsAromatic;
                allRingsAreAromatic &= ringIsAromatic;
                if (!ringIsAromatic) continue;
                DoubleBondAcceptingAromaticityDetector.markRingAtomsAndBondsAromatic(singleRing);
            }
            if (allRingsAreAromatic || singleRings.getAtomContainerCount() > 3) continue;
            for (IAtomContainer ring : new AllRingsFinder().findAllRingsInIsolatedRingSystem(isolatedSystem).atomContainers()) {
                if (ring.getAtomCount() > maxRingSize) continue;
                boolean ringIsAromatic = DoubleBondAcceptingAromaticityDetector.isHueckelValid(ring);
                foundSomeAromaticity |= ringIsAromatic;
                if (!ringIsAromatic) continue;
                DoubleBondAcceptingAromaticityDetector.markRingAtomsAndBondsAromatic(ring);
            }
        }
        return foundSomeAromaticity;
    }

    private static boolean isHueckelValid(IAtomContainer singleRing) throws CDKException {
        int electronCount = 0;
        for (IAtom ringAtom : singleRing.atoms()) {
            if (ringAtom.getHybridization() != CDKConstants.UNSET && ringAtom.getHybridization() == IAtomType.Hybridization.SP2 || ringAtom.getHybridization() == IAtomType.Hybridization.PLANAR3) {
                IAtomType type;
                Object property;
                if ("N.planar3".equals(ringAtom.getAtomTypeName())) {
                    electronCount += 2;
                    continue;
                }
                if ("N.minus.planar3".equals(ringAtom.getAtomTypeName())) {
                    electronCount += 2;
                    continue;
                }
                if ("N.amide".equals(ringAtom.getAtomTypeName())) {
                    electronCount += 2;
                    continue;
                }
                if ("S.2".equals(ringAtom.getAtomTypeName())) {
                    electronCount += 2;
                    continue;
                }
                if ("S.planar3".equals(ringAtom.getAtomTypeName())) {
                    electronCount += 2;
                    continue;
                }
                if ("C.minus.planar".equals(ringAtom.getAtomTypeName())) {
                    electronCount += 2;
                    continue;
                }
                if ("O.planar3".equals(ringAtom.getAtomTypeName())) {
                    electronCount += 2;
                    continue;
                }
                if ("N.sp2.3".equals(ringAtom.getAtomTypeName())) {
                    ++electronCount;
                    continue;
                }
                if (factory == null) {
                    factory = AtomTypeFactory.getInstance((String)"org/openscience/cdk/dict/data/cdk-atom-types.owl", (IChemObjectBuilder)ringAtom.getBuilder());
                }
                if ((property = (type = factory.getAtomType(ringAtom.getAtomTypeName())).getProperty((Object)"cdk:Pi Bond Count")) == null || !(property instanceof Integer)) continue;
                electronCount += ((Integer)property).intValue();
                continue;
            }
            if (ringAtom.getHybridization() == null || ringAtom.getHybridization() != IAtomType.Hybridization.SP3 || DoubleBondAcceptingAromaticityDetector.getLonePairCount(ringAtom) <= 0) continue;
            electronCount += 2;
        }
        return electronCount % 4 == 2 && electronCount > 2;
    }

    private static boolean atomIsPotentiallyAromatic(IAtom atom) {
        if (atom.getHybridization() == IAtomType.Hybridization.SP2) {
            return true;
        }
        if (atom.getHybridization() == IAtomType.Hybridization.PLANAR3) {
            return true;
        }
        return atom.getHybridization() == IAtomType.Hybridization.SP3 && DoubleBondAcceptingAromaticityDetector.getLonePairCount(atom) > 0;
    }

    private static int getLonePairCount(IAtom atom) {
        Integer count = (Integer)atom.getProperty((Object)"cdk:Lone Pair Count");
        if (count == null) {
            return 0;
        }
        return count;
    }

    private static void markRingAtomsAndBondsAromatic(IAtomContainer container) {
        for (IAtom atom : container.atoms()) {
            atom.setFlag(32, true);
        }
        for (IBond bond : container.bonds()) {
            bond.setFlag(32, true);
        }
    }
}

