/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.indices;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.client.TimedRequest;
import org.opensearch.client.Validatable;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.unit.TimeValue;

public class GetIndexTemplatesRequest
implements Validatable {
    private final List<String> names;
    private TimeValue masterNodeTimeout = TimedRequest.DEFAULT_MASTER_NODE_TIMEOUT;
    private boolean local = false;

    public GetIndexTemplatesRequest(String ... names) {
        this(Arrays.asList(names));
    }

    public GetIndexTemplatesRequest(List<String> names) {
        Objects.requireNonNull(names);
        if (names.stream().anyMatch(name -> name == null || !Strings.hasText((String)name))) {
            throw new IllegalArgumentException("all index template names must be non null and non empty");
        }
        this.names = Collections.unmodifiableList(names);
    }

    public List<String> names() {
        return this.names;
    }

    public TimeValue getMasterNodeTimeout() {
        return this.masterNodeTimeout;
    }

    public void setMasterNodeTimeout(@Nullable TimeValue masterNodeTimeout) {
        this.masterNodeTimeout = masterNodeTimeout;
    }

    public void setMasterNodeTimeout(String masterNodeTimeout) {
        TimeValue timeValue = TimeValue.parseTimeValue((String)masterNodeTimeout, (String)(this.getClass().getSimpleName() + ".masterNodeTimeout"));
        this.setMasterNodeTimeout(timeValue);
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }
}

