/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */
package org.opensearch.common.crypto;

/**
 * Key pair generated by {@link MasterKeyProvider}
 */
public class DataKeyPair {
    private final byte[] rawKey;
    private final byte[] encryptedKey;

    /**
     * Constructor to initialize key-pair values
     * @param rawKey Unencrypted data key used for encryption and decryption
     * @param encryptedKey Encrypted version of rawKey
     */
    public DataKeyPair(byte[] rawKey, byte[] encryptedKey) {
        this.rawKey = rawKey;
        this.encryptedKey = encryptedKey;
    }

    /**
     * Returns raw key
     * @return raw/decrypted key
     */
    public byte[] getRawKey() {
        return rawKey;
    }

    /**
     * Returns encrypted key
     * @return encrypted key
     */
    public byte[] getEncryptedKey() {
        return encryptedKey;
    }
}
