/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import org.opensearch.action.ActionListener;
import org.opensearch.common.concurrent.CompletableContext;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpResponse;
import org.opensearch.transport.netty4.Netty4TcpChannel;

public class Netty4HttpChannel
implements HttpChannel {
    private final Channel channel;
    private final CompletableContext<Void> closeContext = new CompletableContext();

    Netty4HttpChannel(Channel channel) {
        this.channel = channel;
        Netty4TcpChannel.addListener(this.channel.closeFuture(), this.closeContext);
    }

    public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
        this.channel.writeAndFlush((Object)response, Netty4TcpChannel.addPromise(listener, this.channel));
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() {
        this.channel.close();
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    public String toString() {
        return "Netty4HttpChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.getRemoteAddress() + '}';
    }
}

