/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Info {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String PAX_WEB_VERSION;
    private static final String JETTY_VERSION;
    private static final String PAX_CDI_VERSION;
    private static boolean paxWebSnapshotVersion;
    private static boolean paxCdiSnapshotVersion;

    private Info() {
    }

    private static String readProperty(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new IllegalStateException(key + " missing in META-INF/pax-cdi-version.properties");
        }
        return value;
    }

    public static String getPaxCdiVersion() {
        return PAX_CDI_VERSION;
    }

    public static boolean isPaxCdiSnapshotVersion() {
        return paxCdiSnapshotVersion;
    }

    public static String getPaxWebVersion() {
        return PAX_WEB_VERSION;
    }

    public static String getJettyVersion() {
        return JETTY_VERSION;
    }

    public static boolean isPaxWebSnapshotVersion() {
        return paxWebSnapshotVersion;
    }

    static {
        String paxCdiVersion = "";
        String paxWebVersion = "";
        String jettyVersion = "";
        try {
            InputStream is = Info.class.getResourceAsStream("/META-INF/pax-cdi-version.properties");
            if (is != null) {
                Properties properties = new Properties();
                properties.load(is);
                paxCdiVersion = Info.readProperty(properties, "pax.cdi.version");
                paxWebVersion = Info.readProperty(properties, "pax.web.version");
                jettyVersion = Info.readProperty(properties, "jetty.version");
            }
        }
        catch (IOException exc) {
            throw new IllegalStateException("cannot read META-INF/pax-cdi-version.properties", exc);
        }
        PAX_CDI_VERSION = paxCdiVersion;
        paxCdiSnapshotVersion = paxCdiVersion.endsWith(SNAPSHOT);
        PAX_WEB_VERSION = paxWebVersion;
        paxWebSnapshotVersion = paxWebVersion.endsWith(SNAPSHOT);
        JETTY_VERSION = jettyVersion;
    }
}

