/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.def.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ops4j.pax.exam.Customizer;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.container.def.options.AutoWrapOption;
import org.ops4j.pax.exam.container.def.options.CleanCachesOption;
import org.ops4j.pax.exam.container.def.options.ExcludeDefaultRepositoriesOption;
import org.ops4j.pax.exam.container.def.options.LocalRepositoryOption;
import org.ops4j.pax.exam.container.def.options.ProfileOption;
import org.ops4j.pax.exam.container.def.options.RawPaxRunnerOptionOption;
import org.ops4j.pax.exam.container.def.options.RepositoryOptionImpl;
import org.ops4j.pax.exam.container.def.options.VMOption;
import org.ops4j.pax.exam.container.def.options.WorkingDirectoryOption;
import org.ops4j.pax.exam.options.BootClasspathLibraryOption;
import org.ops4j.pax.exam.options.BootDelegationOption;
import org.ops4j.pax.exam.options.BundleStartLevelOption;
import org.ops4j.pax.exam.options.CustomFrameworkOption;
import org.ops4j.pax.exam.options.DebugClassLoadingOption;
import org.ops4j.pax.exam.options.FrameworkOption;
import org.ops4j.pax.exam.options.FrameworkStartLevelOption;
import org.ops4j.pax.exam.options.MavenPluginGeneratedConfigOption;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.SystemPackageOption;
import org.ops4j.pax.exam.options.SystemPropertyOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArgumentsBuilder {
    private boolean argsSetManually = false;
    private final String[] m_parsedArgs;
    private File m_workingFolder;
    private Customizer[] m_customizers;

    ArgumentsBuilder(Option ... options) {
        ArrayList<String> arguments = new ArrayList<String>();
        this.m_customizers = (Customizer[])OptionUtils.filter(Customizer.class, (Option[])options);
        this.add(arguments, this.extractArguments((MavenPluginGeneratedConfigOption[])OptionUtils.filter(MavenPluginGeneratedConfigOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((FrameworkOption[])OptionUtils.filter(FrameworkOption.class, (Option[])options)));
        this.add(arguments, ArgumentsBuilder.extractArguments((ProfileOption[])OptionUtils.filter(ProfileOption.class, (Option[])options)));
        this.add(arguments, ArgumentsBuilder.extractArguments((BootDelegationOption[])OptionUtils.filter(BootDelegationOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((SystemPackageOption[])OptionUtils.filter(SystemPackageOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((ProvisionOption[])OptionUtils.filter(ProvisionOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((RepositoryOptionImpl[])OptionUtils.filter(RepositoryOptionImpl.class, (Option[])options), (ExcludeDefaultRepositoriesOption[])OptionUtils.filter(ExcludeDefaultRepositoriesOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((AutoWrapOption[])OptionUtils.filter(AutoWrapOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((CleanCachesOption[])OptionUtils.filter(CleanCachesOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((LocalRepositoryOption[])OptionUtils.filter(LocalRepositoryOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((FrameworkStartLevelOption[])OptionUtils.filter(FrameworkStartLevelOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((BundleStartLevelOption[])OptionUtils.filter(BundleStartLevelOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((WorkingDirectoryOption[])OptionUtils.filter(WorkingDirectoryOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((RawPaxRunnerOptionOption[])OptionUtils.filter(RawPaxRunnerOptionOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((SystemPropertyOption[])OptionUtils.filter(SystemPropertyOption.class, (Option[])options), (VMOption[])OptionUtils.filter(VMOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((BootClasspathLibraryOption[])OptionUtils.filter(BootClasspathLibraryOption.class, (Option[])options)));
        this.add(arguments, this.extractArguments((DebugClassLoadingOption[])OptionUtils.filter(DebugClassLoadingOption.class, (Option[])options)));
        this.add(arguments, this.defaultArguments());
        this.m_parsedArgs = arguments.toArray(new String[arguments.size()]);
    }

    public String[] getArguments() {
        return this.m_parsedArgs;
    }

    private void add(List<String> arguments, Collection<String> argumentsToAdd) {
        if (argumentsToAdd != null && argumentsToAdd.size() > 0) {
            arguments.addAll(argumentsToAdd);
        }
    }

    private void add(List<String> arguments, String argument) {
        if (argument != null && argument.trim().length() > 0) {
            arguments.add(argument);
        }
    }

    private Collection<String> defaultArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--noConsole");
        arguments.add("--noDownloadFeedback");
        if (!this.argsSetManually) {
            arguments.add("--noArgs");
        }
        String folder = System.getProperty("java.io.tmpdir") + "/paxexam_runner_" + System.getProperty("user.name");
        arguments.add("--workingDirectory=" + this.createWorkingDirectory(folder).getAbsolutePath());
        return arguments;
    }

    private Collection<String> extractArguments(FrameworkOption[] frameworks) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (frameworks.length > 1) {
            throw new IllegalArgumentException("Configuration cannot contain more then one platform");
        }
        if (frameworks.length > 0) {
            if (frameworks[0] instanceof CustomFrameworkOption) {
                String basePlatform = ((CustomFrameworkOption)frameworks[0]).getBasePlatform();
                if (basePlatform != null && basePlatform.trim().length() > 0) {
                    arguments.add("--platform=" + basePlatform);
                }
                arguments.add("--definitionURL=" + ((CustomFrameworkOption)frameworks[0]).getDefinitionURL());
            } else {
                arguments.add("--platform=" + frameworks[0].getName());
                String version = frameworks[0].getVersion();
                if (version != null && version.trim().length() > 0) {
                    arguments.add("--version=" + version);
                }
            }
        }
        return arguments;
    }

    private Collection<String> extractArguments(MavenPluginGeneratedConfigOption[] mavenPluginGeneratedConfigOption) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (MavenPluginGeneratedConfigOption arg : mavenPluginGeneratedConfigOption) {
            URL url = arg.getURL();
            arguments.add("--args=" + url.toExternalForm());
        }
        this.argsSetManually = true;
        return arguments;
    }

    private Collection<String> extractArguments(ProvisionOption[] bundles) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (ProvisionOption bundle : bundles) {
            arguments.add(bundle.getURL());
        }
        return arguments;
    }

    private static String extractArguments(ProfileOption[] profiles) {
        StringBuilder argument = new StringBuilder();
        if (profiles != null && profiles.length > 0) {
            for (ProfileOption profile : profiles) {
                if (profile == null || profile.getProfile() == null || profile.getProfile().length() <= 0) continue;
                if (argument.length() == 0) {
                    argument.append("--profiles=");
                } else {
                    argument.append(",");
                }
                argument.append(profile.getProfile());
            }
        }
        return argument.toString();
    }

    private static String extractArguments(BootDelegationOption[] packages) {
        StringBuilder argument = new StringBuilder();
        if (packages != null && packages.length > 0) {
            for (BootDelegationOption pkg : packages) {
                if (pkg == null || pkg.getPackage() == null || pkg.getPackage().length() <= 0) continue;
                if (argument.length() == 0) {
                    argument.append("--bootDelegation=");
                } else {
                    argument.append(",");
                }
                argument.append(pkg.getPackage());
            }
        }
        return argument.toString();
    }

    private String extractArguments(SystemPackageOption[] packages) {
        StringBuilder argument = new StringBuilder();
        if (packages != null && packages.length > 0) {
            for (SystemPackageOption pkg : packages) {
                if (pkg == null || pkg.getPackage() == null || pkg.getPackage().length() <= 0) continue;
                if (argument.length() == 0) {
                    argument.append("--systemPackages=");
                } else {
                    argument.append(",");
                }
                argument.append(pkg.getPackage());
            }
        }
        return argument.toString();
    }

    private String extractArguments(SystemPropertyOption[] systemProperties, VMOption[] vmOptions) {
        StringBuilder argument = new StringBuilder();
        if (systemProperties != null && systemProperties.length > 0) {
            for (SystemPropertyOption systemPropertyOption : systemProperties) {
                if (systemPropertyOption == null || systemPropertyOption.getKey() == null || systemPropertyOption.getKey().trim().length() <= 0) continue;
                if (argument.length() > 0) {
                    argument.append(" ");
                }
                argument.append("-D").append(systemPropertyOption.getKey()).append("=").append(systemPropertyOption.getValue());
            }
        }
        if (vmOptions != null && vmOptions.length > 0) {
            for (VMOption vMOption : vmOptions) {
                if (vMOption == null || vMOption.getOption() == null || vMOption.getOption().trim().length() <= 0) continue;
                if (argument.length() > 0) {
                    argument.append(" ");
                }
                argument.append(vMOption.getOption());
            }
        }
        if (argument.length() > 0) {
            argument.insert(0, "--vmOptions=");
        }
        return argument.toString();
    }

    private String extractArguments(RepositoryOptionImpl[] repositoriesOptions, ExcludeDefaultRepositoriesOption[] excludeDefaultRepositoriesOptions) {
        boolean excludeDefaultRepositories;
        StringBuilder argument = new StringBuilder();
        boolean bl = excludeDefaultRepositories = excludeDefaultRepositoriesOptions.length > 0;
        if (repositoriesOptions.length > 0 || excludeDefaultRepositories) {
            argument.append("--repositories=");
            if (!excludeDefaultRepositories) {
                argument.append("+");
            }
            for (int i = 0; i < repositoriesOptions.length; ++i) {
                argument.append(repositoriesOptions[i].getRepository());
                if (i + 1 >= repositoriesOptions.length) continue;
                argument.append(",");
            }
        }
        return argument.toString();
    }

    private String extractArguments(AutoWrapOption[] autoWrapOptions) {
        if (autoWrapOptions.length > 0) {
            return "--autoWrap";
        }
        return null;
    }

    private String extractArguments(CleanCachesOption[] cleanCachesOption) {
        if (cleanCachesOption.length > 0) {
            return "--clean";
        }
        return null;
    }

    private String extractArguments(LocalRepositoryOption[] localRepositoryOptions) {
        if (localRepositoryOptions != null && localRepositoryOptions.length > 0) {
            LocalRepositoryOption local = localRepositoryOptions[0];
            return "--localRepository=" + local.getLocalRepositoryPath();
        }
        return null;
    }

    private List<String> extractArguments(RawPaxRunnerOptionOption[] paxrunnerOptions) {
        boolean excludeDefaultRepositories;
        ArrayList<String> args = new ArrayList<String>();
        boolean bl = excludeDefaultRepositories = paxrunnerOptions.length > 0;
        if (paxrunnerOptions.length > 0 || excludeDefaultRepositories) {
            for (int i = 0; i < paxrunnerOptions.length; ++i) {
                args.add(paxrunnerOptions[i].getOption().trim());
            }
        }
        return args;
    }

    private String extractArguments(WorkingDirectoryOption[] workingDirectoryOptions) {
        if (workingDirectoryOptions.length > 0) {
            return "--workingDirectory=" + this.createWorkingDirectory(workingDirectoryOptions[0].getWorkingDirectory()).getAbsolutePath();
        }
        return null;
    }

    private Collection<String> extractArguments(FrameworkStartLevelOption[] startLevels) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (startLevels.length > 1) {
            throw new IllegalArgumentException("Configuration cannot contain more then one framework start level");
        }
        if (startLevels.length > 0) {
            arguments.add("--startLevel=" + startLevels[0].getStartLevel());
        }
        return arguments;
    }

    private Collection<String> extractArguments(BundleStartLevelOption[] startLevels) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (startLevels.length > 1) {
            throw new IllegalArgumentException("Configuration cannot contain more then one bundle start level");
        }
        if (startLevels.length > 0) {
            arguments.add("--bundleStartLevel=" + startLevels[0].getStartLevel());
        }
        return arguments;
    }

    private Collection<String> extractArguments(BootClasspathLibraryOption[] libraries) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (BootClasspathLibraryOption library : libraries) {
            if (library.isBeforeFramework()) {
                arguments.add("--bcp/p=" + library.getLibraryUrl().getURL());
                continue;
            }
            arguments.add("--bcp/a=" + library.getLibraryUrl().getURL());
        }
        return arguments;
    }

    private String extractArguments(DebugClassLoadingOption[] debugClassLoadingOptions) {
        if (debugClassLoadingOptions.length > 0) {
            return "--debugClassLoading";
        }
        return null;
    }

    private File createWorkingDirectory(String workingDirectoryOption) {
        File workDir = new File(workingDirectoryOption);
        if (!workDir.exists()) {
            workDir.mkdirs();
        }
        if (this.m_workingFolder == null) {
            this.m_workingFolder = workDir;
        }
        return workDir;
    }

    public File getWorkingFolder() {
        return this.m_workingFolder;
    }

    public Customizer[] getCustomizers() {
        return this.m_customizers;
    }
}

