/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.def.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.exam.container.def.internal.PaxRunnerTestContainer;

public class TestContainerSemaphore {
    private static final Log LOG = LogFactory.getLog(PaxRunnerTestContainer.class);
    private File m_workingFolder;

    public TestContainerSemaphore(File workingFolder) {
        this.m_workingFolder = workingFolder;
    }

    public boolean acquire() {
        if (this.lockExists()) {
            LOG.error((Object)("Blame ! Acquire lock for new Pax Runner instance failed at " + this.getLockFile().getAbsolutePath()));
            this.appendToFile("! Tried to acquire this on " + new Date().toString());
            return false;
        }
        LOG.info((Object)("Acquire lock for new Pax Runner instance on " + this.getLockFile().getAbsolutePath()));
        this.appendToFile("Created on " + new Date().toString());
        return true;
    }

    public void release() {
        this.getLockFile().delete();
    }

    public File getLockFile() {
        return new File(this.m_workingFolder, "paxexam.lock");
    }

    private boolean lockExists() {
        return this.getLockFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToFile(String s) {
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(this.getLockFile(), true);
            fw.write(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

