/*
 * Copyright 2012 Harald Wellmann.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ops4j.pax.exam.spi.reactors;

import java.util.List;

import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactorFactory;

/**
 * This reactor factory creates a test reactor which is used for the entire test suite. The
 * reactor is shut down lazily when the virtual machine exits.
 * 
 * @since 3.0.0
 */
public class PerSuite implements StagedExamReactorFactory
{

    public StagedExamReactor create( List<TestContainer> containers, List<TestProbeBuilder> probes )
    {
        return new PerSuiteStagedReactor( containers, probes );
    }
}