/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ops4j.pax.exam.ConfigurationFactory;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.spi.ExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactorFactory;
import org.ops4j.spi.ServiceProviderFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExamReactor
implements ExamReactor {
    private static Logger LOG = LoggerFactory.getLogger(DefaultExamReactor.class);
    private final List<Option[]> m_configurations;
    private final List<TestProbeBuilder> m_probes;
    private final TestContainerFactory m_factory;
    private final ExamSystem m_system;

    public DefaultExamReactor(ExamSystem system, TestContainerFactory factory) {
        this.m_system = system;
        this.m_configurations = new ArrayList<Option[]>();
        this.m_probes = new ArrayList<TestProbeBuilder>();
        this.m_factory = factory;
    }

    @Override
    public synchronized void addConfiguration(Option[] configuration) {
        this.m_configurations.add(configuration);
    }

    @Override
    public synchronized void addProbe(TestProbeBuilder builder) {
        this.m_probes.add(builder);
    }

    @Override
    public synchronized StagedExamReactor stage(StagedExamReactorFactory factory) throws IOException {
        LOG.debug("Staging reactor with probes: " + this.m_probes.size() + " using strategy: " + factory);
        ArrayList<TestContainer> containers = new ArrayList<TestContainer>();
        if (this.m_configurations.isEmpty()) {
            List configurationFactories = ServiceProviderFinder.findServiceProviders(ConfigurationFactory.class);
            for (ConfigurationFactory cf : configurationFactories) {
                Option[] configuration = cf.createConfiguration();
                this.addConfiguration(configuration);
            }
        }
        if (this.m_configurations.isEmpty()) {
            LOG.debug("No configuration given. Setting an empty one.");
            this.m_configurations.add(CoreOptions.options((Option[])new Option[0]));
        }
        for (Option[] config : this.m_configurations) {
            containers.addAll(Arrays.asList(this.m_factory.create(this.m_system.fork(config))));
        }
        return factory.create(containers, this.m_probes);
    }
}

