/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.jdbc.config.impl.DataSourcePublisher;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceManager
implements ManagedServiceFactory {
    private Logger LOG = LoggerFactory.getLogger(DataSourcePublisher.class);
    private BundleContext context;
    private Map<String, ServiceTracker> trackers;
    private Map<String, DataSourcePublisher> publishers;

    public DataSourceManager(BundleContext context) {
        this.context = context;
        this.trackers = new HashMap<String, ServiceTracker>();
        this.publishers = new HashMap<String, DataSourcePublisher>();
    }

    private String getFilter(String driverClass, String driverName) throws ConfigurationException {
        if (driverClass == null && driverName == null) {
            throw new ConfigurationException(null, "Could not determine driver to use. Specify either osgi.jdbc.driver.class or osgi.jdbc.driver.name");
        }
        ArrayList<String> filterList = new ArrayList<String>();
        filterList.add("objectClass=" + DataSourceFactory.class.getName());
        if (driverClass != null) {
            filterList.add("osgi.jdbc.driver.class=" + driverClass);
        }
        if (driverName != null) {
            filterList.add("osgi.jdbc.driver.name=" + driverName);
        }
        String filter = this.andFilter(filterList);
        return filter;
    }

    private String andFilter(List<String> filterList) {
        StringBuilder filter = new StringBuilder();
        if (filterList.size() > 1) {
            filter.append("(&");
        }
        for (String filterPart : filterList) {
            filter.append("(" + filterPart + ")");
        }
        if (filterList.size() > 1) {
            filter.append(")");
        }
        return filter.toString();
    }

    public String getName() {
        return "datasource";
    }

    public void updated(String pid, Dictionary config) throws ConfigurationException {
        this.deleted(pid);
        if (config == null) {
            return;
        }
        String driverClass = (String)config.get("osgi.jdbc.driver.class");
        String driverName = (String)config.get("osgi.jdbc.driver.name");
        String filter = this.getFilter(driverClass, driverName);
        try {
            DataSourcePublisher publisher = this.createPublisher(config);
            DataSourceFactoryTracker customizer = new DataSourceFactoryTracker(publisher);
            Filter filterO = this.context.createFilter(filter);
            ServiceTracker tracker = new ServiceTracker(this.context, filterO, (ServiceTrackerCustomizer)customizer);
            tracker.open();
            this.trackers.put(pid, tracker);
            this.publishers.put(pid, publisher);
        }
        catch (InvalidSyntaxException e) {
            this.LOG.warn("Invalid filter for DataSource config from pid " + pid, (Throwable)e);
        }
    }

    protected DataSourcePublisher createPublisher(Dictionary config) {
        return new DataSourcePublisher(this.context, config);
    }

    public void deleted(String pid) {
        DataSourcePublisher publisher;
        ServiceTracker tracker = this.trackers.get(pid);
        if (tracker != null) {
            tracker.close();
            this.trackers.remove(pid);
        }
        if ((publisher = this.publishers.get(pid)) != null) {
            publisher.unpublish();
        }
    }

    private final class DataSourceFactoryTracker
    implements ServiceTrackerCustomizer {
        private final DataSourcePublisher publisher;

        private DataSourceFactoryTracker(DataSourcePublisher publisher) {
            this.publisher = publisher;
        }

        public void removedService(ServiceReference reference, Object service) {
            this.publisher.unpublish();
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public Object addingService(ServiceReference reference) {
            DataSourceFactory dsf = (DataSourceFactory)DataSourceManager.this.context.getService(reference);
            this.publisher.publish(dsf);
            DataSourceManager.this.context.ungetService(reference);
            return null;
        }
    }
}

