/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourcePublisher {
    static final String DATASOURCE_TYPE = "dataSourceType";
    private static final String JNDI_SERVICE_NAME = "osgi.jndi.service.name";
    private static final String[] NOT_FORWARDED_KEYS = new String[]{"service.pid", "osgi.jdbc.driver.class", "osgi.jdbc.driver.name", "dataSourceName", "service.factoryPid", "felix.fileinstall.filename", "aries.managed", "osgi.jndi.service.name", "dataSourceType"};
    private Logger LOG = LoggerFactory.getLogger(DataSourcePublisher.class);
    private Set<String> ignoredKeys;
    private Collection<Closeable> closeables;
    private Collection<ServiceRegistration> serviceRegs;
    private BundleContext context;
    private Dictionary config;

    public DataSourcePublisher(BundleContext context, Dictionary config) {
        this.context = context;
        this.config = config;
        Object dsName = this.config.get("dataSourceName");
        if (dsName != null && this.config.get(JNDI_SERVICE_NAME) == null) {
            this.config.put(JNDI_SERVICE_NAME, dsName);
        }
        this.ignoredKeys = new HashSet<String>(Arrays.asList(NOT_FORWARDED_KEYS));
        this.closeables = new ArrayList<Closeable>();
        this.serviceRegs = new ArrayList<ServiceRegistration>();
    }

    public void publish(DataSourceFactory dsf) {
        String typeName = (String)this.config.get(DATASOURCE_TYPE);
        Class<?> type = this.getType(typeName);
        try {
            Object ds = this.createDs(dsf, type);
            if (ds instanceof Closeable) {
                this.closeables.add((Closeable)ds);
            }
            ServiceRegistration reg = this.context.registerService(type.getName(), ds, this.config);
            this.serviceRegs.add(reg);
        }
        catch (SQLException e) {
            this.LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    private Class<?> getType(String typeName) {
        if (typeName == null || DataSource.class.getSimpleName().equals(typeName)) {
            return DataSource.class;
        }
        if (ConnectionPoolDataSource.class.getSimpleName().equals(typeName)) {
            return ConnectionPoolDataSource.class;
        }
        if (XADataSource.class.getSimpleName().equals(typeName)) {
            return XADataSource.class;
        }
        throw new IllegalArgumentException("Problem in DataSource config : dataSourceType must be one of " + DataSource.class.getSimpleName() + "," + ConnectionPoolDataSource.class.getSimpleName() + "," + XADataSource.class.getSimpleName());
    }

    private Object createDs(DataSourceFactory dsf, Class<?> type) throws SQLException {
        Properties props = this.toProperties(this.config);
        if (type == DataSource.class) {
            return dsf.createDataSource(props);
        }
        if (type == ConnectionPoolDataSource.class) {
            return dsf.createConnectionPoolDataSource(props);
        }
        return dsf.createXADataSource(props);
    }

    private Properties toProperties(Dictionary dict) {
        Properties props = new Properties();
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (this.ignoredKeys.contains(key)) continue;
            props.put(key, dict.get(key));
        }
        return props;
    }

    public void unpublish() {
        for (ServiceRegistration reg : this.serviceRegs) {
            reg.unregister();
        }
        for (Closeable closeable : this.closeables) {
            this.safeClose(closeable);
        }
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.LOG.warn("Error closing " + closeable.getClass() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

