/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.common.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.transaction.TransactionManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceFactoryTracker
extends ServiceTracker<DataSourceFactory, ServiceRegistration<DataSourceFactory>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataSourceFactoryTracker.class);
    protected final TransactionManager tm;

    public AbstractDataSourceFactoryTracker(BundleContext context) {
        this(context, null);
    }

    public AbstractDataSourceFactoryTracker(BundleContext context, TransactionManager tm) {
        super(context, DataSourceFactory.class, null);
        this.tm = tm;
    }

    public ServiceRegistration addingService(ServiceReference<DataSourceFactory> reference) {
        if (reference.getProperty("pooled") != null) {
            return null;
        }
        return this.createAndRegisterPooledFactory(reference);
    }

    protected TransactionManager getTransactionManager() {
        return this.tm;
    }

    private ServiceRegistration<DataSourceFactory> createAndRegisterPooledFactory(ServiceReference<DataSourceFactory> reference) {
        LOG.debug("Registering PooledDataSourceFactory");
        DataSourceFactory dsf = (DataSourceFactory)this.context.getService(reference);
        DataSourceFactory pdsf = this.createPooledDatasourceFactory(dsf);
        Dictionary<String, Object> props = this.createPropsForPoolingDataSourceFactory(reference);
        LOG.debug("Registering PooledDataSourceFactory: " + props);
        return this.context.registerService(DataSourceFactory.class, (Object)pdsf, props);
    }

    private Dictionary<String, Object> createPropsForPoolingDataSourceFactory(ServiceReference<DataSourceFactory> reference) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        for (String key : reference.getPropertyKeys()) {
            if ("service.id".equals(key)) continue;
            ((Dictionary)props).put(key, reference.getProperty(key));
        }
        ((Dictionary)props).put("pooled", "true");
        if (this.getTransactionManager() != null) {
            ((Dictionary)props).put("xa", "true");
        }
        ((Dictionary)props).put("osgi.jdbc.driver.class", this.getPoolDriverClass(reference));
        ((Dictionary)props).put("osgi.jdbc.driver.name", this.getPoolDriverName(reference));
        return props;
    }

    private String getPoolDriverClass(ServiceReference<DataSourceFactory> reference) {
        String origName = (String)reference.getProperty("osgi.jdbc.driver.class");
        return origName + "-pool" + (this.getTransactionManager() != null ? "-xa" : "");
    }

    private String getPoolDriverName(ServiceReference<DataSourceFactory> reference) {
        String origName = (String)reference.getProperty("osgi.jdbc.driver.name");
        if (origName == null) {
            origName = (String)reference.getProperty("osgi.jdbc.driver.class");
        }
        return origName + "-pool" + (this.getTransactionManager() != null ? "-xa" : "");
    }

    protected abstract DataSourceFactory createPooledDatasourceFactory(DataSourceFactory var1);

    public void modifiedService(ServiceReference<DataSourceFactory> reference, ServiceRegistration<DataSourceFactory> reg) {
    }

    public void removedService(ServiceReference<DataSourceFactory> reference, ServiceRegistration<DataSourceFactory> reg) {
        LOG.debug("Unregistering PooledDataSourceFactory");
        reg.unregister();
        super.removedService(reference, reg);
    }
}

