/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.dbcp2.impl;

import java.util.Dictionary;
import javax.transaction.TransactionManager;
import org.ops4j.pax.jdbc.pool.dbcp2.impl.ds.PooledDataSourceFactory;
import org.ops4j.pax.jdbc.pool.dbcp2.impl.ds.XAPooledDataSourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactoryTracker
extends ServiceTracker<DataSourceFactory, ServiceRegistration> {
    private Logger LOG = LoggerFactory.getLogger(DataSourceFactoryTracker.class);
    private final TransactionManager tm;

    public DataSourceFactoryTracker(BundleContext context) {
        this(context, null);
    }

    public DataSourceFactoryTracker(BundleContext context, TransactionManager tm) {
        super(context, DataSourceFactory.class, null);
        this.tm = tm;
    }

    public ServiceRegistration addingService(ServiceReference<DataSourceFactory> reference) {
        if (reference.getProperty("pooled") != null) {
            return null;
        }
        return this.createAndRegisterPooledFactory(reference);
    }

    private ServiceRegistration<DataSourceFactory> createAndRegisterPooledFactory(ServiceReference<DataSourceFactory> reference) {
        this.LOG.debug("Registering PooledDataSourceFactory");
        DataSourceFactory dsf = (DataSourceFactory)this.context.getService(reference);
        PooledDataSourceFactory pdsf = this.tm != null ? new XAPooledDataSourceFactory(dsf, this.tm) : new PooledDataSourceFactory(dsf);
        Dictionary<String, Object> props = pdsf.createPropsForPoolingDataSourceFactory(reference);
        return this.context.registerService(DataSourceFactory.class, (Object)pdsf, props);
    }

    public void modifiedService(ServiceReference<DataSourceFactory> reference, ServiceRegistration reg) {
    }

    public void removedService(ServiceReference<DataSourceFactory> reference, ServiceRegistration reg) {
        this.context.ungetService(reference);
        reg.unregister();
    }
}

