/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.dbcp2.impl.ds;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BeanConfig {
    private Object bean;
    private Map<String, Method> setters;

    private BeanConfig(Object bean) {
        this.bean = bean;
        this.setters = BeanConfig.findSettersForBean(bean);
    }

    private static Map<String, Method> findSettersForBean(Object bean) {
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : bean.getClass().getMethods()) {
            String name = method.getName();
            if (!name.startsWith("set") || method.getParameterTypes().length != 1) continue;
            String key = name.substring(3, 4).toLowerCase() + name.substring(4);
            setters.put(key, method);
        }
        return setters;
    }

    public static void configure(Object bean, Map<String, String> props) {
        BeanConfig beanConfig = new BeanConfig(bean);
        for (String key : props.keySet()) {
            beanConfig.trySetProperty(key, props.get(key));
        }
    }

    private void trySetProperty(String key, String value) {
        try {
            Method method = this.setters.get(key);
            if (method == null) {
                throw new IllegalArgumentException("No setter in " + this.bean.getClass() + " for property " + key);
            }
            Class<?> paramClass = method.getParameterTypes()[0];
            if (paramClass == Integer.TYPE) {
                method.invoke(this.bean, (int)new Integer(value));
            } else if (paramClass == Long.TYPE) {
                method.invoke(this.bean, (long)new Long(value));
            } else if (paramClass == Boolean.TYPE) {
                method.invoke(this.bean, (boolean)new Boolean(value));
            } else if (paramClass == String.class) {
                method.invoke(this.bean, value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error setting property " + key + ":" + e.getMessage(), e);
        }
    }
}

