/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.dbcp2.impl.ds;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DataSourceConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.ops4j.pax.jdbc.pool.dbcp2.impl.ds.BeanConfig;
import org.ops4j.pax.jdbc.pool.dbcp2.impl.ds.CloseablePoolingDataSource;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledDataSourceFactory
implements DataSourceFactory {
    private static final String POOL_PREFIX = "pool.";
    private Logger LOG = LoggerFactory.getLogger(PooledDataSourceFactory.class);
    protected DataSourceFactory dsFactory;

    public PooledDataSourceFactory(DataSourceFactory dsFactory) {
        this.dsFactory = dsFactory;
    }

    public DataSource createDataSource(Properties props) throws SQLException {
        try {
            Properties dsProps = this.getNonPoolProps(props);
            Map<String, String> poolProps = this.getPoolProps(props);
            return this.createDataSourceInternal(dsProps, poolProps);
        }
        catch (Throwable e) {
            this.LOG.error("Error creating pooled datasource" + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Map<String, String> getPoolProps(Properties props) {
        HashMap<String, String> poolProps = new HashMap<String, String>();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (!key.startsWith(POOL_PREFIX)) continue;
            String strippedKey = key.substring(POOL_PREFIX.length());
            poolProps.put(strippedKey, (String)props.get(key));
        }
        return poolProps;
    }

    private Properties getNonPoolProps(Properties props) {
        Properties dsProps = new Properties();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (key.startsWith(POOL_PREFIX)) continue;
            dsProps.put(key, props.get(key));
        }
        return dsProps;
    }

    protected DataSource createDataSourceInternal(Properties props, Map<String, String> poolProps) throws SQLException {
        DataSource ds = this.dsFactory.createDataSource(props);
        DataSourceConnectionFactory connFactory = new DataSourceConnectionFactory(ds);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connFactory, null);
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)pcf);
        GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
        BeanConfig.configure(conf, poolProps);
        pool.setConfig(conf);
        return new CloseablePoolingDataSource(pool);
    }

    public Dictionary<String, Object> createPropsForPoolingDataSourceFactory(ServiceReference<DataSourceFactory> reference) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        for (String key : reference.getPropertyKeys()) {
            if ("service.id".equals(key)) continue;
            ((Dictionary)props).put(key, reference.getProperty(key));
        }
        ((Dictionary)props).put("pooled", "true");
        ((Dictionary)props).put("osgi.jdbc.driver.name", this.getPoolDriverName(reference));
        return props;
    }

    protected String getPoolDriverName(ServiceReference<DataSourceFactory> reference) {
        String origName = (String)reference.getProperty("osgi.jdbc.driver.name");
        if (origName == null) {
            origName = (String)reference.getProperty("osgi.jdbc.driver.class");
        }
        return origName + "-pool";
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        throw new SQLException("Not supported");
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Driver createDriver(Properties props) throws SQLException {
        throw new SQLException("Not supported");
    }
}

