/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.dbcp2.impl.ds;

import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.managed.DataSourceXAConnectionFactory;
import org.apache.commons.dbcp2.managed.PoolableManagedConnectionFactory;
import org.apache.commons.dbcp2.managed.TransactionRegistry;
import org.apache.commons.dbcp2.managed.XAConnectionFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.ops4j.pax.jdbc.pool.dbcp2.impl.ds.BeanConfig;
import org.ops4j.pax.jdbc.pool.dbcp2.impl.ds.CloseableManagedDataSource;
import org.ops4j.pax.jdbc.pool.dbcp2.impl.ds.PooledDataSourceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;

public class XAPooledDataSourceFactory
extends PooledDataSourceFactory {
    private TransactionManager tm;

    public XAPooledDataSourceFactory(DataSourceFactory dsFactory, TransactionManager tm) {
        super(dsFactory);
        this.tm = tm;
    }

    @Override
    protected DataSource createDataSourceInternal(Properties props, Map<String, String> poolProps) throws SQLException {
        XADataSource ds = this.dsFactory.createXADataSource(props);
        DataSourceXAConnectionFactory connFactory = new DataSourceXAConnectionFactory(this.tm, ds);
        PoolableManagedConnectionFactory pcf = new PoolableManagedConnectionFactory((XAConnectionFactory)connFactory, null);
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)pcf);
        GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
        BeanConfig.configure(conf, poolProps);
        pool.setConfig(conf);
        TransactionRegistry transactionRegistry = connFactory.getTransactionRegistry();
        return new CloseableManagedDataSource(pool, transactionRegistry);
    }

    @Override
    public Dictionary<String, Object> createPropsForPoolingDataSourceFactory(ServiceReference<DataSourceFactory> reference) {
        Dictionary<String, Object> props = super.createPropsForPoolingDataSourceFactory(reference);
        props.put("xa", "true");
        return props;
    }

    @Override
    protected String getPoolDriverName(ServiceReference<DataSourceFactory> reference) {
        return super.getPoolDriverName(reference) + "-xa";
    }
}

