/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.XMLLayout;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxLoggingConstants;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.service.internal.PaxLoggingServiceImpl;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.DefaultServiceLog;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.RegisteredService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogReaderService;

public class Activator
implements BundleActivator {
    private ServiceRegistration<?> m_RegistrationPaxLogging;
    private PaxLoggingServiceImpl m_PaxLogging;
    private RegisteredService<LogReaderService, LogReaderServiceImpl> logReaderInfo;
    private RegisteredService<EventAdminPoster, EventAdminPoster> eventAdminInfo;
    private RegisteredService<ConfigurationNotifier, ConfigurationNotifier> eventAdminConfigurationNotifierInfo;

    public void start(BundleContext bundleContext) throws Exception {
        this.sanityCheck();
        String levelName = BackendSupport.defaultLogLevel(bundleContext);
        DefaultServiceLog.setLogLevel(levelName);
        if (DefaultServiceLog.getStaticLogLevel() <= 1) {
            LogLog.setInternalDebugging(true);
        }
        this.logReaderInfo = BackendSupport.createAndRegisterLogReaderService(bundleContext);
        this.eventAdminInfo = BackendSupport.eventAdminSupport(bundleContext);
        this.eventAdminConfigurationNotifierInfo = BackendSupport.eventAdminConfigurationNotifier(bundleContext);
        this.m_PaxLogging = new PaxLoggingServiceImpl(bundleContext, this.logReaderInfo.getService(), this.eventAdminInfo.getService(), this.eventAdminConfigurationNotifierInfo.getService());
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>();
        ((Dictionary)serviceProperties).put("service.pid", "org.ops4j.pax.logging");
        ((Dictionary)serviceProperties).put("service.ranking", BackendSupport.paxLoggingServiceRanking(bundleContext));
        this.m_RegistrationPaxLogging = bundleContext.registerService(PaxLoggingConstants.LOGGING_LOGSERVICE_NAMES, (Object)this.m_PaxLogging, serviceProperties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.eventAdminInfo != null) {
            this.eventAdminInfo.close();
        }
        if (this.logReaderInfo != null) {
            this.logReaderInfo.close();
        }
        if (this.eventAdminConfigurationNotifierInfo != null) {
            this.eventAdminConfigurationNotifierInfo.close();
        }
        this.m_RegistrationPaxLogging.unregister();
        this.m_RegistrationPaxLogging = null;
        if (this.m_PaxLogging != null) {
            this.m_PaxLogging.shutdown();
            this.m_PaxLogging = null;
        }
        FallbackLogFactory.cleanup();
    }

    private void sanityCheck() {
        Bundle b1;
        Bundle paxLoggingApi = FrameworkUtil.getBundle(PaxLoggingService.class);
        Bundle paxLoggingService = FrameworkUtil.getBundle(this.getClass());
        if (paxLoggingService != (b1 = FrameworkUtil.getBundle(Logger.class))) {
            String b1Bundle = b1 == null ? "system classloader" : b1.toString();
            throw new IllegalStateException("org.apache.log4j.Logger class was loaded from " + b1Bundle + ". It should be loaded from " + paxLoggingService + ".");
        }
        Bundle b2 = FrameworkUtil.getBundle(LogManager.class);
        if (paxLoggingService != b2) {
            String b2Bundle = b2 == null ? "system classloader" : b2.toString();
            throw new IllegalStateException("org.apache.log4j.LogManager class was loaded from " + b2Bundle + ". It should be loaded from " + paxLoggingService + ".");
        }
        Bundle b3 = FrameworkUtil.getBundle(Loader.class);
        if (paxLoggingService != b3) {
            String b3Bundle = b3 == null ? "system classloader" : b3.toString();
            throw new IllegalStateException("org.apache.log4j.helpers.Loader class was loaded from " + b3Bundle + ". It should be loaded from " + paxLoggingService + ".");
        }
        Bundle b4 = FrameworkUtil.getBundle(XMLLayout.class);
        if (paxLoggingApi != b4) {
            String b4Bundle = b4 == null ? "system classloader" : b4.toString();
            throw new IllegalStateException("org.apache.log4j.xml.XMLLayout class was loaded from " + b4Bundle + ". It should be loaded from " + paxLoggingApi + ".");
        }
    }
}

