/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner;

import java.io.File;
import java.net.MalformedURLException;
import org.ops4j.pax.runner.ProvisionSchemaResolver;

public class ExtensionBasedProvisionSchemaResolver
implements ProvisionSchemaResolver {
    @Override
    public String resolve(String toResolve) {
        if (toResolve == null || toResolve.trim().length() == 0) {
            return null;
        }
        if (toResolve.matches("scan-.*:.*")) {
            return toResolve;
        }
        String options = "";
        String resolve = toResolve;
        if (toResolve.contains("@")) {
            int startOfOption = toResolve.indexOf("@");
            options = toResolve.substring(startOfOption);
            resolve = toResolve.substring(0, startOfOption);
        }
        String schema = "scan-dir";
        if (!(resolve.endsWith("/") || resolve.endsWith("\\") || resolve.contains("!/"))) {
            if (resolve.startsWith("mvn") && resolve.endsWith("pom")) {
                schema = "scan-pom";
            } else if (resolve.startsWith("mvn") || resolve.startsWith("wrap") || resolve.startsWith("war") || resolve.startsWith("war-i") || resolve.startsWith("warref") || resolve.startsWith("webbundle") || resolve.startsWith("obr") || resolve.startsWith("assembly") || resolve.startsWith("assemblyref") || resolve.startsWith("dir")) {
                schema = "scan-bundle";
            } else {
                int indexOfDot;
                int indexOfSlash = resolve.lastIndexOf("/");
                if (indexOfSlash == -1) {
                    indexOfSlash = resolve.lastIndexOf("\\");
                }
                if ((indexOfDot = resolve.lastIndexOf(".")) > indexOfSlash) {
                    schema = "scan-file";
                    if (indexOfDot < resolve.length() - 1) {
                        String extension = resolve.substring(indexOfDot + 1).toUpperCase();
                        if ("XML".equals(extension)) {
                            schema = "scan-pom";
                        } else if ("ZIP".equals(extension)) {
                            schema = "scan-dir";
                        } else if ("JAR".equals(extension) || "BUNDLE".equals(extension)) {
                            schema = "scan-bundle";
                        } else if ("OBR".equals(extension)) {
                            schema = "scan-obr";
                        } else if ("COMPOSITE".equals(extension) || "PROFILE".equals(extension)) {
                            schema = "scan-composite";
                        }
                    }
                }
            }
        }
        File file = new File(resolve);
        String resolved = resolve;
        if (file.exists()) {
            try {
                resolved = file.toURL().toExternalForm();
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        return schema + ":" + resolved + options;
    }
}

