/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.CommandLine;
import org.ops4j.pax.runner.Configuration;
import org.ops4j.pax.runner.MissingOptionException;
import org.ops4j.pax.runner.OptionResolver;
import org.ops4j.pax.runner.User;
import org.ops4j.pax.runner.commons.Info;
import org.ops4j.pax.runner.commons.properties.SystemPropertyUtils;

public class OptionResolverImpl
implements OptionResolver {
    private static final Log LOGGER = LogFactory.getLog(OptionResolverImpl.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(.*?\\$\\{)([.[^\\$]]+?)(\\}.*)");
    private final CommandLine m_commandLine;
    private final Configuration m_configuration;
    private final Map<String, String> m_cacheOptions;
    private final Map<String, String[]> m_cacheMultipleOptions;

    public OptionResolverImpl(CommandLine commandLine, Configuration configuration) {
        NullArgumentException.validateNotNull(commandLine, "Command line");
        NullArgumentException.validateNotNull(configuration, "Configuration");
        this.m_commandLine = commandLine;
        this.m_configuration = configuration;
        this.m_cacheOptions = new HashMap<String, String>();
        this.m_cacheMultipleOptions = new HashMap<String, String[]>();
    }

    @Override
    public String get(String name) {
        String executor;
        String result = SystemPropertyUtils.resolvePlaceholders(this.replacePlaceholders(this.getInternal(name)));
        if (name.equalsIgnoreCase("org.ops4j.pax.url.mvn.repositories") && (result == null || result.trim().startsWith("+"))) {
            String profiles = this.get("profiles");
            if (profiles == null || profiles.trim().length() == 0) {
                return result;
            }
            String profilesRepo = this.get("profilesRepositories");
            if (profilesRepo == null || profilesRepo.trim().length() == 0) {
                return result;
            }
            if (result == null || result.trim().length() == 0) {
                return "+" + profilesRepo;
            }
            return result + "," + profilesRepo;
        }
        if (name.equalsIgnoreCase("org.ops4j.pax.runner.platform.useAbsoluteFilePaths") && result == null && "inProcess".equalsIgnoreCase(executor = this.get("executor"))) {
            return "TRUE";
        }
        return result;
    }

    private String getInternal(String name) {
        String alias;
        NullArgumentException.validateNotEmpty(name, "Option name");
        LOGGER.trace((Object)("Resolving option [" + name + "]"));
        if (this.m_cacheOptions.containsKey(name)) {
            String value = this.m_cacheOptions.get(name);
            LOGGER.trace((Object)("Option [" + name + "] resolved to [" + value + "]"));
            return value;
        }
        String value = this.getOption(name);
        if ((value == null || value.trim().length() == 0) && (alias = this.m_configuration.getProperty("alias." + name)) != null && alias.trim().length() > 0) {
            String[] aliases;
            for (String entry : aliases = alias.split(",")) {
                value = this.getOption(entry);
                if (value == null) {
                    value = this.getOption(entry.toLowerCase());
                }
                if (value != null) break;
            }
        }
        if (value != null && "choose".equalsIgnoreCase(value)) {
            Info.print("your " + name.toLowerCase() + "? ");
            value = User.ask();
        }
        if (value == null || value.trim().length() == 0) {
            value = this.m_configuration.getProperty("default." + name);
        }
        if (value != null && value.trim().length() > 0) {
            String[] segments = value.split(",");
            StringBuilder newValue = new StringBuilder();
            for (String segment : segments) {
                String replacer;
                if (newValue.length() > 0) {
                    newValue.append(",");
                }
                if ((replacer = this.m_configuration.getProperty("alias." + name + "." + segment)) != null) {
                    newValue.append(replacer);
                    continue;
                }
                newValue.append(segment);
            }
            value = newValue.toString();
        }
        this.m_cacheOptions.put(name, value);
        LOGGER.trace((Object)("Option [" + name + "] resolved to [" + value + "]"));
        return value;
    }

    private String getOption(String key) {
        String value = this.m_commandLine.getOption(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    @Override
    public String getMandatory(String name) {
        String value = this.get(name);
        if (value == null) {
            throw new MissingOptionException(name);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] getMultiple(String name) {
        String alias;
        NullArgumentException.validateNotEmpty(name, "Option name");
        LOGGER.trace((Object)("Resolving option [" + name + "]"));
        if (this.m_cacheMultipleOptions.containsKey(name)) {
            Object[] values = this.m_cacheMultipleOptions.get(name);
            LOGGER.trace((Object)("Option [" + name + "] resolved to [" + Arrays.toString(values) + "]"));
            return values;
        }
        Object[] values = this.m_commandLine.getMultipleOption(name);
        if (values.length == 0 && (alias = this.m_configuration.getProperty("alias." + name)) != null && alias.trim().length() > 0) {
            void var7_11;
            String[] aliases;
            String[] arr$ = aliases = alias.split(",");
            int len$ = arr$.length;
            boolean bl = false;
            while (var7_11 < len$) {
                String entry = arr$[var7_11];
                values = this.m_commandLine.getMultipleOption(entry);
                if (values.length == 0) {
                    values = this.m_commandLine.getMultipleOption(entry.toLowerCase());
                }
                if (values.length == 0) break;
                ++var7_11;
            }
        }
        if (values.length > 0) {
            int index = 0;
            for (String string : values) {
                String[] segments = string.split(",");
                StringBuilder newValue = new StringBuilder();
                for (String segment : segments) {
                    String replacer;
                    if (newValue.length() > 0) {
                        newValue.append(",");
                    }
                    if ((replacer = this.m_configuration.getProperty("alias." + name + "." + segment)) != null) {
                        newValue.append(replacer);
                        continue;
                    }
                    newValue.append(segment);
                }
                values[index] = newValue.toString();
                ++index;
            }
        }
        this.m_cacheMultipleOptions.put(name, (String[])values);
        LOGGER.trace((Object)("Option [" + name + "] resolved to [" + Arrays.toString(values) + "]"));
        return values;
    }

    private String replacePlaceholders(String value) {
        if (value == null) {
            return null;
        }
        String replaced = value;
        String rest = value;
        while (rest != null && rest.length() != 0) {
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(rest);
            if (matcher.matches() && matcher.groupCount() == 3) {
                String placeholderName = matcher.group(2);
                String placeholderValue = this.get(placeholderName);
                if (placeholderValue != null) {
                    replaced = replaced.replace("${" + placeholderName + "}", placeholderValue);
                }
                rest = matcher.group(3);
                continue;
            }
            rest = null;
        }
        if (replaced != null && !replaced.equals(value)) {
            replaced = this.replacePlaceholders(replaced);
        }
        return replaced;
    }
}

