/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.runner.platform.DaemonCommons;
import org.ops4j.pax.runner.platform.DefaultJavaRunner;
import org.ops4j.pax.runner.platform.PlatformException;
import org.ops4j.pax.runner.platform.StoppableJavaRunner;

public class DaemonStartRunner
implements StoppableJavaRunner {
    private static final Log LOG = LogFactory.getLog(DaemonStartRunner.class);
    private static final long DEFAULT_DAEMON_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private Thread shutdownHook = null;
    private boolean continueAwait = true;
    private final StoppableJavaRunner m_delegate;
    private final CountDownLatch latch;
    private long daemonTimeout;

    public DaemonStartRunner(String timeoutStr) {
        if (timeoutStr != null) {
            try {
                this.daemonTimeout = Integer.parseInt(timeoutStr);
            }
            catch (NumberFormatException e) {
                this.daemonTimeout = DEFAULT_DAEMON_TIMEOUT;
            }
        } else {
            this.daemonTimeout = DEFAULT_DAEMON_TIMEOUT;
        }
        this.latch = new CountDownLatch(1);
        this.m_delegate = new DefaultJavaRunner(true){

            @Override
            public void waitForExit() {
                DaemonStartRunner.this.latch.countDown();
                super.waitForExit();
            }
        };
    }

    @Override
    public void exec(final String[] vmOptions, final String[] classpath, final String mainClass, final String[] programOptions, final String javaHome, final File workingDir, final String[] environmentVariables) throws PlatformException {
        new Thread("DaemonStartRunner"){

            @Override
            public void run() {
                try {
                    DaemonStartRunner.this.m_delegate.exec(vmOptions, classpath, mainClass, programOptions, javaHome, workingDir, environmentVariables);
                }
                catch (PlatformException e) {
                    throw new RuntimeException(e);
                }
            }
        }.start();
        try {
            this.latch.await();
            Thread.sleep(this.daemonTimeout);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        this.startShutdownFileMonitor(workingDir);
    }

    @Override
    public void exec(String[] vmOptions, String[] classpath, String mainClass, String[] programOptions, String javaHome, File workingDir) throws PlatformException {
        this.exec(vmOptions, classpath, mainClass, programOptions, javaHome, workingDir, new String[0]);
    }

    @Override
    public void shutdown() {
        this.m_delegate.shutdown();
    }

    private void startShutdownFileMonitor(final File workingDir) {
        new Thread("ShutdownFileMonitor"){

            @Override
            public void run() {
                DaemonStartRunner.this.createLockFile(workingDir);
                DaemonStartRunner.this.shutdownHook = DaemonStartRunner.this.createShutdownHook();
                Runtime.getRuntime().addShutdownHook(DaemonStartRunner.this.shutdownHook);
                while (DaemonStartRunner.this.continueAwait) {
                    File file = new File(workingDir, ".runner.platform.daemon.shutdown");
                    if (file.exists()) {
                        file.delete();
                        DaemonStartRunner.this.stop(workingDir);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        DaemonStartRunner.this.stop(workingDir);
                    }
                }
                LOG.trace((Object)"Finished awaiting...");
            }
        }.start();
    }

    private Thread createShutdownHook() {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.trace((Object)"Executing shutdown hook...");
                DaemonStartRunner.this.shutdown();
            }
        }, "Pax Runner Daemon Shutdown Hook");
    }

    private void createLockFile(File workingDir) {
        File lock = new File(DaemonCommons.getRunnerHomeDir(workingDir, true), ".runner.platform.daemon.lock");
        if (lock.exists()) {
            throw new RuntimeException(".runner.platform.daemon.lock exists. Please make sure that the Pax Runner daemon is not already running.");
        }
        try {
            lock.createNewFile();
            lock.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void removeLockFile(File workingDir) {
        File lock = new File(DaemonCommons.getRunnerHomeDir(workingDir, true), ".runner.platform.daemon.lock");
        if (lock.exists()) {
            lock.delete();
        }
    }

    private void stopAwait() {
        this.continueAwait = false;
    }

    public void stop(File workingDir) {
        this.stopAwait();
        this.removeLockFile(workingDir);
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            LOG.trace((Object)"Removed Shutdown Hook.");
            this.shutdownHook.run();
            this.shutdownHook = null;
        } else {
            this.shutdown();
        }
    }
}

