/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.aether.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.repository.internal.DefaultServiceLocator;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.ops4j.pax.url.aether.internal.LogAdapter;
import org.ops4j.pax.url.aether.internal.ManualWagonProvider;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class AetherBasedResolver {
    private static final Log LOG = LogFactory.getLog(AetherBasedResolver.class);
    public static final String LATEST_VERSION_RANGE = "(0.0,]";
    private final String m_localRepo;
    private final String[] m_repositories;
    private final RepositorySystem m_repoSystem;

    public AetherBasedResolver(String local, String[] repos) {
        this.m_localRepo = local;
        this.m_repositories = repos;
        this.m_repoSystem = this.newRepositorySystem();
    }

    public InputStream resolve(String groupId, String artifactId, String extension, String version) {
        try {
            version = this.mapLatestToRange(version);
            RepositorySystemSession session = this.newSession(this.m_repoSystem);
            Dependency dependency = new Dependency(new DefaultArtifact(groupId, artifactId, extension, version), "provided");
            CollectRequest collectRequest = this.prepareResolveRequest(dependency);
            DependencyNode node = this.m_repoSystem.collectDependencies(session, collectRequest).getRoot();
            File resolved = this.m_repoSystem.resolveDependencies(session, node, null).get(0).getArtifact().getFile();
            LOG.info("Resolved (" + dependency.toString() + ") as " + resolved.getAbsolutePath());
            return new FileInputStream(resolved);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (DependencyCollectionException e) {
            throw new RuntimeException(e);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
    }

    private CollectRequest prepareResolveRequest(Dependency dependency) {
        LOG.info("Resolving using Aether Session: " + dependency.toString());
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        int i = 0;
        for (String repos : this.m_repositories) {
            RemoteRepository central = new RemoteRepository("repos" + i++, "default", repos);
            collectRequest.addRepository(central);
        }
        return collectRequest;
    }

    private String mapLatestToRange(String version) {
        if (version != null && version.equals("LATEST")) {
            version = LATEST_VERSION_RANGE;
        }
        return version;
    }

    private RepositorySystemSession newSession(RepositorySystem system) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(this.m_localRepo);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(localRepo));
        return session;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.setServices(WagonProvider.class, new ManualWagonProvider());
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.setService(Logger.class, LogAdapter.class);
        return locator.getService(RepositorySystem.class);
    }
}

