/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionConverter
extends AbstractConfigurationConverter
implements ParameterizedConfigurationConverter {
    @Override
    public boolean canConvert(Class type) {
        return Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        return this.fromConfiguration(converterLookup, configuration, type, null, baseType, classLoader, expressionEvaluator, listener);
    }

    @Override
    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class<?> type, Type[] typeArguments, Class<?> baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Collection<Object> retValue = this.fromExpression(configuration, expressionEvaluator);
        if (retValue != null) {
            if (retValue instanceof Object[]) {
                Collection<Object> collection = this.newCollection(configuration, type, classLoader);
                Collections.addAll(collection, (Object[])retValue);
                retValue = collection;
            } else if (retValue instanceof String && (!((Object)retValue).equals(configuration.getValue()) || "".equals(retValue))) {
                PlexusConfiguration syntheticConfiguration = this.toConfiguration(configuration.getName(), (String)((Object)retValue));
                retValue = this.fromChildren(converterLookup, syntheticConfiguration, type, typeArguments, baseType, classLoader, expressionEvaluator, listener);
            } else {
                this.failIfNotTypeCompatible(retValue, type, configuration);
            }
        } else {
            retValue = this.fromChildren(converterLookup, configuration, type, typeArguments, baseType, classLoader, expressionEvaluator, listener);
        }
        return retValue;
    }

    private PlexusConfiguration toConfiguration(String name, String value) {
        String[] tokens;
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(name);
        for (String token : tokens = value != null && value.length() > 0 ? value.split(",", -1) : new String[]{}) {
            configuration.addChild("#", token);
        }
        return configuration;
    }

    private Object fromChildren(ConverterLookup converterLookup, PlexusConfiguration configuration, Class<?> type, Type[] typeArguments, Class<?> baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Collection<Object> retValue = this.newCollection(configuration, type, classLoader);
        Class<?> elementType = this.getElementType(typeArguments);
        for (int i = 0; i < configuration.getChildCount(); ++i) {
            PlexusConfiguration c = configuration.getChild(i);
            Class<?> childType = this.getChildType(c, elementType, baseType, classLoader);
            ConfigurationConverter converter = converterLookup.lookupConverterForType(childType);
            Object object = converter.fromConfiguration(converterLookup, c, childType, baseType, classLoader, expressionEvaluator, listener);
            retValue.add(object);
        }
        return retValue;
    }

    private Class<?> getElementType(Type[] typeArguments) {
        Type typeArgument;
        Class elementType = null;
        if (typeArguments != null && typeArguments.length > 0 && (typeArgument = typeArguments[0]) instanceof Class && !Object.class.equals((Object)typeArgument)) {
            elementType = (Class)typeArgument;
        }
        return elementType;
    }

    private Class<?> getChildType(PlexusConfiguration childConfiguration, Class<?> elementType, Class<?> baseType, ClassLoader classLoader) throws ComponentConfigurationException {
        String configEntry = childConfiguration.getName();
        String name = this.fromXML(configEntry);
        Class<Object> childType = this.getClassForImplementationHint(null, childConfiguration, classLoader);
        if (childType == null && name.indexOf(46) > 0) {
            try {
                childType = classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (childType == null) {
            String className;
            String baseTypeName = baseType.getName();
            int lastDot = baseTypeName.lastIndexOf(46);
            if (lastDot == -1) {
                className = name;
            } else {
                String basePackage = baseTypeName.substring(0, lastDot);
                className = basePackage + "." + StringUtils.capitalizeFirstLetter(name);
            }
            try {
                childType = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                if (elementType != null) {
                    childType = elementType;
                }
                if (childConfiguration.getChildCount() == 0) {
                    childType = String.class;
                }
                throw new ComponentConfigurationException("Error loading class '" + className + "'", (Throwable)e);
            }
        }
        return childType;
    }

    private Collection<Object> newCollection(PlexusConfiguration configuration, Class<?> type, ClassLoader classLoader) throws ComponentConfigurationException {
        Object collection;
        Class implementation = this.getClassForImplementationHint(type, configuration, classLoader);
        if (Modifier.isAbstract(implementation.getModifiers())) {
            collection = this.getDefaultCollection(implementation);
        } else {
            try {
                collection = this.instantiateObject(implementation);
            }
            catch (ComponentConfigurationException e) {
                if (e.getFailedConfiguration() == null) {
                    e.setFailedConfiguration(configuration);
                }
                throw e;
            }
        }
        try {
            return (Collection)Collection.class.cast(collection);
        }
        catch (ClassCastException e) {
            throw new ComponentConfigurationException(configuration, "The class " + implementation.getName() + " used to configure the property '" + configuration.getName() + "' is not a collection", e);
        }
    }

    protected Collection getDefaultCollection(Class collectionType) {
        AbstractCollection retValue = null;
        if (List.class.isAssignableFrom(collectionType)) {
            retValue = new ArrayList();
        } else if (SortedSet.class.isAssignableFrom(collectionType)) {
            retValue = new TreeSet();
        } else if (Set.class.isAssignableFrom(collectionType)) {
            retValue = new HashSet();
        }
        return retValue;
    }
}

