/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.repository.internal.MavenServiceLocator;
import org.ops4j.pax.url.maven.commons.MavenConfiguration;
import org.ops4j.pax.url.maven.commons.MavenRepositoryURL;
import org.ops4j.pax.url.mvn.internal.LogAdapter;
import org.ops4j.pax.url.mvn.internal.ManualWagonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManagerFactory;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.MirrorSelector;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResolutionException;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;
import org.sonatype.aether.util.repository.DefaultProxySelector;
import org.sonatype.aether.version.Version;

public class AetherBasedResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AetherBasedResolver.class);
    private static final String LATEST_VERSION_RANGE = "(0.0,]";
    private static final String REPO_TYPE = "default";
    private final RepositorySystem m_repoSystem;
    private final MavenConfiguration m_config;
    private final MirrorSelector m_mirrorSelector;
    private final ProxySelector m_proxySelector;

    public AetherBasedResolver(MavenConfiguration configuration) throws MalformedURLException {
        this.m_config = configuration;
        this.m_repoSystem = this.newRepositorySystem();
        this.m_proxySelector = this.selectProxies();
        this.m_mirrorSelector = this.selectMirrors();
    }

    private void assignProxyAndMirrors(List<RemoteRepository> remoteRepos) {
        RemoteRepository mirror;
        HashMap map = new HashMap();
        HashMap<String, RemoteRepository> naming = new HashMap<String, RemoteRepository>();
        for (RemoteRepository r : remoteRepos) {
            naming.put(r.getId(), r);
            r.setProxy(this.m_proxySelector.getProxy(r));
            mirror = this.m_mirrorSelector.getMirror(r);
            if (mirror == null) continue;
            String key = mirror.getId();
            naming.put(key, mirror);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            List mirrored = (List)map.get(key);
            mirrored.add(r.getId());
        }
        for (String mirrorId : map.keySet()) {
            mirror = (RemoteRepository)naming.get(mirrorId);
            ArrayList<RemoteRepository> mirroedRepos = new ArrayList<RemoteRepository>();
            for (String rep : (List)map.get(mirrorId)) {
                mirroedRepos.add((RemoteRepository)naming.get(rep));
            }
            mirror.setMirroredRepositories(mirroedRepos);
            remoteRepos.removeAll(mirroedRepos);
            remoteRepos.add(0, mirror);
        }
    }

    private List<MavenRepositoryURL> getRemoteRepositories(MavenConfiguration configuration) throws MalformedURLException {
        ArrayList<MavenRepositoryURL> r = new ArrayList<MavenRepositoryURL>();
        for (MavenRepositoryURL s : configuration.getRepositories()) {
            r.add(s);
        }
        return r;
    }

    private ProxySelector selectProxies() {
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        Map<String, Map<String, String>> proxies = this.m_config.getProxySettings(new String[0]);
        for (Map<String, String> proxy : proxies.values()) {
            String nonProxyHosts = proxy.get("nonProxyHosts");
            Proxy proxyObj = new Proxy(proxy.get("protocol"), proxy.get("host"), this.toInt(proxy.get("port")), this.getAuthentication(proxy));
            proxySelector.add(proxyObj, nonProxyHosts);
        }
        return proxySelector;
    }

    private MirrorSelector selectMirrors() {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        Map<String, Map<String, String>> mirrors = this.m_config.getMirrors();
        for (String mirrorName : mirrors.keySet()) {
            Map<String, String> mirror = mirrors.get(mirrorName);
            String mirrorOf = mirror.get("mirrorOf");
            String url = mirror.get("url");
            selector.add(mirrorName, url, null, false, mirrorOf, "*");
        }
        return selector;
    }

    private List<RemoteRepository> selectRepositories(List<MavenRepositoryURL> repos) {
        ArrayList<RemoteRepository> list = new ArrayList<RemoteRepository>();
        for (MavenRepositoryURL r : repos) {
            if (r.isMulti()) {
                this.addSubDirs(list, r.getFile());
                continue;
            }
            this.addRepo(list, r);
        }
        return list;
    }

    private void addSubDirs(List<RemoteRepository> list, File parentDir) {
        if (!parentDir.isDirectory()) {
            LOG.debug("Repository marked with @multi does not resolve to a directory: " + parentDir);
            return;
        }
        for (File repo : parentDir.listFiles()) {
            if (!repo.isDirectory()) continue;
            try {
                String repoURI = repo.toURI().toString() + "@id=" + repo.getName();
                LOG.debug("Adding repo from inside multi dir: " + repoURI);
                this.addRepo(list, new MavenRepositoryURL(repoURI));
            }
            catch (MalformedURLException e) {
                LOG.error("Error resolving repo url of a multi repo " + repo.toURI());
            }
        }
    }

    private void addRepo(List<RemoteRepository> list, MavenRepositoryURL repoUrl) {
        list.add(new RemoteRepository(repoUrl.getId(), REPO_TYPE, repoUrl.getURL().toExternalForm()));
    }

    public InputStream resolve(String groupId, String artifactId, String classifier, String extension, String version) throws IOException {
        File resolved = this.resolveFile(groupId, artifactId, classifier, extension, version);
        return new FileInputStream(resolved);
    }

    public File resolveFile(String groupId, String artifactId, String classifier, String extension, String version) throws IOException {
        List<RemoteRepository> remoteRepos = this.selectRepositories(this.getRemoteRepositories(this.m_config));
        this.assignProxyAndMirrors(remoteRepos);
        RepositorySystemSession session = this.newSession();
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
        File resolved = this.resolve(session, remoteRepos, artifact);
        LOG.debug("Resolved ({}) as {}", (Object)((Object)artifact).toString(), (Object)resolved.getAbsolutePath());
        return resolved;
    }

    private File resolve(RepositorySystemSession session, List<RemoteRepository> remoteRepos, Artifact artifact) throws IOException {
        try {
            artifact = this.resolveLatestVersionRange(session, remoteRepos, artifact);
            return this.m_repoSystem.resolveArtifact(session, new ArtifactRequest(artifact, remoteRepos, null)).getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            LOG.warn("Error resolving artifact" + artifact.toString() + ":" + e.getMessage(), (Throwable)e);
            throw new IOException("Error resolving artifact " + artifact.toString() + ": " + e.getMessage());
        }
        catch (RepositoryException e) {
            throw new IOException("Error resolving artifact " + artifact.toString(), e);
        }
    }

    private Artifact resolveLatestVersionRange(RepositorySystemSession session, List<RemoteRepository> remoteRepos, Artifact artifact) throws VersionRangeResolutionException {
        VersionRangeResult versionResult;
        if (artifact.getVersion().equals("LATEST") && (versionResult = this.m_repoSystem.resolveVersionRange(session, new VersionRangeRequest(artifact = artifact.setVersion(LATEST_VERSION_RANGE), remoteRepos, null))) != null) {
            Version v = versionResult.getHighestVersion();
            if (v != null) {
                artifact = artifact.setVersion(v.toString());
            } else {
                throw new VersionRangeResolutionException(versionResult, "Not highest version found for " + artifact);
            }
        }
        return artifact;
    }

    private RepositorySystemSession newSession() {
        assert (this.m_config != null) : "local repository cannot be null";
        File local = this.m_config.getLocalRepository().getFile();
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(local);
        session.setLocalRepositoryManager(this.m_repoSystem.newLocalRepositoryManager(localRepo));
        session.setMirrorSelector(this.m_mirrorSelector);
        session.setProxySelector(this.m_proxySelector);
        String updatePolicy = this.m_config.getGlobalUpdatePolicy();
        if (null != updatePolicy) {
            session.setUpdatePolicy(updatePolicy);
        }
        return session;
    }

    private Authentication getAuthentication(Map<String, String> proxy) {
        if (proxy.containsKey("user")) {
            return new Authentication(proxy.get("user"), proxy.get("pass"));
        }
        return null;
    }

    private int toInt(String intStr) {
        return Integer.parseInt(intStr);
    }

    private RepositorySystem newRepositorySystem() {
        MavenServiceLocator locator = new MavenServiceLocator();
        locator.setServices(WagonProvider.class, new ManualWagonProvider(this.m_config.getTimeout()));
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.setService(LocalRepositoryManagerFactory.class, SimpleLocalRepositoryManagerFactory.class);
        locator.setService(org.sonatype.aether.spi.log.Logger.class, LogAdapter.class);
        return locator.getService(RepositorySystem.class);
    }
}

