/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.apache.maven.wagon.providers.http.LightweightHttpWagon;
import org.apache.maven.wagon.providers.http.LightweightHttpsWagon;
import org.sonatype.aether.connector.wagon.WagonProvider;

public class ManualWagonProvider
implements WagonProvider {
    private int timeout;

    public ManualWagonProvider(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public Wagon lookup(String roleHint) throws Exception {
        if ("file".equals(roleHint)) {
            return new FileWagon();
        }
        if ("http".equals(roleHint)) {
            LightweightHttpWagon lightweightHttpWagon = new LightweightHttpWagon();
            lightweightHttpWagon.setTimeout(this.timeout);
            return lightweightHttpWagon;
        }
        if ("https".equals(roleHint)) {
            LightweightHttpsWagon lightweightHttpWagon = new LightweightHttpsWagon(){

                @Override
                public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
                    String username = this.getRepository().getUsername();
                    String password = this.getRepository().getPassword();
                    if (username != null && password != null) {
                        this.getHttpHeaders().put(username, password);
                    }
                    super.fillInputData(inputData);
                }
            };
            lightweightHttpWagon.setTimeout(this.timeout);
            return lightweightHttpWagon;
        }
        return null;
    }

    @Override
    public void release(Wagon wagon) {
    }
}

