/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.ServletHandler;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceRequestWrapper;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceResponseWrapper;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpServiceServletHandler
extends ServletHandler {
    private static final String METHOD_TRACE = "TRACE";
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceServletHandler.class);
    private final HttpContext httpContext;

    HttpServiceServletHandler(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        this.httpContext = httpContext;
        this.setEnsureDefaultServlet(false);
    }

    @Override
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpServiceResponseWrapper responseWrapper;
        HttpServiceRequestWrapper requestWrapper;
        if (request.getMethod().equals(METHOD_TRACE)) {
            throw new ServletException("HTTP TRACE method is disabled");
        }
        if (baseRequest.getAttribute("org.ops4j.pax.web.service.internal.jettyRequest") == null) {
            baseRequest.setAttribute("org.ops4j.pax.web.service.internal.jettyRequest", request);
        }
        if (this.httpContext.handleSecurity(requestWrapper = new HttpServiceRequestWrapper(request), responseWrapper = new HttpServiceResponseWrapper(response))) {
            LOG.debug("handling request {}, {}", (Object)requestWrapper, (Object)responseWrapper);
            super.doHandle(target, baseRequest, request, response);
        } else {
            LOG.debug("Security constraint not fulfilled");
            if (!responseWrapper.isCommitted()) {
                if (!responseWrapper.isStatusSet()) {
                    responseWrapper.sendError(401);
                } else {
                    responseWrapper.sendError(responseWrapper.getStatus());
                }
            }
        }
    }
}

