/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.elements;

import java.io.File;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.ops4j.pax.web.service.spi.config.JspConfiguration;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.events.ServletEventData;
import org.ops4j.pax.web.service.spi.util.Path;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;

public class ServletModel
extends ElementModel<Servlet, ServletEventData> {
    private final String alias;
    private boolean aliasCopiedToPatterns = false;
    private String[] urlPatterns;
    private String name;
    private Map<String, String> initParams;
    private Integer loadOnStartup;
    private Boolean asyncSupported;
    private MultipartConfigElement multipartConfigElement;
    private Servlet servlet;
    private final Class<? extends Servlet> servletClass;
    private boolean resourceServlet = false;
    private boolean jspServlet = false;
    private String jspFile;
    private String basePath = null;
    private URL baseFileUrl = null;
    private String rawPath = null;
    private String[] errorDeclarations;
    private ErrorPageModel errorPageModel;
    private boolean dynamic = false;
    private boolean overridable = false;
    private String runAs;
    private final Map<String, String> roleLinks = new HashMap<String, String>();
    private boolean servletSecurityPresent = false;

    public ServletModel(String alias, String servletName, Servlet servlet, Class<? extends Servlet> servletClass, ServiceReference<Servlet> reference) {
        this.alias = alias;
        this.name = servletName;
        this.servlet = servlet;
        this.servletClass = servletClass;
        this.setElementReference(reference);
    }

    public ServletModel(String alias, Servlet servlet, Dictionary<?, ?> initParams, Integer loadOnStartup, Boolean asyncSupported) {
        this(alias, null, null, Utils.toMap(initParams), loadOnStartup, asyncSupported, null, servlet, null, null, null, false, null);
    }

    public ServletModel(String servletName, String[] urlPatterns, Servlet servlet, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig) {
        this(null, urlPatterns, servletName, Utils.toMap(initParams), loadOnStartup, asyncSupported, multiPartConfig, servlet, null, null, null, false, null);
    }

    public ServletModel(String[] urlPatterns, Class<? extends Servlet> servletClass, Dictionary<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig) {
        this(null, urlPatterns, null, Utils.toMap(initParams), loadOnStartup, asyncSupported, multiPartConfig, null, servletClass, null, null, false, null);
    }

    private ServletModel(String alias, String[] urlPatterns, String name, Map<String, String> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multipartConfigElement, Servlet servlet, Class<? extends Servlet> servletClass, ServiceReference<Servlet> reference, Supplier<? extends Servlet> supplier, boolean resourceServlet, Bundle registeringBundle) {
        Class<? extends Servlet> c;
        this.alias = alias;
        this.urlPatterns = Path.normalizePatterns(urlPatterns);
        this.initParams = initParams == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(initParams);
        this.loadOnStartup = loadOnStartup;
        this.asyncSupported = asyncSupported;
        this.multipartConfigElement = multipartConfigElement;
        this.servlet = servlet;
        this.servletClass = servletClass;
        this.setElementReference(reference);
        this.setElementSupplier(supplier);
        this.setRegisteringBundle(registeringBundle);
        this.resourceServlet = resourceServlet;
        if (name == null) {
            name = this.initParams.get("servlet-name");
            this.initParams.remove("servlet-name");
        }
        if (name == null && (c = this.getActualClass()) != null) {
            name = c.getName();
        }
        if (name == null && !resourceServlet) {
            name = UUID.randomUUID().toString();
        }
        this.name = name;
        if ((this.urlPatterns == null || this.urlPatterns.length == 0) && this.alias != null) {
            this.urlPatterns = "/".equals(this.alias) ? (resourceServlet ? new String[]{"/"} : new String[]{"/*"}) : new String[]{this.alias + "/*"};
            this.aliasCopiedToPatterns = true;
        }
    }

    @Override
    public Boolean performValidation() throws Exception {
        if (this.isValid != null) {
            return this.isValid;
        }
        int sources = 0;
        if (!this.resourceServlet) {
            sources += this.servlet != null ? 1 : 0;
            sources += this.servletClass != null ? 1 : 0;
            sources += this.getElementReference() != null ? 1 : 0;
            if ((sources += this.getElementSupplier() != null ? 1 : 0) == 0) {
                this.dtoFailureCode = 6;
                throw new IllegalArgumentException("Servlet Model must specify one of: servlet instance, servlet class, servlet supplier or service reference");
            }
            if (sources != 1) {
                this.dtoFailureCode = 6;
                throw new IllegalArgumentException("Servlet Model should specify a servlet uniquely as instance, class, supplier or service reference");
            }
        }
        if (this.alias == null && (this.urlPatterns == null || this.urlPatterns.length == 0)) {
            this.dtoFailureCode = 6;
            throw new IllegalArgumentException("Neither alias nor URL patterns array is specified");
        }
        if (this.alias != null && this.urlPatterns != null && this.urlPatterns.length > 0 && !this.aliasCopiedToPatterns) {
            this.dtoFailureCode = 6;
            throw new IllegalArgumentException("Can't specify both alias and URL patterns array");
        }
        if (this.alias != null) {
            if (!this.alias.startsWith("/")) {
                this.dtoFailureCode = 6;
                throw new IllegalArgumentException("Alias does not start with slash (/)");
            }
            if (this.alias.length() > 1 && this.alias.endsWith("/")) {
                this.dtoFailureCode = 6;
                throw new IllegalArgumentException("Alias should not end with slash (/)");
            }
            if ("".equals(this.alias.trim())) {
                this.dtoFailureCode = 6;
                throw new IllegalArgumentException("Alias should not be empty");
            }
        }
        if (this.urlPatterns != null) {
            for (String url : this.urlPatterns) {
                if ("/".equals(url) || "/*".equals(url)) continue;
                if (url.endsWith("/*") && (url.substring(0, url.length() - 2).contains("*") || !url.startsWith("/"))) {
                    this.dtoFailureCode = 6;
                    throw new IllegalArgumentException("URL Pattern \"" + url + "\" is not a valid path pattern");
                }
                if (!url.startsWith("*.") || !url.substring(2).contains("/") && !url.substring(2).contains("*")) continue;
                this.dtoFailureCode = 6;
                throw new IllegalArgumentException("URL Pattern \"" + url + "\" is not a valid extension pattern");
            }
        }
        if (this.resourceServlet) {
            if (this.rawPath == null && this.basePath == null && this.baseFileUrl == null) {
                this.dtoFailureCode = 6;
                throw new IllegalArgumentException("Base path or base directory is required for resource servlets");
            }
            sources = 0;
            sources += this.rawPath != null ? 1 : 0;
            sources += this.basePath != null ? 1 : 0;
            if ((sources += this.baseFileUrl != null ? 1 : 0) != 1) {
                this.dtoFailureCode = 6;
                throw new IllegalArgumentException("Only one base (resource base or base directory) is allowed for resource servlets");
            }
        }
        if (this.errorDeclarations != null && this.errorDeclarations.length > 0) {
            ErrorPageModel epm = new ErrorPageModel(this.errorDeclarations);
            epm.setRegisteringBundle(this.getRegisteringBundle());
            String errorPageExact = null;
            String errorPagePrefix = null;
            String errorPageExtension = null;
            for (String url : this.urlPatterns) {
                if (url.startsWith("/") && !url.endsWith("/*")) {
                    errorPageExact = url;
                    break;
                }
                if (errorPagePrefix == null && url.startsWith("/") && url.endsWith("/*")) {
                    errorPagePrefix = "/*".equals(url) ? this.generateRandomErrorPage() : url.substring(0, url.length() - 2) + this.generateRandomErrorPage();
                }
                if (errorPageExtension != null || !url.startsWith("*.")) continue;
                errorPageExtension = "error" + url.substring(2);
            }
            if (errorPageExact != null) {
                epm.setLocation(errorPageExact);
            } else if (errorPagePrefix != null) {
                epm.setLocation(errorPagePrefix);
            } else if (errorPageExtension != null) {
                epm.setLocation(errorPageExtension);
            }
            epm.isValid();
            this.errorPageModel = epm;
        }
        if (this.jspFile != null) {
            if (!this.jspFile.startsWith("/")) {
                this.jspFile = "/" + this.jspFile;
            }
            this.initParams.put("jspFile", this.jspFile);
        }
        if (this.multipartConfigElement != null && this.multipartConfigElement.getLocation() != null && System.getSecurityManager() != null && !this.getRegisteringBundle().hasPermission((Object)new FilePermission(this.multipartConfigElement.getLocation(), "read,write,delete"))) {
            this.dtoFailureCode = 8;
            throw new IllegalArgumentException("No Write permission to " + this.multipartConfigElement.getLocation());
        }
        this.dtoFailureCode = -1;
        return Boolean.TRUE;
    }

    private String generateRandomErrorPage() {
        return String.format("/error-%s", UUID.randomUUID());
    }

    public static URL getFileUrlIfAccessible(String base) {
        try {
            URL baseUrl = new URL(base);
            File f = new File(baseUrl.toURI());
            if (!f.isDirectory()) {
                return null;
            }
            return f.toURI().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    @Override
    public void register(WhiteboardWebContainerView view) {
        if (!this.isResourceServlet()) {
            view.registerServlet(this);
        } else {
            view.registerResources(this);
        }
    }

    @Override
    public void unregister(WhiteboardWebContainerView view) {
        if (!this.isResourceServlet()) {
            view.unregisterServlet(this);
        } else {
            view.unregisterResources(this);
        }
    }

    @Override
    public ServletEventData asEventData() {
        ServletEventData data = new ServletEventData(this.alias, this.name, this.urlPatterns, this.servlet);
        this.setCommonEventProperties(data);
        data.setResourceServlet(this.resourceServlet);
        data.setJspServlet(this.jspServlet);
        data.setJspFile(this.jspFile);
        if (this.resourceServlet) {
            if (this.rawPath != null) {
                data.setPath(this.rawPath);
            } else if (this.basePath != null) {
                data.setPath(this.basePath);
            } else if (this.baseFileUrl != null) {
                data.setPath(this.baseFileUrl.toExternalForm());
            }
        }
        return data;
    }

    @Override
    public int compareTo(ElementModel<Servlet, ServletEventData> o) {
        int superCompare = super.compareTo(o);
        if (superCompare == 0 && o instanceof ServletModel) {
            return this.name.compareTo(((ServletModel)o).name);
        }
        return superCompare;
    }

    public String getAlias() {
        return this.alias;
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public void setUrlPatterns(String[] urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public Integer getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(Integer loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public Boolean getAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncSupported(Boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public MultipartConfigElement getMultipartConfigElement() {
        return this.multipartConfigElement;
    }

    public void setMultipartConfigElement(MultipartConfigElement multipartConfigElement) {
        this.multipartConfigElement = multipartConfigElement;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public Class<? extends Servlet> getServletClass() {
        return this.servletClass;
    }

    public Class<? extends Servlet> getActualClass() {
        if (this.servletClass != null) {
            return this.servletClass;
        }
        if (this.servlet != null) {
            return this.servlet.getClass();
        }
        if (this.getElementSupplier() != null) {
            Servlet s = (Servlet)this.getElementSupplier().get();
            return s.getClass();
        }
        if (this.getElementReference() != null) {
            return Servlet.class;
        }
        return null;
    }

    public boolean isResourceServlet() {
        return this.resourceServlet;
    }

    public boolean isJspServlet() {
        return this.jspServlet;
    }

    public void setJspServlet(boolean jspServlet) {
        this.jspServlet = jspServlet;
    }

    public void setJspFile(String jspFile) {
        this.jspFile = jspFile;
    }

    private void setOverridable(boolean overridable) {
        this.overridable = overridable;
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setBaseFileUrl(URL baseFileUrl) {
        this.baseFileUrl = baseFileUrl;
    }

    public URL getBaseFileUrl() {
        return this.baseFileUrl;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public void setRawPath(String rawPath) {
        this.rawPath = rawPath;
    }

    private void setErrorDeclarations(String[] errorDeclarations) {
        this.errorDeclarations = errorDeclarations;
        if (errorDeclarations != null && (this.urlPatterns == null || this.urlPatterns.length == 0) && this.alias == null) {
            this.urlPatterns = new String[]{this.generateRandomErrorPage()};
            if (Servlet.class.getName().equals(this.name)) {
                this.name = this.urlPatterns[0];
            }
        }
    }

    public ErrorPageModel getErrorPageModel() {
        return this.errorPageModel;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public String getRunAs() {
        return this.runAs;
    }

    public void setRunAs(String runAs) {
        this.runAs = runAs;
    }

    public Map<String, String> getRoleLinks() {
        return this.roleLinks;
    }

    public void setServletSecurityPresent(boolean servletSecurityPresent) {
        this.servletSecurityPresent = servletSecurityPresent;
    }

    public boolean isServletSecurityPresent() {
        return this.servletSecurityPresent;
    }

    public void configureJspServlet(JspConfiguration config) {
        if (config != null) {
            if (this.initParams.get("scratchdir") == null) {
                OsgiContextModel ocm = this.getContextModels().get(0);
                this.initParams.put("scratchdir", config.getJspScratchDir(ocm));
            }
            this.initParams.putIfAbsent("development", "false");
            this.initParams.putIfAbsent("suppressSmap", "true");
            this.initParams.putIfAbsent("classdebuginfo", "false");
        }
    }

    public ResourceDTO toResourceDTO() {
        ResourceDTO dto = new ResourceDTO();
        dto.servletContextId = 0L;
        String[] stringArray = dto.patterns = this.urlPatterns == null ? new String[]{} : new String[this.urlPatterns.length];
        if (this.urlPatterns != null) {
            System.arraycopy(this.urlPatterns, 0, dto.patterns, 0, this.urlPatterns.length);
        }
        if (this.rawPath != null) {
            dto.prefix = this.rawPath;
        } else if (this.basePath != null) {
            dto.prefix = this.basePath;
        } else if (this.baseFileUrl != null) {
            dto.prefix = this.baseFileUrl.toExternalForm();
        }
        dto.serviceId = this.getServiceId();
        return dto;
    }

    public FailedResourceDTO toFailedResourceDTO(int dtoFailureCode) {
        FailedResourceDTO dto = new FailedResourceDTO();
        dto.servletContextId = 0L;
        String[] stringArray = dto.patterns = this.urlPatterns == null ? new String[]{} : new String[this.urlPatterns.length];
        if (this.urlPatterns != null) {
            System.arraycopy(this.urlPatterns, 0, dto.patterns, 0, this.urlPatterns.length);
        }
        if (this.rawPath != null) {
            dto.prefix = this.rawPath;
        } else if (this.basePath != null) {
            dto.prefix = this.basePath;
        } else if (this.baseFileUrl != null) {
            dto.prefix = this.baseFileUrl.toExternalForm();
        }
        dto.serviceId = this.getServiceId();
        dto.failureReason = dtoFailureCode;
        return dto;
    }

    public ServletDTO toServletDTO() {
        ServletDTO dto = new ServletDTO();
        dto.name = this.name;
        dto.asyncSupported = this.asyncSupported != null && this.asyncSupported != false;
        dto.initParams = new HashMap<String, String>(this.initParams);
        dto.servletContextId = 0L;
        String[] stringArray = dto.patterns = this.urlPatterns == null ? new String[]{} : new String[this.urlPatterns.length];
        if (this.urlPatterns != null) {
            System.arraycopy(this.urlPatterns, 0, dto.patterns, 0, this.urlPatterns.length);
        }
        boolean bl = dto.multipartEnabled = this.multipartConfigElement != null;
        if (dto.multipartEnabled) {
            dto.multipartFileSizeThreshold = this.multipartConfigElement.getFileSizeThreshold();
            dto.multipartLocation = this.multipartConfigElement.getLocation();
            dto.multipartMaxFileSize = this.multipartConfigElement.getMaxFileSize();
            dto.multipartMaxRequestSize = this.multipartConfigElement.getMaxRequestSize();
        }
        dto.serviceId = this.getServiceId();
        dto.servletInfo = null;
        return dto;
    }

    public FailedServletDTO toFailedServletDTO(int dtoFailureCode) {
        FailedServletDTO dto = new FailedServletDTO();
        dto.name = this.name;
        dto.asyncSupported = this.asyncSupported != null && this.asyncSupported != false;
        dto.initParams = new HashMap<String, String>(this.initParams);
        dto.servletContextId = 0L;
        String[] stringArray = dto.patterns = this.urlPatterns == null ? new String[]{} : new String[this.urlPatterns.length];
        if (this.urlPatterns != null) {
            System.arraycopy(this.urlPatterns, 0, dto.patterns, 0, this.urlPatterns.length);
        }
        boolean bl = dto.multipartEnabled = this.multipartConfigElement != null;
        if (dto.multipartEnabled) {
            dto.multipartFileSizeThreshold = this.multipartConfigElement.getFileSizeThreshold();
            dto.multipartLocation = this.multipartConfigElement.getLocation();
            dto.multipartMaxFileSize = this.multipartConfigElement.getMaxFileSize();
            dto.multipartMaxRequestSize = this.multipartConfigElement.getMaxRequestSize();
        }
        dto.serviceId = this.getServiceId();
        dto.servletInfo = null;
        dto.failureReason = dtoFailureCode;
        return dto;
    }

    @Override
    public String toString() {
        return "ServletModel{id=" + this.getId() + ",name='" + this.name + "'" + (this.alias == null ? "" : ",alias='" + this.alias + "'") + (this.urlPatterns == null ? "" : ",urlPatterns=" + Arrays.toString(this.urlPatterns)) + (this.servlet == null ? "" : ",servlet=" + this.servlet) + (this.servletClass == null ? "" : ",servletClass=" + this.servletClass) + ",contexts=" + this.getContextModelsInfo() + "}";
    }

    public static class Builder {
        private String alias;
        private String[] urlPatterns;
        private String servletName;
        private Map<String, String> initParams;
        private Integer loadOnStartup;
        private Boolean asyncSupported;
        private MultipartConfigElement multipartConfigElement;
        private String[] errorDeclarations;
        private Servlet servlet;
        private Class<? extends Servlet> servletClass;
        private ServiceReference<Servlet> reference;
        private Supplier<? extends Servlet> supplier;
        private final List<OsgiContextModel> list = new LinkedList<OsgiContextModel>();
        private Bundle bundle;
        private int rank;
        private long serviceId;
        private boolean resourceServlet = false;
        private boolean jspServlet = false;
        private String jspFile;
        private String resourcePath;
        private boolean overridable;
        private String runAs;
        private final Map<String, String> roleLinks = new HashMap<String, String>();

        public Builder() {
        }

        public Builder(String servletName) {
            this.servletName = servletName;
        }

        public Builder withAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder withUrlPatterns(String[] urlPatterns) {
            this.urlPatterns = urlPatterns;
            return this;
        }

        public Builder withServletName(String servletName) {
            this.servletName = servletName;
            return this;
        }

        public Builder withInitParams(Map<String, String> initParams) {
            this.initParams = initParams;
            return this;
        }

        public Builder withLoadOnStartup(Integer loadOnStartup) {
            this.loadOnStartup = loadOnStartup;
            return this;
        }

        public Builder withAsyncSupported(Boolean asyncSupported) {
            this.asyncSupported = asyncSupported;
            return this;
        }

        public Builder withMultipartConfigElement(MultipartConfigElement multipartConfigElement) {
            this.multipartConfigElement = multipartConfigElement;
            return this;
        }

        public Builder withServlet(Servlet servlet) {
            this.servlet = servlet;
            return this;
        }

        public Builder withServletClass(Class<? extends Servlet> servletClass) {
            this.servletClass = servletClass;
            return this;
        }

        public Builder withServletReference(ServiceReference<Servlet> reference) {
            this.reference = reference;
            return this;
        }

        public Builder withServletReference(Bundle bundle, ServiceReference<Servlet> reference) {
            this.bundle = bundle;
            this.reference = reference;
            return this;
        }

        public Builder withServletSupplier(Supplier<? extends Servlet> supplier) {
            this.supplier = supplier;
            return this;
        }

        public Builder withOsgiContextModel(OsgiContextModel osgiContextModel) {
            this.list.add(osgiContextModel);
            return this;
        }

        public Builder withOsgiContextModels(Collection<OsgiContextModel> osgiContextModels) {
            this.list.addAll(osgiContextModels);
            return this;
        }

        public Builder withRegisteringBundle(Bundle bundle) {
            this.bundle = bundle;
            return this;
        }

        public Builder withServiceRankAndId(int rank, long id) {
            this.rank = rank;
            this.serviceId = id;
            return this;
        }

        public Builder resourceServlet(boolean resourceServlet) {
            this.resourceServlet = resourceServlet;
            return this;
        }

        public Builder jspServlet(boolean jspServlet) {
            this.jspServlet = jspServlet;
            return this;
        }

        public Builder withRawPath(String path) {
            this.resourcePath = path;
            return this;
        }

        public Builder withErrorDeclarations(String[] errorDeclarations) {
            this.errorDeclarations = errorDeclarations;
            return this;
        }

        public Builder withServletJspFile(String jspFile) {
            this.jspFile = jspFile;
            this.jspServlet = true;
            return this;
        }

        public Builder setOverridable(boolean overridable) {
            this.overridable = overridable;
            return this;
        }

        public Builder setRunAs(String role) {
            this.runAs = role;
            return this;
        }

        public Builder addRoleLink(String name, String link) {
            this.roleLinks.put(name, link);
            return this;
        }

        public ServletModel build() {
            ServletModel model = new ServletModel(this.alias, this.urlPatterns, this.servletName, this.initParams, this.loadOnStartup, this.asyncSupported, this.multipartConfigElement, this.servlet, this.servletClass, this.reference, this.supplier, this.resourceServlet, this.bundle);
            this.list.forEach(model::addContextModel);
            model.setServiceRank(this.rank);
            model.setServiceId(this.serviceId);
            model.setRawPath(this.resourcePath);
            model.setErrorDeclarations(this.errorDeclarations);
            model.setJspServlet(this.jspServlet);
            model.setJspFile(this.jspFile);
            model.setOverridable(this.overridable);
            model.setRunAs(this.runAs);
            model.getRoleLinks().putAll(this.roleLinks);
            return model;
        }
    }
}

