/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiInitializedFilter
implements Filter {
    public static final Logger LOG = LoggerFactory.getLogger(OsgiInitializedFilter.class);
    private final Filter filter;
    private final ServletContext servletContext;
    private Pattern[] filterPatterns = null;

    public OsgiInitializedFilter(Filter filter, FilterModel model, ServletContext servletSpecificContext) {
        String[] regexPatterns;
        this.filter = filter;
        this.servletContext = servletSpecificContext;
        if (model != null && model.getMappingsPerDispatcherTypes().size() == 1 && (regexPatterns = model.getMappingsPerDispatcherTypes().get(0).getRegexPatterns()) != null && regexPatterns.length > 0) {
            LOG.debug("Preparing RegEx based filter for {}", (Object)model);
            this.filterPatterns = new Pattern[regexPatterns.length];
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String pattern : regexPatterns) {
                try {
                    patterns.add(Pattern.compile(pattern));
                }
                catch (PatternSyntaxException e) {
                    LOG.warn("Problem compiling filter RegEx pattern \"{}\". Skipping", (Object)pattern);
                }
            }
            if (patterns.size() > 0) {
                this.filterPatterns = patterns.toArray(new Pattern[0]);
            } else {
                LOG.warn("No RegEx pattern can be compiled. Filter will match all the requests");
            }
        }
    }

    public void init(final FilterConfig config) throws ServletException {
        if (this.filter == null) {
            return;
        }
        this.filter.init(new FilterConfig(){

            public String getFilterName() {
                return config.getFilterName();
            }

            public ServletContext getServletContext() {
                return OsgiInitializedFilter.this.servletContext;
            }

            public String getInitParameter(String name) {
                return config.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return config.getInitParameterNames();
            }
        });
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filterPatterns != null) {
            boolean match = false;
            if (request instanceof HttpServletRequest) {
                String uri = ((HttpServletRequest)request).getRequestURI();
                if (((HttpServletRequest)request).getQueryString() != null) {
                    uri = uri + "?" + ((HttpServletRequest)request).getQueryString();
                }
                for (Pattern p : this.filterPatterns) {
                    if (!p.matcher(uri).matches()) continue;
                    match = true;
                    break;
                }
            } else {
                match = true;
            }
            if (match) {
                this.filter.doFilter(request, response, chain);
            } else {
                chain.doFilter(request, response);
            }
        } else if (this.filter == null) {
            chain.doFilter(request, response);
        } else {
            this.filter.doFilter(request, response, chain);
        }
    }

    public void destroy() {
        this.filter.destroy();
    }

    public Filter getDelegate() {
        return this.filter;
    }
}

